/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.lang;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Library {
    private static final Logger log = LoggerFactory.getLogger(Library.class);
    private static final Map<String, List<String>> _props = new ConcurrentHashMap<String, List<String>>();

    private Library() {
    }

    public static String getProperty(String key) {
        List<String> valList = _props.get(key);
        String v = valList != null && valList.size() > 0 ? valList.get(0) : null;
        try {
            return v != null || key == null || key.length() == 0 ? v : System.getProperty(key);
        }
        catch (SecurityException ex) {
            return null;
        }
    }

    public static String getProperty(String key, String def) {
        List<String> valList = _props.get(key);
        String v = valList != null && valList.size() > 0 ? valList.get(0) : null;
        try {
            return v != null ? v : System.getProperty(key, def);
        }
        catch (SecurityException ex) {
            return def;
        }
    }

    public static String setProperty(String key, String value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException();
        }
        LinkedList<String> vals = new LinkedList<String>();
        vals.add(value);
        List prev = _props.put(key, vals);
        return prev != null && prev.size() > 0 ? (String)prev.get(0) : null;
    }

    public static int getIntProperty(String key, int defVal) {
        String val = Library.getProperty(key);
        if (val != null) {
            try {
                return Integer.parseInt(val);
            }
            catch (Throwable t) {
                log.warn("Failed to parse " + key + ": not an integer, " + val);
            }
        }
        return defVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> addProperty(String key, String value) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException();
        }
        Map<String, List<String>> map = _props;
        synchronized (map) {
            List<String> old = _props.get(key);
            if (old == null) {
                old = new LinkedList<String>();
            }
            old.add(value);
            return _props.put(key, old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> addProperties(String key, List<String> values) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException();
        }
        Map<String, List<String>> map = _props;
        synchronized (map) {
            List<String> old = _props.get(key);
            if (old == null) {
                old = new LinkedList<String>();
            }
            old.addAll(values);
            return _props.put(key, old);
        }
    }

    public static List<String> setProperties(String key, List<String> values) {
        if (key == null) {
            throw new NullPointerException();
        }
        if (key.length() == 0) {
            throw new IllegalArgumentException();
        }
        return _props.put(key, new LinkedList<String>(values));
    }

    public static List<String> getProperties(String key) {
        return _props.get(key);
    }
}

