/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Set;
import org.zkoss.lang.Objects;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdentityHashSet<T>
extends AbstractSet<T>
implements Set<T>,
Cloneable,
Serializable {
    private static final long serialVersionUID = 20060622L;
    private transient IdentityHashMap<T, Object> _map;

    public IdentityHashSet() {
        this._map = new IdentityHashMap();
    }

    public IdentityHashSet(Collection<T> c) {
        this._map = new IdentityHashMap(Math.max(c.size() * 4 / 3, 16));
        this.addAll(c);
    }

    public IdentityHashSet(int expectedMaxSize) {
        this._map = new IdentityHashMap(expectedMaxSize);
    }

    @Override
    public Iterator<T> iterator() {
        return this._map.keySet().iterator();
    }

    @Override
    public int size() {
        return this._map.size();
    }

    @Override
    public boolean isEmpty() {
        return this._map.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this._map.containsKey(o);
    }

    @Override
    public boolean add(T o) {
        return this._map.put(o, Objects.UNKNOWN) == null;
    }

    @Override
    public boolean remove(Object o) {
        return this._map.remove(o) == Objects.UNKNOWN;
    }

    @Override
    public void clear() {
        this._map.clear();
    }

    public Object clone() {
        try {
            IdentityHashSet newSet = (IdentityHashSet)super.clone();
            newSet._map = (IdentityHashMap)this._map.clone();
            return newSet;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this._map.size());
        for (T key : this._map.keySet()) {
            s.writeObject(key);
        }
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        int size = s.readInt();
        this._map = new IdentityHashMap(size * 4 / 3);
        for (int i = 0; i < size; ++i) {
            Object e = s.readObject();
            this._map.put(e, Objects.UNKNOWN);
        }
    }
}

