/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.io;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.zkoss.io.Repeatable;
import org.zkoss.io.RepeatableFileInputStream;
import org.zkoss.io.RepeatableURLInputStream;
import org.zkoss.io.ResetableInputStream;
import org.zkoss.lang.Library;
import org.zkoss.util.logging.Log;

public class RepeatableInputStream
extends InputStream
implements Repeatable {
    private static final Log log = Log.lookup(RepeatableInputStream.class);
    static final String BUFFER_LIMIT_SIZE = "org.zkoss.io.bufferLimitSize";
    static final String MEMORY_LIMIT_SIZE = "org.zkoss.io.memoryLimitSize";
    private InputStream _org;
    private OutputStream _out;
    private InputStream _in;
    private File _f;
    private int _cntsz;
    private final int _bufmaxsz;
    private final int _memmaxsz;
    private boolean _nobuf;

    private RepeatableInputStream(InputStream is) {
        this._org = is;
        this._bufmaxsz = Library.getIntProperty(BUFFER_LIMIT_SIZE, 0x1400000);
        this._memmaxsz = Library.getIntProperty(MEMORY_LIMIT_SIZE, 524288);
    }

    public static InputStream getInstance(InputStream is) {
        if (is instanceof ByteArrayInputStream) {
            return new ResetableInputStream(is);
        }
        if (is != null && !(is instanceof Repeatable)) {
            return new RepeatableInputStream(is);
        }
        return is;
    }

    public static InputStream getInstance(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        return new RepeatableFileInputStream(file);
    }

    public static InputStream getInstance(String filename) throws FileNotFoundException {
        return RepeatableInputStream.getInstance(new File(filename));
    }

    public static InputStream getInstance(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("null");
        }
        return new RepeatableURLInputStream(url);
    }

    private OutputStream getOutputStream() throws IOException {
        if (this._out == null) {
            OutputStream outputStream;
            if (this._nobuf) {
                outputStream = null;
            } else {
                this._out = new ByteArrayOutputStream();
                outputStream = this._out;
            }
            return outputStream;
        }
        if (this._cntsz >= this._bufmaxsz) {
            this.disableBuffering();
            return null;
        }
        if (this._f == null && this._cntsz >= this._memmaxsz) {
            try {
                File f = new File(System.getProperty("java.io.tmpdir"), "zk");
                if (!f.isDirectory()) {
                    f.mkdir();
                }
                this._f = File.createTempFile("zk.io", ".zk.io", f);
                byte[] bs = ((ByteArrayOutputStream)this._out).toByteArray();
                this._out = new BufferedOutputStream(new FileOutputStream(this._f));
                this._out.write(bs);
            }
            catch (Throwable ex) {
                log.warning("Ignored: failed to buffer to a file, " + this._f + "\nCause: " + ex.getMessage());
                this.disableBuffering();
            }
        }
        return this._out;
    }

    private void disableBuffering() {
        this._nobuf = true;
        if (this._out != null) {
            try {
                this._out.close();
            }
            catch (Throwable ex) {
                // empty catch block
            }
            this._out = null;
        }
        if (this._f != null) {
            try {
                this._f.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this._f = null;
        }
    }

    public int read() throws IOException {
        if (this._org != null) {
            int b = this._org.read();
            if (!this._nobuf && b >= 0) {
                OutputStream out = this.getOutputStream();
                if (out != null) {
                    out.write(b);
                }
                ++this._cntsz;
            }
            return b;
        }
        if (this._in == null) {
            this._in = new BufferedInputStream(new FileInputStream(this._f));
        }
        return this._in.read();
    }

    public void close() throws IOException {
        this._cntsz = 0;
        if (this._org != null) {
            this._org.close();
            if (this._out != null) {
                try {
                    this._out.close();
                }
                catch (Throwable ex) {
                    log.warning("Ignored: failed to close the buffer.\nCause: " + ex.getMessage());
                    this.disableBuffering();
                    return;
                }
                if (this._f == null) {
                    this._in = new ByteArrayInputStream(((ByteArrayOutputStream)this._out).toByteArray());
                }
                this._out = null;
                this._org = null;
            }
        } else if (this._in != null) {
            if (this._f != null) {
                this._in.close();
                this._in = null;
            } else {
                this._in.reset();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.disableBuffering();
        if (this._org != null) {
            this._org.close();
        }
        if (this._in != null) {
            this._in.close();
            this._in = null;
        }
        super.finalize();
    }
}

