/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.http;

import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Library;
import org.zkoss.lang.Objects;
import org.zkoss.lang.SystemException;
import org.zkoss.web.servlet.Charsets;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.web.util.resource.ExtendletContext;

public class Encodes {
    private static final Logger log = LoggerFactory.getLogger(Encodes.class);
    private static final char[] URI_UNSAFE = "`%^{}[]\\\"<>|".toCharArray();
    private static final char[] URI_COMP_UNSAFE;
    private static URLEncoder _urlenc;
    private static final URLEncoder _urlenc0;

    protected Encodes() {
    }

    private static final String encodeURI0(String s, char[] unsafes) throws UnsupportedEncodingException {
        int j;
        if (s == null) {
            return null;
        }
        String charset = Charsets.getURICharset();
        byte[] in = s.getBytes(charset);
        byte[] out = new byte[in.length * 3];
        int k = 0;
        for (j = 0; j < in.length; ++j) {
            char cc = (char)(in[j] & 0xFF);
            if (cc >= '\u0080' || cc <= ' ' || Arrays.binarySearch(unsafes, cc) >= 0) {
                out[k++] = 37;
                String cvt = Integer.toHexString(cc);
                if (cvt.length() == 1) {
                    out[k++] = 48;
                    out[k++] = (byte)cvt.charAt(0);
                    continue;
                }
                out[k++] = (byte)cvt.charAt(0);
                out[k++] = (byte)cvt.charAt(1);
                continue;
            }
            out[k++] = in[j];
        }
        return j == k ? s : new String(out, 0, k, charset);
    }

    public static final String encodeURI(String s) throws UnsupportedEncodingException {
        return Encodes.encodeURI0(s, URI_UNSAFE);
    }

    public static final String encodeURIComponent(String s) throws UnsupportedEncodingException {
        return Encodes.encodeURI0(s, URI_COMP_UNSAFE);
    }

    public static final StringBuffer addToQueryString(StringBuffer sb, Map params) throws UnsupportedEncodingException {
        if (params != null) {
            for (Map.Entry me : params.entrySet()) {
                Encodes.addToQueryString(sb, (String)me.getKey(), me.getValue());
            }
        }
        return sb;
    }

    public static final StringBuffer addToQueryString(StringBuffer sb, String name, Object value) throws UnsupportedEncodingException {
        if (value instanceof Object[]) {
            Object[] vals = (Object[])value;
            if (vals.length == 0) {
                value = null;
            } else {
                for (int j = 0; j < vals.length; ++j) {
                    Encodes.addToQueryString(sb, name, vals[j]);
                }
                return sb;
            }
        }
        sb.append(Encodes.next(sb, '?', 0) >= sb.length() ? (char)'?' : '&');
        sb.append(Encodes.encodeURIComponent(name)).append('=');
        if (value != null) {
            sb.append(Encodes.encodeURIComponent(Objects.toString((Object)value)));
        }
        return sb;
    }

    private static final int next(StringBuffer sb, char cc, int j) {
        int len = sb.length();
        while (j < len && sb.charAt(j) != cc) {
            ++j;
        }
        return j;
    }

    public static final String setToQueryString(String str, String name, Object value) throws UnsupportedEncodingException {
        StringBuffer sb = new StringBuffer();
        if (str != null) {
            sb.append(str);
        }
        return Encodes.setToQueryString(sb, name, value).toString();
    }

    public static final StringBuffer setToQueryString(StringBuffer sb, String name, Object value) throws UnsupportedEncodingException {
        Encodes.removeFromQueryString(sb, name);
        return Encodes.addToQueryString(sb, name, value);
    }

    public static final String setToQueryString(String str, Map params) throws UnsupportedEncodingException {
        return Encodes.setToQueryString(new StringBuffer(str), params).toString();
    }

    public static final StringBuffer setToQueryString(StringBuffer sb, Map params) throws UnsupportedEncodingException {
        if (params != null) {
            for (Map.Entry me : params.entrySet()) {
                Encodes.setToQueryString(sb, (String)me.getKey(), me.getValue());
            }
        }
        return sb;
    }

    public static final boolean containsQuery(String str, String name) {
        int j = str.indexOf(name);
        if (j <= 0) {
            return false;
        }
        char cc = str.charAt(j - 1);
        if (cc != '?' && cc != '&') {
            return false;
        }
        if ((j += name.length()) >= str.length()) {
            return true;
        }
        cc = str.charAt(j);
        return cc == '=' || cc == '&';
    }

    public static final String removeFromQueryString(String str, String name) throws UnsupportedEncodingException {
        if (str == null) {
            return null;
        }
        int j = str.indexOf(63);
        if (j < 0) {
            return str;
        }
        StringBuffer sb = new StringBuffer(str);
        Encodes.removeFromQueryString(sb, name);
        return sb.length() == str.length() ? str : sb.toString();
    }

    public static final StringBuffer removeFromQueryString(StringBuffer sb, String name) throws UnsupportedEncodingException {
        name = Encodes.encodeURIComponent(name);
        int j = sb.indexOf("?");
        if (j < 0) {
            return sb;
        }
        if ((j = sb.indexOf(name, j + 1)) < 0) {
            return sb;
        }
        int len = name.length();
        do {
            int k = j + len;
            char cc = sb.charAt(j - 1);
            if (cc != '&' && cc != '?') {
                j = k;
                continue;
            }
            if (k < sb.length() && (cc = sb.charAt(k)) != '=' && cc != '&') {
                j = k;
                continue;
            }
            if ((k = Encodes.next(sb, '&', k)) < sb.length()) {
                sb.delete(j, k + 1);
                continue;
            }
            sb.delete(j - 1, k);
        } while ((j = sb.indexOf(name, j)) > 0);
        return sb;
    }

    public static final String encodeURL(ServletContext ctx, ServletRequest request, ServletResponse response, String uri) throws ServletException {
        try {
            return Encodes.urlEncoder().encodeURL(ctx, request, response, uri, _urlenc0);
        }
        catch (Exception ex) {
            log.error("", (Throwable)ex);
            throw new ServletException("Unable to encode " + uri, (Throwable)ex);
        }
    }

    private static URLEncoder urlEncoder() {
        if (_urlenc == null) {
            String cls = Library.getProperty((String)"org.zkoss.web.servlet.http.URLEncoder");
            if (cls != null && cls.length() > 0) {
                try {
                    _urlenc = (URLEncoder)Classes.newInstanceByThread((String)cls);
                }
                catch (Throwable ex) {
                    throw SystemException.Aide.wrap((Throwable)ex, (String)("Unable to instantiate " + cls));
                }
            } else {
                _urlenc = _urlenc0;
            }
        }
        return _urlenc;
    }

    private static final String encodeURL0(ServletContext ctx, ServletRequest request, ServletResponse response, String uri) throws Exception {
        int j;
        if (uri == null || uri.length() == 0) {
            return uri;
        }
        boolean ctxpathSpecified = false;
        if (uri.charAt(0) != '/') {
            String pgpath;
            if (Servlets.isUniversalURL(uri)) {
                return uri;
            }
            if (uri.charAt(0) == '~') {
                String ctxroot;
                if (uri.length() == 1) {
                    uri = "/";
                    ctxroot = "/";
                } else if (uri.charAt(1) == '/') {
                    ctxroot = "/";
                    uri = uri.substring(1);
                } else {
                    uri = '/' + uri.substring(1);
                    int j2 = uri.indexOf(47, 1);
                    ctxroot = j2 >= 0 ? uri.substring(0, j2) : uri;
                }
                ExtendletContext extctx = Servlets.getExtendletContext(ctx, ctxroot.substring(1));
                if (extctx != null) {
                    int j3 = uri.indexOf(47, 1);
                    return extctx.encodeURL(request, response, j3 >= 0 ? uri.substring(j3) : "/");
                }
                ServletContext newctx = ctx.getContext(ctxroot);
                if (newctx != null) {
                    ctx = newctx;
                } else if (log.isDebugEnabled()) {
                    log.debug("Context not found: " + ctxroot);
                }
                ctxpathSpecified = true;
            } else if ((Https.isIncluded(request) || Https.isForwarded(request)) && (pgpath = Https.getThisServletPath(request)) != null) {
                int j4 = pgpath.lastIndexOf(47);
                if (j4 >= 0) {
                    uri = pgpath.substring(0, j4 + 1) + uri;
                } else {
                    log.warn("The current page doesn't contain '/':" + pgpath);
                }
            }
        }
        uri = Servlets.locate(ctx, request, uri, null);
        if (!ctxpathSpecified && uri.charAt(0) == '/' && (uri.length() <= 1 || uri.charAt(1) != '/') && request instanceof HttpServletRequest) {
            int last;
            String ctxpath = ((HttpServletRequest)request).getContextPath();
            if (ctxpath.length() > 0 && ctxpath.charAt(0) != '/') {
                ctxpath = '/' + ctxpath;
            }
            if ((last = ctxpath.length() - 1) >= 0 && ctxpath.charAt(last) == '/') {
                ctxpath = ctxpath.substring(0, last);
            }
            uri = ctxpath + uri;
        }
        uri = (j = uri.indexOf(63)) < 0 ? Encodes.encodeURI(uri) : Encodes.encodeURI(uri.substring(0, j)) + uri.substring(j);
        if (response instanceof HttpServletResponse) {
            uri = ((HttpServletResponse)response).encodeURL(uri);
        }
        return uri;
    }

    static {
        Arrays.sort(URI_UNSAFE);
        URI_COMP_UNSAFE = "`%^{}[]\\\"<>|$&,/:;=?".toCharArray();
        Arrays.sort(URI_COMP_UNSAFE);
        _urlenc0 = new URLEncoder(){

            public String encodeURL(ServletContext ctx, ServletRequest request, ServletResponse response, String uri, URLEncoder defaultEncoder) throws Exception {
                return Encodes.encodeURL0(ctx, request, response, uri);
            }
        };
    }

    public static interface URLEncoder {
        public String encodeURL(ServletContext var1, ServletRequest var2, ServletResponse var3, String var4, URLEncoder var5) throws Exception;
    }
}

