/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.zkoss.idom.Element;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.lang.SystemException;
import org.zkoss.util.CacheMap;
import org.zkoss.util.Checksums;
import org.zkoss.util.Locales;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.Locators;
import org.zkoss.web.portlet.RenderHttpServletRequest;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.web.util.resource.ExtendletContext;
import org.zkoss.web.util.resource.ServletContextLocator;

public class Servlets {
    private static BrowserIdentifier _bwid;
    private static final boolean _svl24;
    private static final boolean _svl23;
    public static final int OVERWRITE_URI = 0;
    public static final int IGNORE_PARAM = 1;
    public static final int APPEND_PARAM = 2;
    public static final int PASS_THRU_ATTR = 3;
    private static List _ctxroots;

    protected Servlets() {
    }

    public static final boolean isUniversalURL(String uri) {
        if (uri == null || uri.length() == 0) {
            return false;
        }
        char cc = uri.charAt(0);
        return cc >= 'a' && cc <= 'z' && (uri.indexOf("://") > 0 || uri.startsWith("mailto:") || uri.startsWith("javascript:") || uri.startsWith("about:"));
    }

    public static final boolean isServlet24() {
        return _svl24;
    }

    public static final boolean isServlet23() {
        return _svl23;
    }

    public static final String locate(ServletContext ctx, ServletRequest request, String pgpath, Locator locator) throws ServletException {
        Locale locale;
        URIIndex index;
        String uri;
        boolean byLocale;
        String qstr;
        if (pgpath == null) {
            return pgpath;
        }
        int f = pgpath.indexOf(42);
        if (f < 0 || Servlets.isUniversalURL(pgpath)) {
            return pgpath;
        }
        int jquest = pgpath.indexOf(63);
        if (jquest >= 0 && f > jquest) {
            return pgpath;
        }
        if (jquest >= 0) {
            qstr = pgpath.substring(jquest);
            pgpath = pgpath.substring(0, jquest);
        } else {
            qstr = null;
        }
        int l = pgpath.lastIndexOf(42);
        if (l > f) {
            String bc = Servlets.isExplorer(request) ? "ie" : (Servlets.isSafari(request) ? "saf" : (Servlets.isOpera(request) ? "opr" : "moz"));
            l += bc.length() - 1;
            pgpath = pgpath.substring(0, f) + bc + pgpath.substring(f + 1);
        }
        boolean bl = byLocale = l == (pgpath = pgpath.substring(0, l) + pgpath.substring(l + 1)).length() || pgpath.charAt(l) == '.' && pgpath.indexOf(47, l + 1) < 0;
        if (byLocale) {
            int j = l;
            while (--j >= 0) {
                char cc = pgpath.charAt(j);
                if (cc == '.') {
                    byLocale = false;
                    break;
                }
                if (cc != '/') continue;
                break;
            }
        }
        if (!byLocale) {
            return qstr != null ? pgpath + qstr : pgpath;
        }
        String PGPATH_CACHE = "org.zkoss.web.pgpath.cache";
        Map<URIIndex, String> map = (Map<URIIndex, String>)ctx.getAttribute("org.zkoss.web.pgpath.cache");
        if (map == null) {
            map = Collections.synchronizedMap(new CacheMap(500, 600000));
            ctx.setAttribute("org.zkoss.web.pgpath.cache", map);
        }
        if ((uri = (String)map.get(index = new URIIndex(pgpath, locale = Locales.getCurrent()))) == null) {
            Locators.URLLocation loc = Locators.locate((String)pgpath, (Locale)locale, (Locator)(locator != null ? locator : new ServletContextLocator(ctx)));
            uri = loc != null ? loc.file : pgpath;
            map.put(index, uri);
        }
        return qstr != null ? uri + qstr : uri;
    }

    public static void setBrowserIdentifier(BrowserIdentifier bwid) {
        _bwid = bwid;
    }

    public static BrowserIdentifier getBrowserIdentifier() {
        return _bwid;
    }

    public static boolean isBrowser(ServletRequest req, String type) {
        return req instanceof HttpServletRequest && Servlets.isBrowser(((HttpServletRequest)req).getHeader("user-agent"), type);
    }

    public static boolean isBrowser(String userAgent, String type) {
        BrowserIdentifier bwid = _bwid;
        if (bwid != null && bwid.isBrowser(userAgent, type)) {
            return true;
        }
        if ("ie".equals(type) || "ie6".equals(type)) {
            return Servlets.isExplorer(userAgent);
        }
        if ("ie6-".equals(type)) {
            return Servlets.getIEVer(userAgent) == 6;
        }
        if ("ie7".equals(type)) {
            return Servlets.isExplorer7(userAgent);
        }
        if ("ie7-".equals(type)) {
            return Servlets.getIEVer(userAgent) == 7;
        }
        if ("ie8".equals(type)) {
            return Servlets.getIEVer(userAgent) >= 8;
        }
        if ("ie8-".equals(type)) {
            return Servlets.getIEVer(userAgent) == 8;
        }
        if ("ie9".equals(type)) {
            return Servlets.getIEVer(userAgent) >= 9;
        }
        if ("ie9-".equals(type)) {
            return Servlets.getIEVer(userAgent) == 9;
        }
        if ("gecko".equals(type) || "gecko2".equals(type)) {
            return Servlets.isGecko(userAgent);
        }
        if ("gecko2-".equals(type)) {
            return Servlets.getGeckoVer(userAgent) == 2;
        }
        if ("gecko3".equals(type)) {
            return Servlets.isGecko3(userAgent);
        }
        if ("gecko3.5".equals(type)) {
            return Servlets.getGeckoVer(userAgent, true) >= 35;
        }
        if ("gecko3-".equals(type)) {
            return Servlets.getGeckoVer(userAgent) == 3;
        }
        if ("gecko4".equals(type)) {
            return Servlets.getGeckoVer(userAgent) >= 4;
        }
        if ("gecko4-".equals(type)) {
            return Servlets.getGeckoVer(userAgent) == 4;
        }
        if ("safari".equals(type)) {
            return Servlets.isSafari(userAgent);
        }
        if ("opera".equals(type)) {
            return Servlets.isOpera(userAgent);
        }
        if ("hil".equals(type)) {
            return Servlets.isHilDevice(userAgent);
        }
        if ("robot".equals(type)) {
            return Servlets.isRobot(userAgent);
        }
        return userAgent != null && type != null && userAgent.toLowerCase().indexOf(type.toLowerCase()) > -1;
    }

    public static final boolean isRobot(ServletRequest req) {
        return req instanceof HttpServletRequest && Servlets.isRobot(((HttpServletRequest)req).getHeader("user-agent"));
    }

    public static final boolean isRobot(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        boolean ie = userAgent.indexOf("MSIE ") >= 0;
        userAgent = userAgent.toLowerCase();
        return !ie && userAgent.indexOf("msie ") < 0 && userAgent.indexOf("opera") < 0 && userAgent.indexOf("gecko/") < 0 && userAgent.indexOf("safari") < 0 && userAgent.indexOf("zk") < 0 && userAgent.indexOf("rmil") < 0;
    }

    public static final boolean isExplorer(ServletRequest req) {
        return req instanceof HttpServletRequest && Servlets.isExplorer(((HttpServletRequest)req).getHeader("user-agent"));
    }

    public static final boolean isExplorer(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        boolean ie = userAgent.indexOf("MSIE ") >= 0;
        userAgent = userAgent.toLowerCase();
        return (ie || userAgent.indexOf("msie ") >= 0) && userAgent.indexOf("opera") < 0;
    }

    public static final boolean isExplorer7(ServletRequest req) {
        return req instanceof HttpServletRequest && Servlets.isExplorer7(((HttpServletRequest)req).getHeader("user-agent"));
    }

    public static final boolean isExplorer7(String userAgent) {
        return Servlets.getIEVer(userAgent) >= 7;
    }

    private static final int getIEVer(String userAgent) {
        if (userAgent == null) {
            return -1;
        }
        int j = userAgent.indexOf("MSIE ");
        userAgent = userAgent.toLowerCase();
        if (j < 0) {
            j = userAgent.indexOf("msie ");
        }
        if (j < 0 || userAgent.indexOf("opera") >= 0) {
            return -1;
        }
        return Servlets.parseVer(userAgent, j + 5)[0];
    }

    private static final int[] parseVer(String ua, int j) {
        char cc;
        int ver = 0;
        int len = ua.length();
        while (j < len && (cc = ua.charAt(j)) >= '0' && cc <= '9') {
            ver = ver * 10 + cc - 48;
            ++j;
        }
        return new int[]{ver, j};
    }

    public static final boolean isGecko(ServletRequest req) {
        return req instanceof HttpServletRequest && Servlets.isGecko(((HttpServletRequest)req).getHeader("user-agent"));
    }

    public static final boolean isGecko(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        return (userAgent = userAgent.toLowerCase()).indexOf("gecko/") >= 0 && userAgent.indexOf("safari") < 0;
    }

    public static final boolean isGecko3(ServletRequest req) {
        return req instanceof HttpServletRequest && Servlets.isGecko3(((HttpServletRequest)req).getHeader("user-agent"));
    }

    public static final boolean isGecko3(String userAgent) {
        return Servlets.getGeckoVer(userAgent) >= 3;
    }

    private static final int getGeckoVer(String userAgent) {
        return Servlets.getGeckoVer(userAgent, false);
    }

    private static final int getGeckoVer(String userAgent, boolean subversion) {
        if (userAgent == null) {
            return -1;
        }
        if ((userAgent = userAgent.toLowerCase()).indexOf("gecko/") < 0 || userAgent.indexOf("safari") >= 0 || userAgent.indexOf("opera") >= 0) {
            return -1;
        }
        int j = userAgent.indexOf("firefox/");
        if (j < 0) {
            return -1;
        }
        int[] vi = Servlets.parseVer(userAgent, j + 8);
        int ver = vi[0];
        if (subversion) {
            ver = ver * 10 + Servlets.parseVer(userAgent, vi[1] + 1)[0];
        }
        return ver;
    }

    public static final boolean isSafari(ServletRequest req) {
        return req instanceof HttpServletRequest && Servlets.isSafari(((HttpServletRequest)req).getHeader("user-agent"));
    }

    public static final boolean isSafari(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        return (userAgent = userAgent.toLowerCase()).indexOf("safari") >= 0;
    }

    public static final boolean isOpera(ServletRequest req) {
        return req instanceof HttpServletRequest && Servlets.isOpera(((HttpServletRequest)req).getHeader("user-agent"));
    }

    public static final boolean isOpera(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        return (userAgent = userAgent.toLowerCase()).indexOf("opera") >= 0;
    }

    public static final boolean isMilDevice(ServletRequest req) {
        return req instanceof HttpServletRequest && Servlets.isMilDevice(((HttpServletRequest)req).getHeader("user-agent"));
    }

    public static final boolean isMilDevice(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        return (userAgent = userAgent.toLowerCase()).indexOf("zk") >= 0 && userAgent.indexOf("rmil") >= 0;
    }

    public static final boolean isHilDevice(ServletRequest req) {
        return req instanceof HttpServletRequest && Servlets.isHilDevice(((HttpServletRequest)req).getHeader("user-agent"));
    }

    public static final boolean isHilDevice(String userAgent) {
        if (userAgent == null) {
            return false;
        }
        return (userAgent = userAgent.toLowerCase()).indexOf("zk") >= 0 && userAgent.indexOf("rhil") >= 0;
    }

    public static final String getUserAgent(ServletRequest req) {
        String s;
        if (req instanceof HttpServletRequest && (s = ((HttpServletRequest)req).getHeader("user-agent")) != null) {
            return s;
        }
        return "";
    }

    public static final boolean isIncluded(ServletRequest request) {
        return request.getAttribute("javax.servlet.include.context_path") != null || request.getAttribute("org.zkoss.web.servlet.include") != null;
    }

    public static final boolean isForwarded(ServletRequest request) {
        return request.getAttribute("javax.servlet.forward.context_path") != null || request.getAttribute("org.zkoss.web.servlet.forward") != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final void forward(ServletContext ctx, ServletRequest request, ServletResponse response, String uri, Map params, int mode) throws IOException, ServletException {
        if (Servlets.isIncluded(request)) {
            Servlets.include(ctx, request, response, uri, params, mode);
            return;
        }
        RequestDispatcher disp = Servlets.getRequestDispatcher(ctx, request, uri = Servlets.locate(ctx, request, uri, null), params, mode);
        if (disp == null) {
            throw new ServletException("No dispatcher available to forward to " + uri);
        }
        if (mode == 3 && params != null && !params.isEmpty()) {
            Map old = Servlets.setPassThruAttr(request, params);
            try {
                disp.forward(request, response);
                return;
            }
            catch (ClassCastException ex) {
                if (request instanceof RenderHttpServletRequest) return;
                throw ex;
            }
            finally {
                Servlets.restorePassThruAttr(request, old);
            }
        } else {
            disp.forward(request, response);
        }
    }

    public static final void forward(ServletContext ctx, ServletRequest request, ServletResponse response, String uri) throws IOException, ServletException {
        Servlets.forward(ctx, request, response, uri, null, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void include(ServletContext ctx, ServletRequest request, ServletResponse response, String uri, Map params, int mode) throws IOException, ServletException {
        request.setAttribute("org.mortbay.jetty.servlet.Dispatcher.shared_session", (Object)Boolean.TRUE);
        uri = Servlets.locate(ctx, request, uri, null);
        RequestDispatcher disp = Servlets.getRequestDispatcher(ctx, request, uri, params, mode);
        if (disp == null) {
            throw new ServletException("No dispatcher available to include " + uri);
        }
        if (mode == 3 && params != null && !params.isEmpty()) {
            Map old = Servlets.setPassThruAttr(request, params);
            try {
                disp.include(request, response);
            }
            finally {
                Servlets.restorePassThruAttr(request, old);
            }
        } else {
            disp.include(request, response);
        }
    }

    public static final void include(ServletContext ctx, ServletRequest request, ServletResponse response, String uri) throws IOException, ServletException {
        Servlets.include(ctx, request, response, uri, null, 0);
    }

    private static final Map setPassThruAttr(ServletRequest request, Map params) {
        Map old = (Map)request.getAttribute("arg");
        request.setAttribute("arg", (Object)params);
        return old;
    }

    private static final void restorePassThruAttr(ServletRequest request, Map old) {
        if (old != null) {
            request.setAttribute("arg", (Object)old);
        } else {
            request.removeAttribute("arg");
        }
    }

    public static final RequestDispatcher getRequestDispatcher(ServletContext ctx, ServletRequest request, String uri, Map params, int mode) throws ServletException {
        char cc;
        char c = cc = uri.length() > 0 ? uri.charAt(0) : (char)'\u0000';
        if (ctx == null || cc != '/' && cc != '~') {
            if (request == null) {
                throw new IllegalArgumentException(ctx == null ? "Servlet context and request cannot be both null" : "Request is required to use revalant URI: " + uri);
            }
            if (cc == '~') {
                throw new IllegalArgumentException("Servlet context is required to use foreign URI: " + uri);
            }
            uri = Servlets.generateURI(uri, params, mode);
            return request.getRequestDispatcher(uri);
        }
        return new ParsedURI(ctx, uri).getRequestDispatcher(params, mode);
    }

    public static final URL getResource(ServletContext ctx, String uri) throws MalformedURLException {
        return new ParsedURI(ctx, uri).getResource();
    }

    public static final InputStream getResourceAsStream(ServletContext ctx, String uri) {
        return new ParsedURI(ctx, uri).getResourceAsStream();
    }

    public static final String generateURI(String uri, Map params, int mode) {
        if (uri.startsWith("~")) {
            throw new IllegalArgumentException("~ctx not supported here: " + uri);
        }
        int j = uri.indexOf(63);
        String qstr = null;
        if (j >= 0) {
            qstr = uri.substring(j);
            uri = uri.substring(0, j);
        }
        try {
            boolean noParams;
            uri = Encodes.encodeURI(uri);
            boolean noQstr = qstr == null;
            boolean bl = noParams = mode == 3 || params == null || params.isEmpty();
            if (noQstr && noParams) {
                return uri;
            }
            if (noQstr != noParams) {
                mode = 2;
            }
            StringBuffer sb = new StringBuffer(80).append(uri);
            if (qstr != null) {
                sb.append(qstr);
            }
            switch (mode) {
                case 1: {
                    Iterator it = params.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry me = it.next();
                        String nm = (String)me.getKey();
                        if (!Encodes.containsQuery(qstr, nm)) continue;
                        it.remove();
                    }
                }
                case 0: {
                    return Encodes.setToQueryString(sb, params).toString();
                }
                case 2: {
                    return Encodes.addToQueryString(sb, params).toString();
                }
            }
            throw new IllegalArgumentException("Unknown mode: " + mode);
        }
        catch (UnsupportedEncodingException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final List getContextPaths() {
        if (_ctxroots != null) {
            return _ctxroots;
        }
        try {
            Class clazz = Servlets.class;
            synchronized (clazz) {
                _ctxroots = Servlets.myGetContextPaths();
                return _ctxroots;
            }
        }
        catch (Exception ex) {
            throw SystemException.Aide.wrap((Throwable)ex);
        }
    }

    private static final List myGetContextPaths() throws Exception {
        String APP_XML = "/META-INF/application.xml";
        LinkedList<String> ctxroots = new LinkedList<String>();
        URL xmlURL = Locators.getDefault().getResource("/META-INF/application.xml");
        if (xmlURL == null) {
            throw new SystemException("File not found: /META-INF/application.xml");
        }
        Element root = new SAXBuilder(false, false, true).build(xmlURL).getRootElement();
        Iterator it = root.getElements("module").iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            String ctxroot = (String)e.getContent("web/context-root");
            if (ctxroot == null) continue;
            ctxroots.add(ctxroot.startsWith("/") ? ctxroot : "/" + ctxroot);
        }
        return new ArrayList(ctxroots);
    }

    public static final String getLimitTimeOffer() {
        String lto = Long.toHexString(System.currentTimeMillis());
        return lto + Checksums.getChecksum((String)lto, (String)"");
    }

    public static final boolean isOfferExpired(String lto, int timeout) {
        int len;
        int n = len = lto != null ? lto.length() : 0;
        if (len <= 1) {
            return true;
        }
        char cksm = lto.charAt(len - 1);
        if (cksm != Checksums.getChecksum((String)(lto = lto.substring(0, len - 1)), (String)"")) {
            return true;
        }
        try {
            return Long.parseLong(lto, 16) + (long)timeout * 1000L < System.currentTimeMillis();
        }
        catch (NumberFormatException ex) {
            return true;
        }
    }

    public static final ExtendletContext addExtendletContext(ServletContext ctx, String name, ExtendletContext extctx) {
        if (name == null || extctx == null) {
            throw new IllegalArgumentException("null");
        }
        return Servlets.getExtWebCtxs(ctx).put(name, extctx);
    }

    public static final ExtendletContext removeExtendletContext(ServletContext ctx, String name) {
        return (ExtendletContext)Servlets.getExtWebCtxs(ctx).remove(name);
    }

    public static final ExtendletContext getExtendletContext(ServletContext ctx, String name) {
        return (ExtendletContext)Servlets.getExtWebCtxs(ctx).get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map getExtWebCtxs(ServletContext ctx) {
        String attr = "javax.zkoss.web.servlets.ExtendletContexts";
        Class clazz = Servlets.class;
        synchronized (clazz) {
            Map ctxs = (Map)ctx.getAttribute("javax.zkoss.web.servlets.ExtendletContexts");
            if (ctxs == null) {
                ctxs = Collections.synchronizedMap(new HashMap(5));
                ctx.setAttribute("javax.zkoss.web.servlets.ExtendletContexts", ctxs);
            }
            return ctxs;
        }
    }

    public static final String getExtension(String path) {
        int j;
        if (path != null && (j = path.lastIndexOf(46)) >= 0 && path.indexOf(47, j + 1) < 0) {
            return path.substring(j + 1).toLowerCase();
        }
        return null;
    }

    public static final String getExtension(String path, boolean lastOnly) {
        if (lastOnly) {
            return Servlets.getExtension(path);
        }
        if (path == null) {
            return null;
        }
        int dot = -1;
        int j = path.length();
        while (--j >= 0) {
            char cc = path.charAt(j);
            if (cc == '.') {
                dot = j;
                continue;
            }
            if (cc != '/') continue;
            break;
        }
        return dot >= 0 ? path.substring(dot + 1).toLowerCase() : "";
    }

    public static String getDetail(ServletRequest request) {
        HttpServletRequest hreq = request instanceof HttpServletRequest ? (HttpServletRequest)request : null;
        StringBuffer sb = new StringBuffer(128);
        if (hreq != null) {
            sb.append(" sid: ").append(hreq.getHeader("ZK-SID")).append('\n');
            Servlets.addHeaderInfo(sb, hreq, "user-agent");
            Servlets.addHeaderInfo(sb, hreq, "content-length");
            Servlets.addHeaderInfo(sb, hreq, "content-type");
        }
        sb.append(" ip: ").append(request.getRemoteAddr());
        return sb.toString();
    }

    private static void addHeaderInfo(StringBuffer sb, HttpServletRequest request, String header) {
        sb.append(' ').append(header).append(": ").append(request.getHeader(header)).append('\n');
    }

    public static String getNormalPath(String path) {
        int sz = path.length();
        StringBuffer sb = new StringBuffer(path);
        IntStack slashes = new IntStack(32);
        slashes.push(-1);
        int colon = -100;
        int dot1 = -100;
        int dot2 = -100;
        block5: for (int j = 0; j < sb.length(); ++j) {
            char c = sb.charAt(j);
            switch (c) {
                case '/': {
                    if (dot1 >= 0) {
                        if (dot2 >= 0) {
                            int preslash = slashes.pop();
                            if (preslash == 0) {
                                throw new IllegalArgumentException("Illegal path: " + path);
                            }
                            if (slashes.isEmpty()) {
                                slashes.push(-1);
                            }
                            dot2 = -100;
                        }
                        int b = slashes.peek();
                        sb.delete(b + 1, j + 1);
                        j = b;
                        dot1 = -100;
                        continue block5;
                    }
                    int s = slashes.peek();
                    if (s >= 0 && j == s + 1) {
                        if (colon == s - 1) {
                            slashes.clear();
                            slashes.push(-1);
                            slashes.push(j);
                            continue block5;
                        }
                        sb.delete(--j, j + 1);
                        continue block5;
                    }
                    slashes.push(j);
                    continue block5;
                }
                case '.': {
                    if (dot1 < 0) {
                        if (slashes.peek() != j - 1) continue block5;
                        dot1 = j;
                        continue block5;
                    }
                    if (dot2 < 0) {
                        dot2 = j;
                        continue block5;
                    }
                    throw new IllegalArgumentException("Illegal path: " + path);
                }
                case ':': {
                    if (colon >= 0) {
                        throw new IllegalArgumentException("Illegal path: " + path);
                    }
                    colon = j;
                }
                default: {
                    dot2 = -100;
                    dot1 = -100;
                }
            }
        }
        return sb.toString();
    }

    static {
        boolean b = false;
        try {
            ServletResponse.class.getMethod("getContentType", new Class[0]);
            b = true;
        }
        catch (Throwable ex) {
            // empty catch block
        }
        _svl24 = b;
        if (!b) {
            try {
                HttpSession.class.getMethod("getServletContext", new Class[0]);
                b = true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        _svl23 = b;
    }

    private static class IntStack {
        private int _top = -1;
        private int[] _value;

        public IntStack(int sz) {
            this._value = new int[sz];
        }

        public boolean isEmpty() {
            return this._top < 0;
        }

        public int peek() {
            return this._top >= 0 && this._top < this._value.length ? this._value[this._top] : -100;
        }

        public int pop() {
            return this._value[this._top--];
        }

        public void push(int val) {
            this._value[++this._top] = val;
        }

        public void clear() {
            this._top = -1;
        }
    }

    public static interface BrowserIdentifier {
        public boolean isBrowser(String var1, String var2);
    }

    private static class ParsedURI {
        private ServletContext _svlctx;
        private ExtendletContext _extctx;
        private String _uri;

        private ParsedURI(ServletContext ctx, String uri) {
            if (uri != null && uri.startsWith("~")) {
                String ctxroot;
                int j = uri.indexOf(47, 1);
                if (j >= 0) {
                    ctxroot = "/" + uri.substring(1, j);
                    this._uri = uri.substring(j);
                } else {
                    ctxroot = "/" + uri.substring(1);
                    this._uri = "/";
                }
                this._extctx = Servlets.getExtendletContext(ctx, ctxroot.substring(1));
                if (this._extctx == null) {
                    this._svlctx = ctx.getContext(ctxroot);
                    if (this._svlctx == null) {
                        throw new SystemException("Context not found or not visible to " + ctx + ": " + ctxroot);
                    }
                }
            } else {
                this._svlctx = ctx;
                this._uri = uri;
            }
        }

        private RequestDispatcher getRequestDispatcher(Map params, int mode) {
            if (this._extctx == null && this._svlctx == null) {
                return null;
            }
            String uri = Servlets.generateURI(this._uri, params, mode);
            return this._svlctx != null ? this._svlctx.getRequestDispatcher(uri) : this._extctx.getRequestDispatcher(uri);
        }

        private URL getResource() throws MalformedURLException {
            return this._svlctx != null ? this._svlctx.getResource(this._uri) : (this._extctx != null ? this._extctx.getResource(this._uri) : null);
        }

        private InputStream getResourceAsStream() {
            return this._svlctx != null ? this._svlctx.getResourceAsStream(this._uri) : (this._extctx != null ? this._extctx.getResourceAsStream(this._uri) : null);
        }
    }

    private static class URIIndex {
        private final String _uri;
        private final Locale _locale;

        private URIIndex(String uri, Locale locale) {
            if (uri == null || locale == null) {
                throw new IllegalArgumentException("null");
            }
            this._uri = uri;
            this._locale = locale;
        }

        public int hashCode() {
            return this._uri.hashCode();
        }

        public boolean equals(Object o) {
            URIIndex idx = (URIIndex)o;
            return this._uri.equals(idx._uri) && this._locale.equals(idx._locale);
        }
    }
}

