/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import java.io.InputStream;
import java.net.URL;
import org.zkoss.io.Files;
import org.zkoss.lang.Library;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Loader;
import org.zkoss.web.util.resource.ExtendletContext;

public abstract class ExtendletLoader
implements Loader {
    private static final Log log = Log.lookup((Class)ExtendletLoader.class);
    private int _checkPeriod = ExtendletLoader.getInitCheckPeriod();

    protected ExtendletLoader() {
    }

    protected String getRealPath(String path) {
        return path;
    }

    public boolean shallCheck(Object src, long expiredMillis) {
        return expiredMillis > 0L;
    }

    public long getLastModified(Object src) {
        if (this.getCheckPeriod() < 0) {
            return 1L;
        }
        try {
            URL url = this.getExtendletContext().getResource((String)src);
            if (url != null) {
                long v = url.openConnection().getLastModified();
                return v != -1L ? v : 0L;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(Object src) throws Exception {
        String path = this.getRealPath((String)src);
        InputStream is = null;
        if (this.getCheckPeriod() >= 0) {
            try {
                URL real = this.getExtendletContext().getResource(path);
                if (real != null) {
                    is = real.openStream();
                }
            }
            catch (Throwable ex) {
                log.warningBriefly("Unable to read from URL: " + path, ex);
            }
        }
        if (is == null && (is = this.getExtendletContext().getResourceAsStream(path)) == null) {
            return null;
        }
        try {
            Object ex = this.parse(is, path, (String)src);
            return ex;
        }
        catch (Throwable ex) {
            log.realCauseBriefly("Failed to parse " + src, ex);
            Object var5_7 = null;
            return var5_7;
        }
        finally {
            Files.close((InputStream)is);
        }
    }

    protected abstract Object parse(InputStream var1, String var2, String var3) throws Exception;

    protected abstract ExtendletContext getExtendletContext();

    public int getCheckPeriod() {
        return this._checkPeriod;
    }

    private static int getInitCheckPeriod() {
        int v = Library.getIntProperty((String)"org.zkoss.util.resource.extendlet.checkPeriod", (int)-1);
        return v > 0 ? v * 1000 : v;
    }
}

