/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.io.Files;
import org.zkoss.lang.Objects;
import org.zkoss.util.FastReadArray;
import org.zkoss.util.logging.Log;
import org.zkoss.util.media.ContentTypes;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.Locators;
import org.zkoss.web.servlet.Charsets;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.web.util.resource.DspExtendlet;
import org.zkoss.web.util.resource.Extendlet;
import org.zkoss.web.util.resource.ExtendletConfig;
import org.zkoss.web.util.resource.ExtendletContext;
import org.zkoss.web.util.resource.Filter;
import org.zkoss.web.util.resource.FilterChain;
import org.zkoss.web.util.resource.FilterConfig;

public class ClassWebResource {
    private static final Log log = Log.lookup((Class)ClassWebResource.class);
    private final ServletContext _ctx;
    private final String _mappingURI;
    private final ClassWebContext _cwc;
    private String[] _compressExts;
    private final Map _extlets = new HashMap(4);
    private final Map _reqfilters = new HashMap(2);
    private final Map _incfilters = new HashMap(2);
    private boolean _debugJS;
    public static final String PATH_PREFIX = "/web";
    public static final int FILTER_REQUEST = 1;
    public static final int FILTER_INCLUDE = 2;

    public static URL getResource(String uri) {
        return Locators.getDefault().getResource(PATH_PREFIX + uri);
    }

    public static InputStream getResourceAsStream(String uri) {
        return Locators.getDefault().getResourceAsStream(PATH_PREFIX + uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ClassWebResource getInstance(ServletContext ctx, String mappingURI) {
        ServletContext servletContext = ctx;
        synchronized (servletContext) {
            ClassWebContext cwc = (ClassWebContext)Servlets.getExtendletContext(ctx, ".");
            if (cwc != null) {
                return cwc.getClassWebResource();
            }
            ClassWebResource cwr = new ClassWebResource(ctx, mappingURI);
            Servlets.addExtendletContext(ctx, ".", cwr._cwc);
            return cwr;
        }
    }

    private ClassWebResource(ServletContext ctx, String mappingURI) {
        if (!mappingURI.startsWith("/") || mappingURI.endsWith("/")) {
            throw new IllegalArgumentException("mappingURI must start with /, but not ends with /");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("null ctx");
        }
        this._ctx = ctx;
        this._mappingURI = mappingURI;
        this._cwc = new ClassWebContext();
        this.addExtendlet("dsp", new DspExtendlet());
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pi = Https.getThisPathInfo((ServletRequest)request);
        if (pi != null) {
            this.service(request, response, pi.substring(PATH_PREFIX.length()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        Object old = Charsets.setup((ServletRequest)request, (ServletResponse)response, "UTF-8");
        try {
            this.web(request, response, path);
        }
        finally {
            Charsets.cleanup((ServletRequest)request, old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extendlet getExtendlet(String ext) {
        if (ext == null) {
            return null;
        }
        ext = ext.toLowerCase();
        while (true) {
            Map map = this._extlets;
            synchronized (map) {
                Extendlet exlet = (Extendlet)this._extlets.get(ext);
                if (exlet != null) {
                    return exlet;
                }
            }
            int j = ext.indexOf(46);
            if (j < 0) {
                return null;
            }
            ext = ext.substring(j + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extendlet addExtendlet(String ext, Extendlet extlet) {
        if (ext == null || extlet == null) {
            throw new IllegalArgumentException("null");
        }
        extlet.init(new ExtendletConfig(){

            public ExtendletContext getExtendletContext() {
                return ClassWebResource.this._cwc;
            }
        });
        ext = ext.toLowerCase();
        Map map = this._extlets;
        synchronized (map) {
            return this._extlets.put(ext, extlet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extendlet removeExtendlet(String ext) {
        if (ext == null) {
            return null;
        }
        ext = ext.toLowerCase();
        Map map = this._extlets;
        synchronized (map) {
            return (Extendlet)this._extlets.remove(ext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Filter[] getFilters(String ext, int flag) {
        Map filters;
        if (ext == null) {
            return null;
        }
        ext = ext.toLowerCase();
        Map map = filters = flag == 0 || (flag & 1) != 0 ? this._reqfilters : this._incfilters;
        if (filters.isEmpty()) {
            return null;
        }
        while (true) {
            FastReadArray ary;
            Map map2 = filters;
            synchronized (map2) {
                ary = (FastReadArray)filters.get(ext);
            }
            if (ary != null) {
                return (Filter[])ary.toArray();
            }
            int j = ext.indexOf(46);
            if (j < 0) {
                return null;
            }
            ext = ext.substring(j + 1);
        }
    }

    public void addFilter(String ext, Filter filter, int flags) {
        if (ext == null || filter == null) {
            throw new IllegalArgumentException("null");
        }
        filter.init(new FilterConfig(){

            public ExtendletContext getExtendletContext() {
                return ClassWebResource.this._cwc;
            }
        });
        ext = ext.toLowerCase();
        if (flags == 0 || (flags & 1) != 0) {
            ClassWebResource.addFilter(this._reqfilters, ext, filter);
        }
        if ((flags & 2) != 0) {
            ClassWebResource.addFilter(this._incfilters, ext, filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addFilter(Map filters, String ext, Filter filter) {
        FastReadArray ary;
        Map map = filters;
        synchronized (map) {
            ary = (FastReadArray)filters.get(ext);
            if (ary == null) {
                ary = new FastReadArray(Filter.class);
                filters.put(ext, ary);
            }
        }
        ary.add((Object)filter);
    }

    public boolean removeFilter(String ext, Filter filter, int flags) {
        if (ext == null || filter == null) {
            return false;
        }
        ext = ext.toLowerCase();
        boolean removed = false;
        if (flags == 0 || (flags & 1) != 0) {
            removed = ClassWebResource.rmFilter(this._reqfilters, ext, filter);
        }
        if ((flags & 2) != 0) {
            removed = ClassWebResource.rmFilter(this._incfilters, ext, filter) || removed;
        }
        return removed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean rmFilter(Map filters, String ext, Filter filter) {
        FastReadArray ary;
        Map map = filters;
        synchronized (map) {
            ary = (FastReadArray)filters.get(ext);
        }
        if (ary != null && ary.remove((Object)filter)) {
            if (ary.isEmpty()) {
                map = filters;
                synchronized (map) {
                    ary = (FastReadArray)filters.remove(ext);
                    if (ary != null && !ary.isEmpty()) {
                        filters.put(ext, ary);
                    }
                }
            }
            return true;
        }
        return false;
    }

    public void setCompress(String[] exts) {
        this._compressExts = exts != null && exts.length > 0 ? exts : null;
    }

    public String[] getCompress() {
        return this._compressExts;
    }

    public boolean isDebugJS() {
        return this._debugJS;
    }

    public void setDebugJS(boolean debug) {
        this._debugJS = debug;
    }

    private void web(HttpServletRequest request, HttpServletResponse response, String pi) throws ServletException, IOException {
        String ext;
        Filter[] filters;
        String ZVER = "/_zv";
        if (pi.startsWith("/_zv")) {
            int j = pi.indexOf(47, "/_zv".length());
            if (j >= 0) {
                pi = pi.substring(j);
            } else {
                log.warning("Unknown path info: " + pi);
            }
        }
        String jsextra = null;
        String ZCB = "/_zcb";
        if (pi.startsWith("/_zcb")) {
            int j = pi.indexOf(47, "/_zcb".length());
            if (j >= 0) {
                jsextra = pi.substring("/_zcb".length(), j);
                pi = pi.substring(j);
            } else {
                jsextra = pi.substring("/_zcb".length());
                log.warning("Unknown path info: " + pi);
            }
            int len = jsextra.length();
            if (len == 0) {
                jsextra = null;
            } else {
                char cc;
                StringBuffer jesb = new StringBuffer(jsextra);
                int begin = jsextra.indexOf("-");
                if (begin > -1) {
                    jesb.replace(begin, begin + 1, "(").append(")");
                }
                if ((cc = jesb.charAt(jesb.length() - 1)) != ';') {
                    if (cc != ')') {
                        jesb.append("()");
                    }
                    jesb.append(';');
                }
                if (jsextra.charAt(0) != ';') {
                    jesb.insert(0, "\n;");
                } else {
                    jesb.insert(0, '\n');
                }
                jsextra = jesb.toString();
            }
        }
        if ((filters = this.getFilters(ext = Servlets.getExtension(pi, false), Servlets.isIncluded((ServletRequest)request) ? 2 : 1)) == null) {
            this.web0(request, response, pi, ext, jsextra);
        } else {
            new FilterChainImpl(filters, pi, ext, jsextra).doFilter(request, response);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void web0(HttpServletRequest request, HttpServletResponse response, String pi, String ext, String jsextra) throws ServletException, IOException {
        byte[] data;
        byte[] extra;
        block18: {
            String orgpi;
            Extendlet extlet;
            if (ext != null && (extlet = this.getExtendlet(ext)) != null) {
                extlet.service(request, response, pi, jsextra);
                return;
            }
            if (!Servlets.isIncluded((ServletRequest)request)) {
                String ctype = ContentTypes.getContentType((String)ext);
                if (ctype == null) {
                    ctype = ";charset=UTF-8";
                } else {
                    int k = ctype.indexOf(59);
                    if (k >= 0) {
                        ctype = ctype.substring(0, k);
                    }
                    if (!ContentTypes.isBinary((String)ctype)) {
                        ctype = ctype + ";charset=UTF-8";
                    }
                }
                response.setContentType(ctype);
            }
            extra = jsextra != null ? jsextra.getBytes("UTF-8") : null;
            InputStream is = null;
            if (this._debugJS && "js".equals(ext) && (is = ClassWebResource.getResourceAsStream(orgpi = Servlets.locate(this._ctx, (ServletRequest)request, pi.substring(0, pi.length() - 3) + ".org.js", this._cwc.getLocator()))) != null) {
                pi = orgpi;
            }
            if (is == null) {
                pi = Servlets.locate(this._ctx, (ServletRequest)request, pi, this._cwc.getLocator());
                is = ClassWebResource.getResourceAsStream(pi);
            }
            if (is == null) {
                if ("js".equals(ext)) {
                    data = ("(window.zk&&zk.error?zk.error:alert)('" + pi + " not found');").getBytes();
                    break block18;
                } else {
                    if (Servlets.isIncluded((ServletRequest)request)) {
                        log.error("Resource not found: " + pi);
                    }
                    response.sendError(404, pi);
                    return;
                }
            }
            byte[] byArray = data = this.shallCompress((ServletRequest)request, ext) ? Https.gzip(request, response, is, extra) : null;
            if (data != null) {
                extra = null;
            } else {
                data = Files.readAll((InputStream)is);
            }
            try {
                is.close();
            }
            catch (Throwable ex) {
                // empty catch block
            }
        }
        int len = data.length;
        if (extra != null) {
            len += extra.length;
        }
        response.setContentLength(len);
        ServletOutputStream out = response.getOutputStream();
        out.write(data);
        if (extra != null) {
            out.write(extra);
        }
        out.flush();
    }

    private boolean shallCompress(ServletRequest request, String ext) {
        if (ext != null && this._compressExts != null && !Servlets.isIncluded(request)) {
            for (int j = 0; j < this._compressExts.length; ++j) {
                if (!ext.equals(this._compressExts[j])) continue;
                return true;
            }
        }
        return false;
    }

    private class FilterChainImpl
    implements FilterChain {
        private final Filter[] _filters;
        private final String _pi;
        private final String _ext;
        private final String _jsextra;
        private int _j;

        private FilterChainImpl(Filter[] filters, String pi, String ext, String jsextra) throws ServletException, IOException {
            this._pi = pi;
            this._filters = filters;
            this._ext = ext;
            this._jsextra = jsextra;
        }

        public void doFilter(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
            int j;
            if (this._j > this._filters.length) {
                throw new IllegalStateException("Out of bound: " + this._j + ", filter=" + Objects.toString((Object)this._filters));
            }
            if ((j = this._j++) == this._filters.length) {
                ClassWebResource.this.web0(request, response, this._pi, this._ext, this._jsextra);
            } else {
                this._filters[j].doFilter(request, response, this._pi, this);
            }
        }
    }

    private class ClassWebContext
    implements ExtendletContext {
        private final Locator _locator = new Locator(){

            public String getDirectory() {
                return null;
            }

            public URL getResource(String name) {
                return ClassWebResource.getResource(name);
            }

            public InputStream getResourceAsStream(String name) {
                return ClassWebResource.getResourceAsStream(name);
            }
        };

        private ClassWebContext() {
        }

        public ClassWebResource getClassWebResource() {
            return ClassWebResource.this;
        }

        public ServletContext getServletContext() {
            return ClassWebResource.this._ctx;
        }

        public Locator getLocator() {
            return this._locator;
        }

        public boolean shallCompress(ServletRequest request, String ext) {
            return ClassWebResource.this.shallCompress(request, ext);
        }

        public String encodeURL(ServletRequest request, ServletResponse response, String uri) throws ServletException, UnsupportedEncodingException {
            int j;
            uri = Servlets.locate(ClassWebResource.this._ctx, request, uri, this.getLocator());
            uri = ClassWebResource.this._mappingURI + ClassWebResource.PATH_PREFIX + uri;
            if (request instanceof HttpServletRequest) {
                String ctxpath = ((HttpServletRequest)request).getContextPath();
                int ctxlen = ctxpath.length();
                if (ctxlen > 0) {
                    char cc = ctxpath.charAt(0);
                    if (cc != '/') {
                        ctxpath = '/' + ctxpath;
                    } else if (ctxlen == 1) {
                        ctxpath = "";
                    }
                }
                uri = ctxpath + uri;
            }
            uri = (j = uri.indexOf(63)) < 0 ? Encodes.encodeURI(uri) : Encodes.encodeURI(uri.substring(0, j)) + uri.substring(j);
            if (response instanceof HttpServletResponse) {
                uri = ((HttpServletResponse)response).encodeURL(uri);
            }
            return uri;
        }

        public String encodeRedirectURL(HttpServletRequest request, HttpServletResponse response, String uri, Map params, int mode) {
            return Https.encodeRedirectURL(ClassWebResource.this._ctx, request, response, ClassWebResource.this._mappingURI + ClassWebResource.PATH_PREFIX + uri, params, mode);
        }

        public RequestDispatcher getRequestDispatcher(String uri) {
            return ClassWebResource.this._ctx.getRequestDispatcher(ClassWebResource.this._mappingURI + ClassWebResource.PATH_PREFIX + uri);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void include(HttpServletRequest request, HttpServletResponse response, String uri, Map params) throws ServletException, IOException {
            if (uri.startsWith("~./") && uri.indexOf(63) < 0 && this.isDirectInclude(uri)) {
                Object old = request.getAttribute("arg");
                if (params != null) {
                    request.setAttribute("arg", (Object)params);
                }
                String attrnm = "org.zkoss.web.servlet.include";
                request.setAttribute("org.zkoss.web.servlet.include", (Object)Boolean.TRUE);
                try {
                    ClassWebResource.this.service(request, response, uri.substring(2));
                }
                finally {
                    request.removeAttribute("org.zkoss.web.servlet.include");
                    request.setAttribute("arg", old);
                }
            } else {
                Servlets.include(ClassWebResource.this._ctx, (ServletRequest)request, (ServletResponse)response, uri, params, 3);
            }
        }

        private boolean isDirectInclude(String path) {
            Extendlet extlet;
            String ext = Servlets.getExtension(path);
            Extendlet extendlet = extlet = ext != null ? ClassWebResource.this.getExtendlet(ext) : null;
            if (extlet != null) {
                try {
                    return extlet.getFeature(1);
                }
                catch (Throwable ex) {
                    // empty catch block
                }
            }
            return true;
        }

        public URL getResource(String uri) {
            return ClassWebResource.getResource(uri);
        }

        public InputStream getResourceAsStream(String uri) {
            return ClassWebResource.getResourceAsStream(uri);
        }
    }
}

