/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import java.io.InputStream;
import java.net.URL;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Library;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Loader;
import org.zkoss.web.util.resource.ExtendletContext;

public abstract class ExtendletLoader
implements Loader {
    private static final Log log = Log.lookup((Class)ExtendletLoader.class);
    private int _checkPeriod = ExtendletLoader.getInitCheckPeriod();

    protected ExtendletLoader() {
    }

    public boolean shallCheck(Object src, long expiredMillis) {
        return expiredMillis > 0L;
    }

    public long getLastModified(Object src) {
        if (this.getCheckPeriod() < 0) {
            return 1L;
        }
        try {
            URL url = this.getExtendletContext().getResource((String)src);
            return url != null ? url.openConnection().getLastModified() : -1L;
        }
        catch (Throwable ex) {
            return -1L;
        }
    }

    public Object load(Object src) throws Exception {
        String path = (String)src;
        InputStream is = this.getExtendletContext().getResourceAsStream(path);
        if (is == null) {
            return null;
        }
        try {
            return this.parse(is, path);
        }
        catch (Exception ex) {
            if (log.debugable()) {
                log.realCauseBriefly("Failed to parse " + path, (Throwable)ex);
            } else {
                log.error("Failed to parse " + path + "\nCause: " + ex.getClass().getName() + " " + Exceptions.getMessage((Throwable)ex) + "\n" + Exceptions.getBriefStackTrace((Throwable)ex));
            }
            return null;
        }
    }

    protected abstract Object parse(InputStream var1, String var2) throws Exception;

    protected abstract ExtendletContext getExtendletContext();

    public int getCheckPeriod() {
        return this._checkPeriod;
    }

    private static int getInitCheckPeriod() {
        String ATTR = "org.zkoss.util.resource.extendlet.checkPeriod";
        String s = Library.getProperty((String)"org.zkoss.util.resource.extendlet.checkPeriod");
        try {
            int i;
            if (s != null && (i = Integer.parseInt(s)) > 0) {
                return i * 1000;
            }
        }
        catch (Throwable ex) {
            log.warningBriefly("Failed to parse org.zkoss.util.resource.extendlet.checkPeriod, value=" + s, ex);
        }
        return -1;
    }
}

