/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet;

import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Objects;
import org.zkoss.util.Locales;
import org.zkoss.util.logging.Log;
import org.zkoss.web.servlet.Servlets;

public class Charsets {
    private static final Log log = Log.lookup((Class)Charsets.class);
    private static final String ATTR_SETUP = "org.zkoss.web.charset.setup";
    private static final String _uriCharset;

    public static final String getURICharset() {
        return _uriCharset;
    }

    public static final Object setup(ServletRequest request, ServletResponse response, String charset) {
        Locale locale;
        block15: {
            String v;
            if (Charsets.hasSetup(request)) {
                return Objects.UNKNOWN;
            }
            locale = Charsets.getPreferredLocale(request);
            response.setLocale(locale);
            if (charset != null && charset.length() > 0) {
                try {
                    if (Servlets.isServlet24()) {
                        response.setCharacterEncoding(charset);
                    } else {
                        int j;
                        String orgtype = response.getContentType();
                        String ctype = orgtype != null ? ((j = orgtype.indexOf(59)) >= 0 ? orgtype.substring(0, j) : orgtype) : "";
                        response.setContentType(ctype + ";charset=" + charset);
                        if (orgtype == null) {
                            try {
                                response.setContentType(null);
                            }
                            catch (Throwable t) {}
                        }
                    }
                }
                catch (Throwable ex) {
                    try {
                        v = response.getCharacterEncoding();
                        if (!Objects.equals((Object)v, (Object)charset)) {
                            log.warning("Unable to set response's charset: " + charset + " (current=" + v + ')', ex);
                        }
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                }
            }
            if (request.getCharacterEncoding() == null) {
                charset = response.getCharacterEncoding();
                try {
                    request.setCharacterEncoding(charset);
                }
                catch (Throwable ex) {
                    v = request.getCharacterEncoding();
                    if (Objects.equals((Object)v, (Object)charset)) break block15;
                    log.warning("Unable to set request's charset: " + charset + " (current=" + v + "): " + Exceptions.getMessage((Throwable)ex));
                }
            }
        }
        Charsets.markSetup(request, true);
        return Locales.setThreadLocal((Locale)locale);
    }

    public static final void cleanup(ServletRequest request, Object old) {
        if (old != Objects.UNKNOWN) {
            Locales.setThreadLocal((Locale)((Locale)old));
            Charsets.markSetup(request, false);
        }
    }

    public static final boolean hasSetup(ServletRequest request) {
        return request.getAttribute(ATTR_SETUP) != null;
    }

    public static final void markSetup(ServletRequest request, boolean setup) {
        if (setup) {
            request.setAttribute(ATTR_SETUP, (Object)Boolean.TRUE);
        } else {
            request.removeAttribute(ATTR_SETUP);
        }
    }

    public static final Locale getPreferredLocale(ServletRequest request) {
        Locale l;
        Object v;
        HttpSession sess;
        if (request instanceof HttpServletRequest && (sess = ((HttpServletRequest)request).getSession(false)) != null && (v = sess.getAttribute("px_preferred_locale")) != null) {
            if (v instanceof Locale) {
                return (Locale)v;
            }
            log.warning("px_preferred_locale ignored. Locale is required, not " + v.getClass());
        }
        return (l = request.getLocale()) != null ? l : Locale.getDefault();
    }

    public static final void setPreferredLocale(ServletRequest request, Locale locale) {
        if (request instanceof HttpServletRequest) {
            HttpSession sess = ((HttpServletRequest)request).getSession();
            if (locale != null) {
                sess.setAttribute("px_preferred_locale", (Object)locale);
            } else {
                sess.removeAttribute("px_preferred_locale");
            }
        }
    }

    static {
        String cs = System.getProperty("org.zkoss.web.uri.charset", null);
        if (cs == null || cs.length() == 0) {
            cs = "UTF-8";
        }
        _uriCharset = cs;
    }
}

