/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.io.Files;
import org.zkoss.util.logging.Log;
import org.zkoss.util.media.ContentTypes;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.Locators;
import org.zkoss.web.servlet.Charsets;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.web.util.resource.DspExtendlet;
import org.zkoss.web.util.resource.Extendlet;
import org.zkoss.web.util.resource.ExtendletConfig;
import org.zkoss.web.util.resource.ExtendletContext;

public class ClassWebResource {
    private static final Log log = Log.lookup((Class)ClassWebResource.class);
    private final ServletContext _ctx;
    private final String _mappingURI;
    private final ClassWebContext _cwc;
    private String[] _compressExts;
    private final Map _extlets = new HashMap(5);
    private boolean _debugJS;
    public static final String PATH_PREFIX = "/web";

    public static URL getResource(String uri) {
        return Locators.getDefault().getResource(PATH_PREFIX + uri);
    }

    public static InputStream getResourceAsStream(String uri) {
        return Locators.getDefault().getResourceAsStream(PATH_PREFIX + uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ClassWebResource getInstance(ServletContext ctx, String mappingURI) {
        ServletContext servletContext = ctx;
        synchronized (servletContext) {
            ClassWebContext cwc = (ClassWebContext)Servlets.getExtendletContext(ctx, ".");
            if (cwc != null) {
                return cwc.getClassWebResource();
            }
            ClassWebResource cwr = new ClassWebResource(ctx, mappingURI);
            Servlets.addExtendletContext(ctx, ".", cwr._cwc);
            return cwr;
        }
    }

    private ClassWebResource(ServletContext ctx, String mappingURI) {
        if (!mappingURI.startsWith("/") || mappingURI.endsWith("/")) {
            throw new IllegalArgumentException("mappingURI must start with /, but not ends with /");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("null ctx");
        }
        this._ctx = ctx;
        this._mappingURI = mappingURI;
        this._cwc = new ClassWebContext();
        this.addExtendlet("dsp", new DspExtendlet());
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String pi = Https.getThisPathInfo((ServletRequest)request);
        if (pi != null) {
            this.service(request, response, pi.substring(PATH_PREFIX.length()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(HttpServletRequest request, HttpServletResponse response, String path) throws ServletException, IOException {
        Object old = Charsets.setup((ServletRequest)request, (ServletResponse)response, "UTF-8");
        try {
            this.web(request, response, path);
        }
        finally {
            Charsets.cleanup((ServletRequest)request, old);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extendlet getExtendlet(String ext) {
        if (ext == null) {
            return null;
        }
        ext = ext.toLowerCase();
        Map map = this._extlets;
        synchronized (map) {
            return (Extendlet)this._extlets.get(ext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extendlet addExtendlet(String ext, Extendlet extlet) {
        if (ext == null || extlet == null) {
            throw new IllegalArgumentException("null");
        }
        extlet.init(new ExtendletConfig(){

            public ExtendletContext getExtendletContext() {
                return ClassWebResource.this._cwc;
            }
        });
        ext = ext.toLowerCase();
        Map map = this._extlets;
        synchronized (map) {
            return this._extlets.put(ext, extlet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Extendlet removeExtendlet(String ext) {
        if (ext == null) {
            return null;
        }
        ext = ext.toLowerCase();
        Map map = this._extlets;
        synchronized (map) {
            return (Extendlet)this._extlets.remove(ext);
        }
    }

    public void setCompress(String[] exts) {
        this._compressExts = exts != null && exts.length > 0 ? exts : null;
    }

    public String[] getCompress() {
        return this._compressExts;
    }

    public boolean isDebugJS() {
        return this._debugJS;
    }

    public void setDebugJS(boolean debug) {
        this._debugJS = debug;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void web(HttpServletRequest request, HttpServletResponse response, String pi) throws ServletException, IOException {
        byte[] data;
        byte[] extra;
        block24: {
            String orgpi;
            String ext;
            String ZVER = "/_zv";
            if (pi.startsWith("/_zv")) {
                int j = pi.indexOf(47, "/_zv".length());
                if (j >= 0) {
                    pi = pi.substring(j);
                } else {
                    log.warning("Unknown path info: " + pi);
                }
            }
            String jsextra = null;
            String ZCB = "/_zcb";
            if (pi.startsWith("/_zcb")) {
                int j = pi.indexOf(47, "/_zcb".length());
                if (j >= 0) {
                    jsextra = pi.substring("/_zcb".length(), j);
                    pi = pi.substring(j);
                } else {
                    jsextra = pi.substring("/_zcb".length());
                    log.warning("Unknown path info: " + pi);
                }
                int len = jsextra.length();
                if (len == 0) {
                    jsextra = null;
                } else {
                    char cc = jsextra.charAt(0);
                    if (cc != ';') {
                        jsextra = ';' + jsextra;
                        ++len;
                    }
                    if ((cc = jsextra.charAt(len - 1)) != ';') {
                        if (cc != ')') {
                            jsextra = jsextra + "()";
                        }
                        jsextra = jsextra + ';';
                    }
                }
            }
            if ((ext = Servlets.getExtension(pi)) != null) {
                String ctype;
                Extendlet extlet = this.getExtendlet(ext);
                if (extlet != null) {
                    extlet.service(request, response, pi, jsextra);
                    return;
                }
                if (!Servlets.isIncluded((ServletRequest)request) && (ctype = ContentTypes.getContentType((String)ext)) != null) {
                    response.setContentType(ctype);
                }
            }
            extra = jsextra != null ? jsextra.getBytes("UTF-8") : null;
            InputStream is = null;
            if (this._debugJS && pi.endsWith(".js") && (is = ClassWebResource.getResourceAsStream(orgpi = Servlets.locate(this._ctx, (ServletRequest)request, pi.substring(0, pi.length() - 3) + ".org.js", this._cwc.getLocator()))) != null) {
                pi = orgpi;
            }
            if (is == null) {
                pi = Servlets.locate(this._ctx, (ServletRequest)request, pi, this._cwc.getLocator());
                is = ClassWebResource.getResourceAsStream(pi);
            }
            if (is == null) {
                if ("js".equals(ext)) {
                    data = ("(zk.error?zk.error:alert)('" + pi + " not found');").getBytes();
                    break block24;
                } else {
                    if (Servlets.isIncluded((ServletRequest)request)) {
                        log.error("Resource not found: " + pi);
                    }
                    response.sendError(404, pi);
                    return;
                }
            }
            byte[] byArray = data = this.shallCompress((ServletRequest)request, ext) ? Https.gzip(request, response, is, extra) : null;
            if (data != null) {
                extra = null;
            } else {
                data = Files.readAll((InputStream)is);
            }
        }
        int len = data.length;
        if (extra != null) {
            len += extra.length;
        }
        response.setContentLength(len);
        ServletOutputStream out = response.getOutputStream();
        out.write(data);
        if (extra != null) {
            out.write(extra);
        }
        out.flush();
    }

    private boolean shallCompress(ServletRequest request, String ext) {
        if (ext != null && this._compressExts != null && !Servlets.isIncluded(request)) {
            for (int j = 0; j < this._compressExts.length; ++j) {
                if (!ext.equals(this._compressExts[j])) continue;
                return true;
            }
        }
        return false;
    }

    private class ClassWebContext
    implements ExtendletContext {
        private final Locator _locator = new Locator(){

            public String getDirectory() {
                return null;
            }

            public URL getResource(String name) {
                return ClassWebResource.getResource(name);
            }

            public InputStream getResourceAsStream(String name) {
                return ClassWebResource.getResourceAsStream(name);
            }
        };

        private ClassWebContext() {
        }

        public ClassWebResource getClassWebResource() {
            return ClassWebResource.this;
        }

        public ServletContext getServletContext() {
            return ClassWebResource.this._ctx;
        }

        public Locator getLocator() {
            return this._locator;
        }

        public boolean shallCompress(ServletRequest request, String ext) {
            return ClassWebResource.this.shallCompress(request, ext);
        }

        public String encodeURL(ServletRequest request, ServletResponse response, String uri) throws ServletException, UnsupportedEncodingException {
            int j;
            uri = Servlets.locate(ClassWebResource.this._ctx, request, uri, this.getLocator());
            uri = ClassWebResource.this._mappingURI + ClassWebResource.PATH_PREFIX + uri;
            if (request instanceof HttpServletRequest) {
                String ctxpath = ((HttpServletRequest)request).getContextPath();
                int ctxlen = ctxpath.length();
                if (ctxlen > 0) {
                    char cc = ctxpath.charAt(0);
                    if (cc != '/') {
                        ctxpath = '/' + ctxpath;
                    } else if (ctxlen == 1) {
                        ctxpath = "";
                    }
                }
                uri = ctxpath + uri;
            }
            uri = (j = uri.indexOf(63)) < 0 ? Encodes.encodeURI(uri) : Encodes.encodeURI(uri.substring(0, j)) + uri.substring(j);
            if (response instanceof HttpServletResponse) {
                uri = ((HttpServletResponse)response).encodeURL(uri);
            }
            return uri;
        }

        public String encodeRedirectURL(HttpServletRequest request, HttpServletResponse response, String uri, Map params, int mode) {
            return Https.encodeRedirectURL(ClassWebResource.this._ctx, request, response, ClassWebResource.this._mappingURI + ClassWebResource.PATH_PREFIX + uri, params, mode);
        }

        public RequestDispatcher getRequestDispatcher(String uri) {
            return ClassWebResource.this._ctx.getRequestDispatcher(ClassWebResource.this._mappingURI + ClassWebResource.PATH_PREFIX + uri);
        }

        public URL getResource(String uri) {
            return ClassWebResource.getResource(uri);
        }

        public InputStream getResourceAsStream(String uri) {
            return ClassWebResource.getResourceAsStream(uri);
        }
    }
}

