/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.dsp.impl;

import java.io.IOException;
import org.zkoss.util.logging.Log;
import org.zkoss.web.servlet.ServletException;
import org.zkoss.web.servlet.dsp.impl.InterpretContext;
import org.zkoss.web.servlet.dsp.impl.Node;
import org.zkoss.web.servlet.dsp.impl.ParseContext;
import org.zkoss.xel.Expression;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.XelException;

class XelNode
extends Node {
    private static final Log log = Log.lookup((Class)XelNode.class);
    private final Expression _expr;

    XelNode(String expr, ParseContext ctx) throws XelException {
        this._expr = ctx.getExpressionFactory().parseExpression((XelContext)ctx, expr, String.class);
    }

    void interpret(InterpretContext ic) throws javax.servlet.ServletException, IOException {
        try {
            String result = (String)this._expr.evaluate(ic.xelc);
            if (result != null) {
                ic.dc.getOut().write(result);
            }
        }
        catch (XelException ex) {
            log.realCause((Throwable)ex);
            throw new ServletException("Unable to evaluate an EL expression: " + this._expr, (Throwable)ex);
        }
    }

    void addChild(Node node) {
        throw new IllegalStateException("No child allowed");
    }

    public String toString() {
        return "EL[" + this._expr + ']';
    }
}

