/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.dsp.impl;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Exceptions;
import org.zkoss.util.logging.Log;
import org.zkoss.web.servlet.ServletException;
import org.zkoss.web.servlet.dsp.action.Action;
import org.zkoss.web.servlet.dsp.impl.ActionContextImpl;
import org.zkoss.web.servlet.dsp.impl.InterpretContext;
import org.zkoss.web.servlet.dsp.impl.Node;
import org.zkoss.xel.VariableResolver;

class ActionNode
extends Node {
    private static final Log log = Log.lookup((Class)ActionNode.class);
    private final Class _cls;
    private List _attrs;
    private final int _nLines;

    ActionNode(Class cls, int nLines) {
        this._cls = cls;
        this._nLines = nLines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interpret(InterpretContext ic) throws javax.servlet.ServletException, IOException {
        Action parent = ic.action;
        try {
            ic.action = this.newAction();
            if (this._attrs != null) {
                Iterator it = this._attrs.iterator();
                while (it.hasNext()) {
                    ((Attr)it.next()).apply(ic, ic.action);
                }
            }
            ic.action.render(new ActionContextImpl(ic, parent, this, this._nLines), this._children != null);
        }
        finally {
            ic.action = parent;
        }
    }

    private Action newAction() throws javax.servlet.ServletException {
        try {
            return (Action)this._cls.newInstance();
        }
        catch (Exception ex) {
            throw new ServletException("Failed to create " + this._cls + ". Cause: " + Exceptions.getMessage((Throwable)ex));
        }
    }

    int getLineNumber() {
        return this._nLines;
    }

    void renderFragment(InterpretContext ic) throws javax.servlet.ServletException, IOException {
        if (this._children == null) {
            return;
        }
        Iterator it = this._children.iterator();
        while (it.hasNext()) {
            ((Node)it.next()).interpret(ic);
        }
    }

    void addAttribute(String nm, String val) throws NoSuchMethodException, ClassCastException {
        if (nm == null || val == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._attrs == null) {
            this._attrs = new LinkedList();
        }
        Method mtd = (Method)Classes.getAccessibleObject((Class)this._cls, (String)nm, (Class[])new Class[]{null}, (int)7);
        if (val.indexOf("${") >= 0) {
            this._attrs.add(new Attr(mtd, val, true));
        } else {
            this._attrs.add(new Attr(mtd, Classes.coerce(mtd.getParameterTypes()[0], (Object)val), false));
        }
    }

    public String toString() {
        return "Action[" + this._cls.getName() + ']';
    }

    private static class Attr {
        private final Method _method;
        private final Object _value;
        private final boolean _bExpr;

        private Attr(Method mtd, Object val, boolean expr) {
            this._method = mtd;
            this._value = val;
            this._bExpr = expr;
        }

        private void apply(InterpretContext ic, Action action) throws javax.servlet.ServletException {
            Object[] args = new Object[1];
            try {
                args[0] = this._bExpr ? ic.dc.getExpressionEvaluator().evaluate((String)this._value, this._method.getParameterTypes()[0], (VariableResolver)ic.resolver, ic.mapper) : this._value;
                this._method.invoke((Object)action, args);
            }
            catch (Exception ex) {
                if (log.debugable()) {
                    log.debug((Throwable)ex);
                }
                throw new ServletException("Failed to invoke " + this._method + " with " + args[0] + (args[0] != null ? " @" + args[0].getClass().getName() : "") + (this._bExpr ? " (" + this._value + ')' : "") + ". Cause: " + ex.getClass().getName() + ", " + Exceptions.getMessage((Throwable)ex) + "\n" + Exceptions.getBriefStackTrace((Throwable)ex));
            }
        }
    }
}

