/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.dsp.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import javax.servlet.ServletException;
import org.zkoss.web.servlet.BufferedResponse;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.dsp.action.Action;
import org.zkoss.web.servlet.dsp.action.ActionContext;
import org.zkoss.web.servlet.dsp.impl.ActionNode;
import org.zkoss.web.servlet.dsp.impl.InterpretContext;
import org.zkoss.web.servlet.http.Encodes;

class ActionContextImpl
implements ActionContext {
    private final InterpretContext _ic;
    private final Action _parent;
    private final ActionNode _current;
    private final int _nLines;

    ActionContextImpl(InterpretContext ic, Action parent, ActionNode current, int nLines) {
        this._ic = ic;
        this._parent = parent;
        this._nLines = nLines;
        this._current = current;
    }

    public Object getAttribute(String name, int scope) {
        return this._ic.resolver.getAttributes(scope).get(name);
    }

    public void setAttribute(String name, Object value, int scope) {
        if (value == null) {
            this.removeAttribute(name, scope);
            return;
        }
        this._ic.resolver.getAttributes(scope).put(name, value);
    }

    public void removeAttribute(String name, int scope) {
        this._ic.resolver.getAttributes(scope).remove(name);
    }

    public Object findAttribute(String name) {
        Object o = this.getAttribute(name, 0);
        if (o != null) {
            return o;
        }
        o = this.getAttribute(name, 1);
        if (o != null) {
            return o;
        }
        o = this.getAttribute(name, 2);
        return o != null ? o : this.getAttribute(name, 3);
    }

    public void setContentType(String ctype) {
        this._ic.dc.setContentType(ctype);
    }

    public Writer getOut() throws IOException {
        return this._ic.dc.getOut();
    }

    public Action getParent() {
        return this._parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renderFragment(Writer out) throws ServletException, IOException {
        if (out == null || out == this._ic.dc.getOut()) {
            this._current.renderFragment(this._ic);
        } else {
            Writer old = this._ic.dc.getOut();
            this._ic.dc.setOut(out);
            try {
                this._current.renderFragment(this._ic);
            }
            finally {
                this._ic.dc.setOut(old);
            }
        }
    }

    public void include(String uri, Map params) throws ServletException, IOException {
        Servlets.include(this._ic.dc.getServletContext(), this._ic.dc.getRequest(), BufferedResponse.getInstance(this._ic.dc.getResponse(), this._ic.dc.getOut()), uri, params, 3);
    }

    public boolean isIncluded() {
        return Servlets.isIncluded(this._ic.dc.getRequest());
    }

    public String encodeURL(String uri) throws ServletException {
        return Encodes.encodeURL(this._ic.dc.getServletContext(), this._ic.dc.getRequest(), this._ic.dc.getResponse(), uri);
    }

    public int getLineNumber() {
        return this._nLines;
    }
}

