/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.io.Files;
import org.zkoss.lang.Exceptions;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Loader;
import org.zkoss.util.resource.ResourceCache;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.dsp.Interpretation;
import org.zkoss.web.servlet.dsp.Interpreter;
import org.zkoss.web.servlet.dsp.ServletDSPContext;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.web.util.resource.Extendlet;
import org.zkoss.web.util.resource.ExtendletConfig;
import org.zkoss.web.util.resource.ExtendletContext;

class DSPExtendlet
implements Extendlet {
    private static final Log log = Log.lookup((Class)DSPExtendlet.class);
    private ExtendletContext _webctx;
    private ResourceCache _cache;

    DSPExtendlet() {
    }

    public void init(ExtendletConfig config) {
        this._webctx = config.getExtendletContext();
        this._cache = new ResourceCache((Loader)new DSPLoader(), 131);
        this._cache.setMaxSize(1000).setLifetime(3600000);
        this._cache.setCheckPeriod(3600000);
    }

    public void service(HttpServletRequest request, HttpServletResponse response, String path, String extra) throws ServletException, IOException {
        Interpretation cnt = (Interpretation)this._cache.get((Object)path);
        if (cnt == null) {
            if (Servlets.isIncluded((ServletRequest)request)) {
                log.error("Failed to load the resource: " + path);
            }
            response.sendError(404, path);
            return;
        }
        StringWriter sw = this._webctx.shallCompress((ServletRequest)request, DSPExtendlet.get2ndExtension(path)) ? new StringWriter(4096) : null;
        cnt.interpret(new ServletDSPContext(this._webctx.getServletContext(), request, response, sw, this._webctx.getLocator()));
        if (extra != null) {
            (sw != null ? sw : response.getWriter()).write(extra);
        }
        if (sw != null) {
            byte[] bs;
            byte[] data = sw.toString().getBytes("UTF-8");
            sw = null;
            if (data.length > 200 && (bs = Https.gzip(request, response, null, data)) != null) {
                data = bs;
            }
            response.setContentLength(data.length);
            response.getOutputStream().write(data);
            response.flushBuffer();
        }
    }

    private static final String get2ndExtension(String path) {
        int k;
        int j = path.lastIndexOf(46);
        if (j < 0 || path.indexOf(47, j + 1) >= 0) {
            return null;
        }
        int n = k = j > 0 ? path.lastIndexOf(46, j - 1) : -1;
        if (k < 0 || path.indexOf(47, k + 1) >= 0) {
            return null;
        }
        return path.substring(k + 1, j).toLowerCase();
    }

    private class DSPLoader
    implements Loader {
        private DSPLoader() {
        }

        public boolean shallCheck(Object src, long expiredMillis) {
            return expiredMillis > 0L;
        }

        public long getLastModified(Object src) {
            return 1L;
        }

        public Object load(Object src) throws Exception {
            String path = (String)src;
            InputStream is = DSPExtendlet.this._webctx.getResourceAsStream(path);
            if (is == null) {
                return null;
            }
            try {
                return this.parse0(is, Interpreter.getContentType(path));
            }
            catch (Exception ex) {
                if (log.debugable()) {
                    log.realCauseBriefly("Failed to parse " + path, (Throwable)ex);
                } else {
                    log.error("Failed to parse " + path + "\nCause: " + ex.getClass().getName() + " " + Exceptions.getMessage((Throwable)ex) + "\n" + Exceptions.getBriefStackTrace((Throwable)ex));
                }
                return null;
            }
        }

        private Object parse0(InputStream is, String ctype) throws Exception {
            String content = Files.readAll((Reader)new InputStreamReader(is, "UTF-8")).toString();
            return new Interpreter().parse(content, ctype, null, DSPExtendlet.this._webctx.getLocator());
        }
    }
}

