/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.dsp;

import java.io.IOException;
import java.io.Writer;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import org.zkoss.el.EvaluatorImpl;
import org.zkoss.el.RequestResolver;
import org.zkoss.util.resource.Locator;
import org.zkoss.web.servlet.dsp.DSPContext;
import org.zkoss.web.util.resource.ServletContextLocator;

public class ServletDSPContext
implements DSPContext {
    private final Locator _locator;
    private final ServletContext _ctx;
    private final HttpServletRequest _request;
    private final HttpServletResponse _response;
    private Writer _out;
    private VariableResolver _resolver;
    private ExpressionEvaluator _eval;

    public ServletDSPContext(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, Locator locator) {
        this(ctx, request, response, null, locator);
    }

    public ServletDSPContext(ServletContext ctx, HttpServletRequest request, HttpServletResponse response, Writer out, Locator locator) {
        this._locator = locator != null ? locator : new ServletContextLocator(ctx);
        this._ctx = ctx;
        this._request = request;
        this._response = response;
        this._out = out;
    }

    public Locator getLocator() {
        return this._locator;
    }

    public void setContentType(String ctype) {
        this._response.setContentType(ctype);
    }

    public void setOut(Writer out) {
        this._out = out;
    }

    public Writer getOut() throws IOException {
        return this._out != null ? this._out : this._response.getWriter();
    }

    public ServletRequest getRequest() {
        return this._request;
    }

    public ServletResponse getResponse() {
        return this._response;
    }

    public ServletContext getServletContext() {
        return this._ctx;
    }

    public ExpressionEvaluator getExpressionEvaluator() {
        if (this._eval == null) {
            this._eval = new EvaluatorImpl();
        }
        return this._eval;
    }

    public VariableResolver getVariableResolver() {
        if (this._resolver == null) {
            this._resolver = new RequestResolver(this._ctx, (ServletRequest)this._request, (ServletResponse)this._response);
        }
        return this._resolver;
    }
}

