/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.zkoss.io.Files;
import org.zkoss.lang.Exceptions;
import org.zkoss.util.logging.Log;
import org.zkoss.util.media.ContentTypes;
import org.zkoss.util.resource.Loader;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.Locators;
import org.zkoss.util.resource.ResourceCache;
import org.zkoss.web.servlet.Charsets;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.dsp.Interpretation;
import org.zkoss.web.servlet.dsp.Interpreter;
import org.zkoss.web.servlet.dsp.ServletDSPContext;
import org.zkoss.web.servlet.http.Encodes;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.web.util.resource.ExtendedWebContext;

public class ClassWebResource {
    private static final Log log = Log.lookup((Class)ClassWebResource.class);
    private final ServletContext _ctx;
    private final String _mappingURI;
    private final ClassWebContext _cwc;
    private final ResourceCache _dspCache;
    public static final String PATH_PREFIX = "/web";

    public static URL getResource(String uri) {
        return Locators.getDefault().getResource(PATH_PREFIX + uri);
    }

    public static InputStream getResourceAsStream(String uri) {
        return Locators.getDefault().getResourceAsStream(PATH_PREFIX + uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ClassWebResource getInstance(ServletContext ctx, String mappingURI) {
        ServletContext servletContext = ctx;
        synchronized (servletContext) {
            ClassWebContext cwc = (ClassWebContext)Servlets.getExtendedWebContext(ctx, ".");
            if (cwc != null) {
                return cwc.getClassWebResource();
            }
            ClassWebResource cwr = new ClassWebResource(ctx, mappingURI);
            Servlets.addExtendedWebContext(ctx, ".", cwr._cwc);
            return cwr;
        }
    }

    private ClassWebResource(ServletContext ctx, String mappingURI) {
        if (!mappingURI.startsWith("/") || mappingURI.endsWith("/")) {
            throw new IllegalArgumentException("mappingURI must start with /, but not ends with /");
        }
        if (ctx == null) {
            throw new IllegalArgumentException("null ctx");
        }
        this._ctx = ctx;
        this._mappingURI = mappingURI;
        this._cwc = new ClassWebContext();
        this._dspCache = new ResourceCache((Loader)new DSPLoader(this._cwc), 131);
        this._dspCache.setMaxSize(1000).setLifetime(3600000);
        this._dspCache.setCheckPeriod(3600000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Object old = Charsets.setup((ServletRequest)request, (ServletResponse)response, "UTF-8");
        try {
            String pi = Https.getThisPathInfo((ServletRequest)request);
            if (pi != null) {
                this.web(request, response, pi.substring(PATH_PREFIX.length()));
            }
        }
        finally {
            Charsets.cleanup((ServletRequest)request, old);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void web(HttpServletRequest request, HttpServletResponse response, String pi) throws ServletException, IOException {
        byte[] extra;
        byte[] data;
        String jsextra;
        block24: {
            InputStream is;
            String ext;
            String ZVER = "/_zver";
            if (pi.startsWith("/_zver")) {
                int j = pi.indexOf(47, "/_zver".length());
                if (j >= 0) {
                    pi = pi.substring(j);
                } else {
                    log.warning("Unknown path info: " + pi);
                }
            }
            jsextra = null;
            String ZCB = "/_zcb";
            if (pi.startsWith("/_zcb")) {
                int j = pi.indexOf(47, "/_zcb".length());
                if (j >= 0) {
                    jsextra = pi.substring("/_zcb".length(), j);
                    pi = pi.substring(j);
                } else {
                    jsextra = pi.substring("/_zcb".length());
                    log.warning("Unknown path info: " + pi);
                }
                int len = jsextra.length();
                if (len == 0) {
                    jsextra = null;
                } else {
                    char cc = jsextra.charAt(len - 1);
                    if (cc != ';') {
                        if (cc != ')') {
                            jsextra = jsextra + "()";
                        }
                        jsextra = jsextra + ';';
                    }
                }
            }
            if ((ext = ClassWebResource.getExtension(pi)) != null) {
                if ("dsp".equals(ext)) {
                    Interpretation cnt = (Interpretation)this._dspCache.get((Object)pi);
                    if (cnt == null) {
                        if (Servlets.isIncluded((ServletRequest)request)) {
                            log.error("Failed to load the resource: " + pi);
                        }
                        response.sendError(404, pi);
                        return;
                    }
                    cnt.interpret(new ServletDSPContext(this._ctx, request, response, this._cwc.getLocator()));
                    if (jsextra != null) {
                        response.getWriter().write(jsextra);
                    }
                    return;
                }
                if (!Servlets.isIncluded((ServletRequest)request)) {
                    String ctype = ContentTypes.getContentType((String)ext);
                    if (ctype != null) {
                        response.setContentType(ctype);
                    }
                    if (log.debugable()) {
                        log.debug("Content type: " + ctype + " for " + pi);
                    }
                }
            }
            if ((is = ClassWebResource.getResourceAsStream(pi = Servlets.locate(this._ctx, (ServletRequest)request, pi, this._cwc.getLocator()))) == null) {
                if ("js".equals(ext)) {
                    data = ("(zk.error?zk.error:alert)('" + pi + " not found');").getBytes();
                    break block24;
                } else {
                    if (Servlets.isIncluded((ServletRequest)request)) {
                        log.error("Resource not found: " + pi);
                    }
                    response.sendError(404, pi);
                    return;
                }
            }
            data = Files.readAll((InputStream)is);
        }
        int len = data.length;
        byte[] byArray = extra = jsextra != null ? jsextra.getBytes("UTF-8") : null;
        if (extra != null) {
            len += extra.length;
        }
        response.setContentLength(len);
        ServletOutputStream out = response.getOutputStream();
        out.write(data);
        if (extra != null) {
            out.write(extra);
        }
        out.flush();
    }

    private static final String getExtension(String pi) {
        int j = pi.lastIndexOf(46);
        if (j < 0 || pi.indexOf(47, j + 1) >= 0) {
            return null;
        }
        String ext = pi.substring(j + 1);
        int k = ext.indexOf(59);
        return k >= 0 ? ext.substring(0, k).toLowerCase() : ext.toLowerCase();
    }

    private class ClassWebContext
    implements ExtendedWebContext {
        private ClassWebContext() {
        }

        public Locator getLocator() {
            return new Locator(){

                public String getDirectory() {
                    return null;
                }

                public URL getResource(String name) {
                    return ClassWebResource.getResource(name);
                }

                public InputStream getResourceAsStream(String name) {
                    return ClassWebResource.getResourceAsStream(name);
                }
            };
        }

        public ClassWebResource getClassWebResource() {
            return ClassWebResource.this;
        }

        public String encodeURL(ServletRequest request, ServletResponse response, String uri) throws ServletException, UnsupportedEncodingException {
            int j;
            uri = Servlets.locate(ClassWebResource.this._ctx, request, uri, this.getLocator());
            uri = ClassWebResource.this._mappingURI + ClassWebResource.PATH_PREFIX + uri;
            if (request instanceof HttpServletRequest) {
                String ctxpath = ((HttpServletRequest)request).getContextPath();
                int ctxlen = ctxpath.length();
                if (ctxlen > 0) {
                    char cc = ctxpath.charAt(0);
                    if (cc != '/') {
                        ctxpath = '/' + ctxpath;
                    } else if (ctxlen == 1) {
                        ctxpath = "";
                    }
                }
                uri = ctxpath + uri;
            }
            uri = (j = uri.indexOf(63)) < 0 ? Encodes.encodeURI(uri) : Encodes.encodeURI(uri.substring(0, j)) + uri.substring(j);
            if (response instanceof HttpServletResponse) {
                uri = ((HttpServletResponse)response).encodeURL(uri);
            }
            return uri;
        }

        public String encodeRedirectURL(HttpServletRequest request, HttpServletResponse response, String uri, Map params, int mode) {
            return Https.encodeRedirectURL(ClassWebResource.this._ctx, request, response, ClassWebResource.this._mappingURI + ClassWebResource.PATH_PREFIX + uri, params, mode);
        }

        public RequestDispatcher getRequestDispatcher(String uri) {
            if (log.debugable()) {
                log.debug("getRequestDispatcher: " + uri);
            }
            return ClassWebResource.this._ctx.getRequestDispatcher(ClassWebResource.this._mappingURI + ClassWebResource.PATH_PREFIX + uri);
        }

        public URL getResource(String uri) {
            return ClassWebResource.getResource(uri);
        }

        public InputStream getResourceAsStream(String uri) {
            return ClassWebResource.getResourceAsStream(uri);
        }
    }

    private static class DSPLoader
    implements Loader {
        private final ClassWebContext _cwc;

        private DSPLoader(ClassWebContext cwc) {
            this._cwc = cwc;
        }

        public boolean shallCheck(Object src, long expiredMillis) {
            return expiredMillis > 0L;
        }

        public long getLastModified(Object src) {
            return 1L;
        }

        public Object load(Object src) throws Exception {
            String path;
            InputStream is;
            if (log.debugable()) {
                log.debug("Parse " + src);
            }
            if ((is = ClassWebResource.getResourceAsStream(path = (String)src)) == null) {
                return null;
            }
            try {
                return this.parse0(is, Interpreter.getContentType(path));
            }
            catch (Exception ex) {
                if (log.debugable()) {
                    log.realCauseBriefly("Failed to parse " + path, (Throwable)ex);
                } else {
                    log.error("Failed to parse " + path + "\nCause: " + ex.getClass().getName() + " " + Exceptions.getMessage((Throwable)ex) + "\n" + Exceptions.getBriefStackTrace((Throwable)ex));
                }
                return null;
            }
        }

        private Object parse0(InputStream is, String ctype) throws Exception {
            if (is == null) {
                return null;
            }
            String content = Files.readAll((Reader)new InputStreamReader(is, "UTF-8")).toString();
            return new Interpreter().parse(content, ctype, null, this._cwc.getLocator());
        }
    }
}

