/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.dsp.impl;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.jsp.el.FunctionMapper;
import org.zkoss.el.SimpleMapper;
import org.zkoss.idom.Element;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.idom.util.IDOMs;
import org.zkoss.lang.Classes;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.Locator;
import org.zkoss.web.mesg.MWeb;
import org.zkoss.web.servlet.ServletException;
import org.zkoss.web.servlet.dsp.Interpretation;
import org.zkoss.web.servlet.dsp.action.Page;
import org.zkoss.web.servlet.dsp.impl.ActionNode;
import org.zkoss.web.servlet.dsp.impl.ELNode;
import org.zkoss.web.servlet.dsp.impl.Node;
import org.zkoss.web.servlet.dsp.impl.RootNode;
import org.zkoss.web.servlet.dsp.impl.TextNode;

public class Parser {
    private static final Log log = Log.lookup((Class)Parser.class);
    static /* synthetic */ Class class$org$zkoss$web$servlet$dsp$action$Action;

    public Interpretation parse(String content, String ctype, FunctionMapper fm, Locator loc) throws javax.servlet.ServletException, IOException {
        Context ctx = new Context(content, fm, loc);
        RootNode root = new RootNode((FunctionMapper)ctx.mapper);
        Parser.parse0(ctx, root, 0, content.length());
        if (!ctx.pageDefined) {
            if (log.debugable()) {
                log.debug("Use default content type: " + ctype);
            }
            ActionNode action = new ActionNode(Page.class, 0);
            root.addChild(0, action);
            HashMap<String, String> attrs = new HashMap<String, String>(2);
            attrs.put("contentType", ctype != null ? ctype : "text/html");
            Parser.applyAttrs("page", action, attrs);
        }
        return root;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void parse0(Context ctx, Node parent, int from, int to) throws javax.servlet.ServletException, IOException {
        boolean esc = false;
        StringBuffer sb = new StringBuffer(512);
        int j = from;
        while (true) {
            block13: {
                if (j >= to) {
                    Parser.addText(parent, sb);
                    return;
                }
                char cc = ctx.content.charAt(j);
                switch (cc) {
                    case '<': {
                        if (j + 1 >= to) break;
                        char c2 = ctx.content.charAt(j + 1);
                        if (c2 == '\\') {
                            if (j + 2 >= to || ctx.content.charAt(j + 2) != '%') break;
                            ++j;
                            break;
                        }
                        if (c2 == '%') {
                            Parser.addText(parent, sb);
                            j = Parser.parseControl(ctx, parent, j, to);
                            break block13;
                        } else {
                            int oldLines = ctx.nLines;
                            int k = Parser.skipWhitespaces(ctx, j + 1, to);
                            int l = Parser.nextSeparator(ctx, k, to);
                            if (l >= to || l == k || ctx.content.charAt(l) != ':') {
                                ctx.nLines = oldLines;
                                break;
                            }
                            String prefix = ctx.content.substring(k, l);
                            if (!ctx.hasPrefix(prefix)) {
                                ctx.nLines = oldLines;
                                break;
                            }
                            Parser.addText(parent, sb);
                            j = Parser.parseAction(ctx, parent, prefix, l, to);
                        }
                        break block13;
                    }
                    case '$': {
                        if (j + 1 >= to) break;
                        char c2 = ctx.content.charAt(j + 1);
                        if (c2 == '\\') {
                            if (j + 2 >= to || ctx.content.charAt(j + 2) != '{') break;
                            ++j;
                            break;
                        }
                        if (c2 != '{') break;
                        Parser.addText(parent, sb);
                        j = Parser.parseEL(ctx, parent, j, to);
                        break block13;
                    }
                    case '\n': {
                        ++ctx.nLines;
                    }
                }
                sb.append(cc);
            }
            ++j;
        }
    }

    private static int parseControl(Context ctx, Node parent, int from, int to) throws javax.servlet.ServletException, IOException {
        ActionNode action;
        int j = from + 2;
        if (j + 1 >= to) {
            throw new ServletException(MWeb.DSP_ACTION_NOT_TERMINATED, new Object[]{null, new Integer(ctx.nLines)});
        }
        char cc = ctx.content.charAt(j);
        if (cc == '-' && ctx.content.charAt(j + 1) == '-') {
            int end = to - 4;
            while (true) {
                if (j > end) {
                    throw new ServletException(MWeb.DSP_COMMENT_NOT_TERMINATED, new Integer(ctx.nLines));
                }
                if (ctx.content.charAt(j) == '\n') {
                    ++ctx.nLines;
                } else if (Parser.startsWith(ctx.content, j, to, "--%>")) {
                    return j + 3;
                }
                ++j;
            }
        }
        if (cc != '@') {
            throw new ServletException(MWeb.DSP_EXPECT_CHARACTER, new Object[]{new Character('@'), new Integer(ctx.nLines)});
        }
        int k = Parser.nextSeparator(ctx, j = Parser.skipWhitespaces(ctx, j + 1, to), to);
        if (k >= to) {
            throw new ServletException(MWeb.DSP_ACTION_NOT_TERMINATED, new Object[]{null, new Integer(ctx.nLines)});
        }
        String ctlnm = ctx.content.substring(j, k);
        if ("taglib".equals(ctlnm)) {
            action = null;
        } else if ("page".equals(ctlnm)) {
            ctx.pageDefined = true;
            action = new ActionNode(Page.class, ctx.nLines);
            parent.addChild(action);
        } else {
            throw new ServletException(MWeb.DSP_UNKNOWN_ACTION, new Object[]{ctlnm, new Integer(ctx.nLines)});
        }
        HashMap attrs = new HashMap();
        k = Parser.parseAttrs(ctx, attrs, ctlnm, k, to);
        cc = ctx.content.charAt(k);
        if (cc != '%') {
            throw new ServletException(MWeb.DSP_EXPECT_CHARACTER, new Object[]{new Character('%'), new Integer(ctx.nLines)});
        }
        if (action == null) {
            String uri = (String)attrs.get("uri");
            String prefix = (String)attrs.get("prefix");
            if (prefix == null || uri == null) {
                throw new ServletException(MWeb.DSP_TAGLIB_ATTRIBUTE_REQUIRED, new Integer(ctx.nLines));
            }
            ctx.loadTaglib(prefix, uri);
        } else {
            Parser.applyAttrs(ctlnm, action, attrs);
        }
        if (++k >= to || ctx.content.charAt(k) != '>') {
            throw new ServletException(MWeb.DSP_ACTION_NOT_TERMINATED, new Object[]{ctlnm, new Integer(ctx.nLines)});
        }
        return k;
    }

    /*
     * Unable to fully structure code
     */
    private static int parseAction(Context ctx, Node parent, String prefix, int from, int to) throws javax.servlet.ServletException, IOException {
        j = Parser.skipWhitespaces(ctx, from + 1, to);
        k = Parser.nextSeparator(ctx, j, to);
        if (k >= to) {
            throw new ServletException(MWeb.DSP_ACTION_NOT_TERMINATED, new Object[]{prefix + ':', new Integer(Context.access$400(ctx))});
        }
        if (k == j) {
            throw new ServletException(MWeb.DSP_ACTION_REQUIRED, new Integer(Context.access$400(ctx)));
        }
        actnm = Context.access$300(ctx).substring(j, k);
        actcls = Context.access$700(ctx, prefix, actnm);
        if (actcls == null) {
            throw new ServletException(MWeb.DSP_UNKNOWN_ACTION, new Object[]{prefix + ':' + actnm, new Integer(Context.access$400(ctx))});
        }
        action = new ActionNode(actcls, Context.access$400(ctx));
        parent.addChild(action);
        if (Parser.log.debugable()) {
            Parser.log.debug("Action " + actnm);
        }
        attrs = new HashMap<K, V>();
        j = Parser.parseAttrs(ctx, attrs, actnm, k, to);
        cc = Context.access$300(ctx).charAt(j);
        v0 = ended = cc == '/';
        if (!ended && cc != '>') {
            throw new ServletException(MWeb.DSP_UNEXPECT_CHARACTER, new Object[]{new Character(cc), new Integer(Context.access$400(ctx))});
        }
        Parser.applyAttrs(actnm, action, attrs);
        if (ended) {
            if (j + 1 >= to || Context.access$300(ctx).charAt(j + 1) != '>') {
                throw new ServletException(MWeb.DSP_ACTION_NOT_TERMINATED, new Object[]{prefix + ':' + actnm, new Integer(action.getLineNumber())});
            }
            return j + 1;
        }
        nestedFrom = ++j;
        depth = 0;
        while (true) {
            if (j >= to) {
                throw new ServletException(MWeb.DSP_ACTION_NOT_TERMINATED, new Object[]{actnm, new Integer(action.getLineNumber())});
            }
            cc = Context.access$300(ctx).charAt(j);
            if (j + 1 >= to) ** GOTO lbl-1000
            if (cc == '<') {
                oldLines = Context.access$400(ctx);
                k = j + 1;
                ended = Context.access$300(ctx).charAt(k) == '/';
                k = Parser.skipWhitespaces(ctx, ended != false ? k + 1 : k, to);
                l = Parser.nextSeparator(ctx, k, to);
                if (l >= to || Context.access$300(ctx).charAt(l) != ':' || !prefix.equals(Context.access$300(ctx).substring(k, l))) {
                    Context.access$402(ctx, oldLines);
                } else {
                    k = Parser.skipWhitespaces(ctx, l + 1, to);
                    if ((l = Parser.nextSeparator(ctx, k, to)) >= to || !actnm.equals(Context.access$300(ctx).substring(k, l))) {
                        Context.access$402(ctx, oldLines);
                    } else if ((l = Parser.skipWhitespaces(ctx, l, to)) >= to || ended && Context.access$300(ctx).charAt(l) != '>') {
                        Context.access$402(ctx, oldLines);
                    } else {
                        if (ended) {
                            if (--depth < 0) {
                                break;
                            }
                        } else {
                            ++depth;
                        }
                        j = l;
                    }
                }
            } else if (cc == '$' && Context.access$300(ctx).charAt(j + 1) == '{') {
                j = Parser.endOfEL(ctx, j, to);
            } else if (cc == '\n') {
                Context.access$404(ctx);
            }
            ++j;
        }
        nestedTo = j;
        j = l;
        Parser.parse0(ctx, action, nestedFrom, nestedTo);
        return j;
    }

    private static boolean startsWith(String content, int from, int to, String s) {
        int j = 0;
        int len = s.length();
        while (j < len) {
            if (from >= to || content.charAt(from) != s.charAt(j)) {
                return false;
            }
            ++from;
            ++j;
        }
        return true;
    }

    private static int skipWhitespaces(Context ctx, int from, int to) {
        while (from < to) {
            char cc = ctx.content.charAt(from);
            if (cc == '\n') {
                ++ctx.nLines;
            } else if (!Character.isWhitespace(cc)) break;
            ++from;
        }
        return from;
    }

    private static int nextSeparator(Context ctx, int from, int to) {
        char cc;
        while (from < to && ((cc = ctx.content.charAt(from)) >= '0' && cc <= '9' || cc >= 'a' && cc <= 'z' || cc >= 'A' && cc <= 'Z' || cc == '_')) {
            ++from;
        }
        return from;
    }

    private static int parseAttrs(Context ctx, Map attrs, String actnm, int from, int to) throws javax.servlet.ServletException {
        int k = from;
        while (true) {
            int j;
            if ((k = Parser.nextSeparator(ctx, j = Parser.skipWhitespaces(ctx, k, to), to)) >= to) {
                throw new ServletException(MWeb.DSP_ACTION_NOT_TERMINATED, new Object[]{actnm, new Integer(ctx.nLines)});
            }
            if (j == k) {
                return j;
            }
            String attrnm = ctx.content.substring(j, k);
            j = Parser.skipWhitespaces(ctx, (k = Parser.skipWhitespaces(ctx, k, to)) + 1, to);
            if (j >= to || ctx.content.charAt(k) != '=') {
                throw new ServletException(MWeb.DSP_ATTRIBUTE_VALUE_REQUIRED, new Object[]{actnm, attrnm, new Integer(ctx.nLines)});
            }
            char quot = ctx.content.charAt(j);
            if (quot != '\"' && quot != '\'') {
                throw new ServletException(MWeb.DSP_ATTRIBUTE_VALUE_QUOTE_REQUIRED, new Object[]{actnm, attrnm, new Integer(ctx.nLines)});
            }
            StringBuffer sbval = new StringBuffer();
            k = ++j;
            while (true) {
                if (k >= to) {
                    throw new ServletException(MWeb.DSP_ATTRIBUTE_VALUE_QUOTE_REQUIRED, new Object[]{actnm, attrnm, new Integer(ctx.nLines)});
                }
                char cc = ctx.content.charAt(k);
                if (cc == '\n') {
                    throw new ServletException(MWeb.DSP_ATTRIBUTE_VALUE_QUOTE_REQUIRED, new Object[]{actnm, attrnm, new Integer(ctx.nLines)});
                }
                if (cc == quot) {
                    ++k;
                    break;
                }
                sbval.append(cc);
                if (cc == '\\' && ++k < to) {
                    sbval.setCharAt(sbval.length() - 1, ctx.content.charAt(k));
                }
                ++k;
            }
            attrs.put(attrnm, sbval.toString());
        }
    }

    private static final void applyAttrs(String actnm, ActionNode action, Map attrs) throws javax.servlet.ServletException {
        Iterator it = attrs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            String attrnm = (String)me.getKey();
            String attrval = (String)me.getValue();
            try {
                action.addAttribute(attrnm, attrval);
            }
            catch (NoSuchMethodException ex) {
                throw new ServletException(MWeb.DSP_ATTRIBUTE_NOT_FOUND, new Object[]{actnm, attrnm, new Integer(action.getLineNumber())});
            }
            catch (ClassCastException ex) {
                throw new ServletException(MWeb.DSP_ATTRIBUTE_INVALID_VALUE, new Object[]{actnm, attrnm, attrval, new Integer(action.getLineNumber())}, (Throwable)ex);
            }
        }
    }

    private static int parseEL(Context ctx, Node parent, int from, int to) throws javax.servlet.ServletException {
        int j = Parser.endOfEL(ctx, from, to);
        parent.addChild(new ELNode(ctx.content.substring(from, j + 1)));
        return j;
    }

    private static int endOfEL(Context ctx, int from, int to) throws javax.servlet.ServletException {
        int j = from + 2;
        while (true) {
            if (j >= to) {
                throw new ServletException(MWeb.EL_NOT_TERMINATED, new Integer(ctx.nLines));
            }
            char cc = ctx.content.charAt(j);
            if (cc == '}') {
                return j;
            }
            if (cc == '\'' || cc == '\"') {
                char c2;
                while (++j < to && (c2 = ctx.content.charAt(j)) != cc) {
                    if (cc == '\n') {
                        throw new ServletException("Illegal EL expression: non-terminaled " + cc + " at line " + ctx.nLines + " character " + j);
                    }
                    if (c2 != '\\' || ++j >= to || ctx.content.charAt(j) != '\n') continue;
                    ++ctx.nLines;
                }
            } else if (cc == '\n') {
                ++ctx.nLines;
            }
            ++j;
        }
    }

    private static void addText(Node parent, StringBuffer sb) {
        if (sb.length() > 0) {
            parent.addChild(new TextNode(sb.toString()));
            sb.setLength(0);
        }
    }

    private static class Context {
        private final String content;
        private final SimpleMapper mapper;
        private final Map _actions = new HashMap();
        private final Locator locator;
        private int nLines;
        private boolean pageDefined;

        private Context(String content, FunctionMapper fm, Locator loc) {
            this.content = content;
            this.mapper = new SimpleMapper(fm);
            this.locator = loc;
            this.nLines = 1;
        }

        private boolean hasPrefix(String prefix) {
            return this._actions.containsKey(prefix);
        }

        private Class getActionClass(String prefix, String actnm) {
            Map acts = (Map)this._actions.get(prefix);
            return acts != null ? (Class)acts.get(actnm) : null;
        }

        private void loadTaglib(String prefix, String uri) throws javax.servlet.ServletException, IOException {
            if (log.debugable()) {
                log.debug("Loading " + prefix + " at " + uri);
            }
            if (this.locator == null) {
                throw new ServletException("Unable to load " + uri + " because locator is not specified");
            }
            URL url = this.locator.getResource(uri);
            if (url == null) {
                throw new FileNotFoundException(uri);
            }
            try {
                this.loadTaglib0(prefix, url);
            }
            catch (IOException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw ServletException.Aide.wrap(ex);
            }
        }

        private void loadTaglib0(String prefix, URL url) throws Exception {
            Element root = new SAXBuilder(true, false, true).build(url).getRootElement();
            this.mapper.load(prefix, root);
            HashMap<String, Class> acts = new HashMap<String, Class>();
            Iterator it = root.getElements("tag").iterator();
            while (it.hasNext()) {
                String clsName;
                Class cls;
                Element e = (Element)it.next();
                String name = IDOMs.getRequiredElementValue((Element)e, (String)"name");
                if (!(class$org$zkoss$web$servlet$dsp$action$Action == null ? Parser.class$("org.zkoss.web.servlet.dsp.action.Action") : class$org$zkoss$web$servlet$dsp$action$Action).isAssignableFrom(cls = Classes.forNameByThread((String)(clsName = IDOMs.getRequiredElementValue((Element)e, (String)"tag-class"))))) {
                    throw new ServletException(cls + " doesn't implement " + (class$org$zkoss$web$servlet$dsp$action$Action == null ? (class$org$zkoss$web$servlet$dsp$action$Action = Parser.class$("org.zkoss.web.servlet.dsp.action.Action")) : class$org$zkoss$web$servlet$dsp$action$Action));
                }
                acts.put(name, cls);
            }
            if (!acts.isEmpty()) {
                this._actions.put(prefix, acts);
            }
        }

        static /* synthetic */ Class access$700(Context x0, String x1, String x2) {
            return x0.getActionClass(x1, x2);
        }
    }
}

