/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.SystemException;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.util.resource.ExtendletContext;
import org.zkoss.web.util.resource.ResourceCache;
import org.zkoss.web.util.resource.ResourceInfo;

public class ResourceCaches {
    private static final Logger log = LoggerFactory.getLogger(ResourceCaches.class);

    public static final <V> V get(ResourceCache<V> cache, ServletContext ctx, String path, Object extra) {
        URL url = null;
        if (path == null || ((String)path).length() == 0) {
            path = "/";
        } else if (((String)path).charAt(0) != '/') {
            if (((String)path).indexOf("://") > 0) {
                try {
                    url = new URL((String)path);
                }
                catch (MalformedURLException ex) {
                    throw new SystemException((Throwable)ex);
                }
            } else {
                path = "/" + (String)path;
            }
        }
        if (url == null) {
            String flnm;
            if (((String)path).startsWith("/~")) {
                String ctxpath;
                ServletContext ctx0 = ctx;
                String path0 = path;
                int j = ((String)path).indexOf(47, 2);
                if (j >= 0) {
                    ctxpath = "/" + ((String)path).substring(2, j);
                    path = ((String)path).substring(j);
                } else {
                    ctxpath = "/" + ((String)path).substring(2);
                    path = "/";
                }
                ExtendletContext extctx = Servlets.getExtendletContext(ctx, ctxpath.substring(1));
                if (extctx != null) {
                    url = extctx.getResource((String)path);
                    if (url == null) {
                        return null;
                    }
                    try {
                        return (V)cache.get(new ResourceInfo((String)path, url, extra));
                    }
                    catch (Throwable ex) {
                        IOException ioex = ResourceCaches.getIOException(ex);
                        if (ioex == null) {
                            throw SystemException.Aide.wrap((Throwable)ex);
                        }
                        log.warn("Unable to load " + String.valueOf(url), (Throwable)ioex);
                        return null;
                    }
                }
                if ((ctx = ctx.getContext(ctxpath)) == null) {
                    ctx = ctx0;
                    path = path0;
                }
            }
            if ((flnm = ctx.getRealPath((String)path)) != null) {
                try {
                    return (V)cache.get(new ResourceInfo((String)path, new File(flnm), extra));
                }
                catch (Throwable ex) {
                    IOException ioex = ResourceCaches.getIOException(ex);
                    if (ioex == null) {
                        throw SystemException.Aide.wrap((Throwable)ex);
                    }
                    log.warn("Unable to load " + flnm, (Throwable)ioex);
                    return null;
                }
            }
        }
        try {
            if (url == null) {
                url = ctx.getResource((String)path);
            }
            if (url != null) {
                return (V)cache.get(new ResourceInfo((String)path, url, extra));
            }
        }
        catch (Throwable ex) {
            IOException ioex = ResourceCaches.getIOException(ex);
            if (ioex == null) {
                throw SystemException.Aide.wrap((Throwable)ex);
            }
            log.warn("Unable to load " + (String)path, (Throwable)ioex);
        }
        return null;
    }

    private static IOException getIOException(Throwable ex) {
        while (ex != null) {
            if (ex instanceof IOException) {
                return (IOException)ex;
            }
            ex = ex.getCause();
        }
        return null;
    }
}

