/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.util.resource;

import jakarta.servlet.ServletContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import org.zkoss.lang.SystemException;
import org.zkoss.util.resource.Locator;
import org.zkoss.web.servlet.Servlets;

public class ServletContextLocator
implements Locator {
    private final ServletContext _ctx;
    private final String _dir;
    private final String _prefix;
    private final boolean _acceptURL;
    private final String _externalPrefix;

    public ServletContextLocator(ServletContext ctx) {
        this(ctx, null, null, false, null);
    }

    public ServletContextLocator(ServletContext ctx, boolean acceptURL) {
        this(ctx, null, null, acceptURL, null);
    }

    public ServletContextLocator(ServletContext ctx, String dir) {
        this(ctx, dir, null, false, null);
    }

    public ServletContextLocator(ServletContext ctx, String dir, String prefix) {
        this(ctx, dir, prefix, false, null);
    }

    public ServletContextLocator(ServletContext ctx, String dir, String prefix, boolean acceptURL) {
        this(ctx, dir, prefix, acceptURL, null);
    }

    public ServletContextLocator(ServletContext ctx, String dir, String prefix, boolean acceptURL, String externalPrefix) {
        int len;
        if (ctx == null) {
            throw new IllegalArgumentException("null");
        }
        if (dir != null) {
            len = ((String)dir).length();
            if (len == 0) {
                dir = null;
            } else {
                if (((String)dir).charAt(0) != '/') {
                    throw new IllegalArgumentException("Absolute path required: " + (String)dir);
                }
                if (((String)dir).charAt(len - 1) != '/') {
                    dir = (String)dir + "/";
                }
            }
        }
        if (prefix != null) {
            len = prefix.length();
            if (len == 0) {
                prefix = null;
            } else {
                if (prefix.charAt(0) != '/') {
                    throw new IllegalArgumentException("Absolute path required: " + prefix);
                }
                if (len == 1) {
                    prefix = null;
                } else if (prefix.charAt(len - 1) == '/') {
                    prefix = prefix.substring(0, len - 1);
                }
            }
        }
        this._ctx = ctx;
        this._dir = dir;
        this._prefix = prefix;
        this._acceptURL = acceptURL;
        this._externalPrefix = externalPrefix;
    }

    public ServletContext getServletContext() {
        return this._ctx;
    }

    private String fixName(String name, boolean prefix) {
        Object object = name.length() > 0 && name.charAt(0) != '/' ? (this._dir != null ? this._dir + name : (prefix && this._prefix != null ? "/" + name : name)) : (name = name);
        return prefix && this._prefix != null ? this._prefix + name : (this._externalPrefix == null ? "" : this._externalPrefix) + name;
    }

    public String getDirectory() {
        return this._dir;
    }

    public URL getResource(String name) {
        String relativePath = null;
        try {
            URL uRL;
            relativePath = this.fixName(name, true);
            URL url = this.getResource0(relativePath);
            if (url == null && this._prefix != null) {
                relativePath = this.fixName(name, false);
                uRL = this.getResource0(relativePath);
            } else {
                uRL = url;
            }
            return uRL;
        }
        catch (MalformedURLException ex) {
            if (relativePath != null && !relativePath.startsWith("-")) {
                return null;
            }
            throw new SystemException((Throwable)ex);
        }
        catch (UnsupportedEncodingException e) {
            throw new SystemException((Throwable)e);
        }
    }

    public InputStream getResourceAsStream(String name) {
        try {
            InputStream is = this.getResourceAsStream0(this.fixName(name, true));
            return is == null && this._prefix != null ? this.getResourceAsStream0(this.fixName(name, false)) : is;
        }
        catch (IOException ex) {
            throw new SystemException((Throwable)ex);
        }
    }

    private URL getResource0(String path) throws MalformedURLException, UnsupportedEncodingException {
        return this._acceptURL ? Servlets.getResource(this._ctx, path) : this._ctx.getResource(path);
    }

    private InputStream getResourceAsStream0(String path) throws IOException {
        return this._acceptURL ? Servlets.getResourceAsStream(this._ctx, path) : this._ctx.getResourceAsStream(path);
    }

    public int hashCode() {
        return this._ctx.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        return o instanceof ServletContextLocator && ((ServletContextLocator)o)._ctx.equals(this._ctx);
    }
}

