/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet.dsp;

import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.html.HTMLs;
import org.zkoss.io.Files;
import org.zkoss.lang.Exceptions;
import org.zkoss.util.resource.Locator;
import org.zkoss.web.servlet.Charsets;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.servlet.dsp.DspContext;
import org.zkoss.web.servlet.dsp.Interpretation;
import org.zkoss.web.servlet.dsp.Interpreter;
import org.zkoss.web.servlet.dsp.ServletDspContext;
import org.zkoss.web.servlet.http.Https;
import org.zkoss.web.util.resource.ClassWebResource;
import org.zkoss.web.util.resource.ResourceCache;
import org.zkoss.web.util.resource.ResourceCaches;
import org.zkoss.web.util.resource.ResourceLoader;
import org.zkoss.xel.taglib.Taglibs;
import org.zkoss.xml.XMLs;

public class InterpreterServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(InterpreterServlet.class);
    private String _charset = "UTF-8";
    private Locator _locator;
    private boolean _compress = true;
    private static final String ATTR_PAGE_CACHE = "org.zkoss.web.servlet.dsp.PageCache";

    public void init() throws ServletException {
        final ServletContext ctx = this.getServletContext();
        ServletConfig config = this.getServletConfig();
        String param = config.getInitParameter("compress");
        if (param != null) {
            this._compress = "true".equals(param);
        }
        param = config.getInitParameter("class-resource");
        final boolean bClsRes = "true".equals(param);
        this._locator = new Locator(){

            public String getDirectory() {
                return null;
            }

            public URL getResource(String name) {
                URL url = null;
                if (name.indexOf("://") < 0) {
                    try {
                        url = ctx.getResource(name);
                        if (bClsRes && url == null) {
                            url = ClassWebResource.getClassResource((String)name);
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
                return url != null ? url : Taglibs.getDefaultURL((String)name);
            }

            public InputStream getResourceAsStream(String name) {
                InputStream is = ctx.getResourceAsStream(name);
                return !bClsRes || is != null ? is : ClassWebResource.getClassResourceAsStream((String)name);
            }
        };
        param = config.getInitParameter("charset");
        if (param != null) {
            this._charset = param.length() > 0 ? param : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        Servlets.getBrowser((ServletRequest)request);
        String path = Https.getThisServletPath((ServletRequest)request);
        if (log.isDebugEnabled()) {
            log.debug("Get " + path);
        }
        Object old = Charsets.setup((ServletRequest)request, (ServletResponse)response, (String)this._charset);
        ServletContext ctx = this.getServletContext();
        try {
            Interpretation cnt = (Interpretation)ResourceCaches.get(this.getCache(), (ServletContext)ctx, (String)path, null);
            if (cnt == null) {
                if (Https.isIncluded((ServletRequest)request)) {
                    log.error("Not found: " + path);
                }
                response.sendError(404, HTMLs.encodeJavaScript((String)XMLs.escapeXML((String)path)));
                return;
            }
            boolean compress = this._compress && !Servlets.isIncluded((ServletRequest)request);
            StringWriter out = compress ? new StringWriter() : null;
            cnt.interpret((DspContext)new ServletDspContext(ctx, request, response, (Writer)out, null));
            if (compress) {
                String result = out.toString();
                try {
                    byte[] bs;
                    ServletOutputStream os = response.getOutputStream();
                    byte[] data = result.getBytes("UTF-8");
                    if (data.length > 200 && (bs = Https.gzip((HttpServletRequest)request, (HttpServletResponse)response, null, (byte[])data)) != null) {
                        data = bs;
                    }
                    response.setContentLength(data.length);
                    os.write(data);
                    response.flushBuffer();
                }
                catch (IllegalStateException ex) {
                    response.getWriter().write(result);
                }
            }
        }
        finally {
            Charsets.cleanup((ServletRequest)request, (Object)old);
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final ResourceCache<Interpretation> getCache() {
        ServletContext ctx = this.getServletContext();
        ResourceCache cache = (ResourceCache)ctx.getAttribute(ATTR_PAGE_CACHE);
        if (cache != null) return cache;
        Class<InterpreterServlet> clazz = InterpreterServlet.class;
        synchronized (InterpreterServlet.class) {
            cache = (ResourceCache)ctx.getAttribute(ATTR_PAGE_CACHE);
            if (cache != null) return cache;
            cache = new ResourceCache((ResourceLoader)new MyLoader(), 29);
            cache.setMaxSize(1024);
            cache.setLifetime(3600000);
            ctx.setAttribute(ATTR_PAGE_CACHE, (Object)cache);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return cache;
        }
    }

    private class MyLoader
    extends ResourceLoader<Interpretation> {
        private MyLoader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Interpretation parse(String path, File file, Object extra) throws Exception {
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            try {
                Interpretation interpretation = this.parse0(is, Interpreter.getContentType((String)file.getName()));
                return interpretation;
            }
            catch (Exception ex) {
                if (log.isDebugEnabled()) {
                    log.error("Failed to parse " + file, (Throwable)ex);
                } else {
                    log.error("Failed to parse " + file + "\nCause: " + Exceptions.getMessage((Throwable)ex) + "\n" + Exceptions.getBriefStackTrace((Throwable)ex));
                }
                Interpretation interpretation = null;
                return interpretation;
            }
            finally {
                Files.close((InputStream)is);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Interpretation parse(String path, URL url, Object extra) throws Exception {
            InputStream is = (url = new URL(url.getProtocol(), url.getHost(), url.getPort(), url.getFile())).openStream();
            if (is != null) {
                is = new BufferedInputStream(is);
            }
            try {
                Interpretation interpretation = this.parse0(is, Interpreter.getContentType((String)url.getPath()));
                return interpretation;
            }
            catch (Exception ex) {
                if (log.isDebugEnabled()) {
                    log.error("Failed to parse " + url, (Throwable)ex);
                } else {
                    log.error("Failed to parse " + url + "\nCause: " + Exceptions.getMessage((Throwable)ex));
                }
                Interpretation interpretation = null;
                return interpretation;
            }
            finally {
                Files.close((InputStream)is);
            }
        }

        private Interpretation parse0(InputStream is, String ctype) throws Exception {
            if (is == null) {
                return null;
            }
            String content = Files.readAll((Reader)new InputStreamReader(is, "UTF-8")).toString();
            return new Interpreter().parse(content, ctype, null, InterpreterServlet.this._locator);
        }
    }
}

