/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zel;

import java.beans.BeanInfo;
import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ClassIntrospector {
    private static final boolean HAS_DEFAULT_SUPPORT = ClassIntrospector.hasDefaultSupport();

    ClassIntrospector() {
    }

    private static boolean hasDefaultSupport() {
        try {
            Method.class.getDeclaredMethod("isDefault", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    public PropertyDescriptor[] getPropertyDescriptors(BeanInfo beanInfo, Class<?> clazz) throws IntrospectionException {
        List<Object> introspectorPDs;
        PropertyDescriptor[] introspectorPDsArray = beanInfo.getPropertyDescriptors();
        List<Object> list = introspectorPDs = introspectorPDsArray != null ? Arrays.asList(introspectorPDsArray) : Collections.emptyList();
        if (!HAS_DEFAULT_SUPPORT) {
            return introspectorPDsArray;
        }
        LinkedHashMap<String, Object> mergedPRMPs = null;
        for (Method method : clazz.getMethods()) {
            String propName;
            Class<?>[] paramTypes;
            if (!ClassIntrospector.isDefaultMethod(method) || method.getReturnType() == Void.TYPE || method.isBridge() || (paramTypes = method.getParameterTypes()).length != 0 && (paramTypes.length != 1 || paramTypes[0] != Integer.TYPE) || (propName = ClassIntrospector.getBeanPropertyNameFromReaderMethodName(method.getName(), method.getReturnType())) == null) continue;
            if (mergedPRMPs == null) {
                mergedPRMPs = new LinkedHashMap<String, Object>();
            }
            if (paramTypes.length == 0) {
                this.mergeInPropertyReaderMethod(mergedPRMPs, propName, method);
                continue;
            }
            this.mergeInPropertyReaderMethodPair(mergedPRMPs, propName, new PropertyReaderMethodPair(null, method));
        }
        if (mergedPRMPs == null) {
            return introspectorPDsArray;
        }
        for (PropertyDescriptor propertyDescriptor : introspectorPDs) {
            this.mergeInPropertyDescriptor(mergedPRMPs, propertyDescriptor);
        }
        ArrayList<PropertyDescriptor> mergedPDs = new ArrayList<PropertyDescriptor>(mergedPRMPs.size());
        for (Map.Entry entry : mergedPRMPs.entrySet()) {
            Method indexedReadMethod;
            Method readMethod;
            String propName = (String)entry.getKey();
            Object propDescObj = entry.getValue();
            if (propDescObj instanceof PropertyDescriptor) {
                mergedPDs.add((PropertyDescriptor)propDescObj);
                continue;
            }
            if (propDescObj instanceof Method) {
                readMethod = (Method)propDescObj;
                indexedReadMethod = null;
            } else if (propDescObj instanceof PropertyReaderMethodPair) {
                PropertyReaderMethodPair prmp = (PropertyReaderMethodPair)propDescObj;
                readMethod = prmp.readMethod;
                indexedReadMethod = prmp.indexedReadMethod;
                if (readMethod != null && indexedReadMethod != null && indexedReadMethod.getReturnType() != readMethod.getReturnType().getComponentType()) {
                    indexedReadMethod = null;
                }
            } else {
                throw new IntrospectionException("Internal bug: propDescObj type unexpected");
            }
            mergedPDs.add(indexedReadMethod != null ? new IndexedPropertyDescriptor(propName, readMethod, null, indexedReadMethod, null) : new PropertyDescriptor(propName, readMethod, null));
        }
        return mergedPDs.toArray(new PropertyDescriptor[0]);
    }

    private static boolean isDefaultMethod(Method method) {
        return (method.getModifiers() & 0x409) == 1 && method.getDeclaringClass().isInterface();
    }

    private void mergeInPropertyDescriptor(LinkedHashMap<String, Object> mergedPRMPs, PropertyDescriptor pd) {
        String propName = pd.getName();
        Object replaced = mergedPRMPs.put(propName, pd);
        if (replaced != null) {
            PropertyReaderMethodPair newPRMP = new PropertyReaderMethodPair(pd);
            this.putIfMergedPropertyReaderMethodPairDiffers(mergedPRMPs, propName, replaced, newPRMP);
        }
    }

    private void mergeInPropertyReaderMethod(LinkedHashMap<String, Object> mergedPRMPs, String propName, Method readerMethod) {
        Object replaced = mergedPRMPs.put(propName, readerMethod);
        if (replaced != null) {
            this.putIfMergedPropertyReaderMethodPairDiffers(mergedPRMPs, propName, replaced, new PropertyReaderMethodPair(readerMethod, null));
        }
    }

    private void mergeInPropertyReaderMethodPair(LinkedHashMap<String, Object> mergedPRMPs, String propName, PropertyReaderMethodPair newPRM) {
        Object replaced = mergedPRMPs.put(propName, newPRM);
        if (replaced != null) {
            this.putIfMergedPropertyReaderMethodPairDiffers(mergedPRMPs, propName, replaced, newPRM);
        }
    }

    private void putIfMergedPropertyReaderMethodPairDiffers(LinkedHashMap<String, Object> mergedPRMPs, String propName, Object replaced, PropertyReaderMethodPair newPRMP) {
        PropertyReaderMethodPair replacedPRMP = PropertyReaderMethodPair.from(replaced);
        PropertyReaderMethodPair mergedPRMP = PropertyReaderMethodPair.merge(replacedPRMP, newPRMP);
        if (!mergedPRMP.equals(newPRMP)) {
            mergedPRMPs.put(propName, mergedPRMP);
        }
    }

    private static String getBeanPropertyNameFromReaderMethodName(String name, Class<?> returnType) {
        int start;
        if (name.startsWith("get")) {
            start = 3;
        } else if (returnType == Boolean.TYPE && name.startsWith("is")) {
            start = 2;
        } else {
            return null;
        }
        int ln = name.length();
        if (start == ln) {
            return null;
        }
        char c1 = name.charAt(start);
        return start + 1 < ln && Character.isUpperCase(name.charAt(start + 1)) && Character.isUpperCase(c1) ? name.substring(start) : new StringBuilder(ln - start).append(Character.toLowerCase(c1)).append(name, start + 1, ln).toString();
    }

    private static class PropertyReaderMethodPair {
        private final Method readMethod;
        private final Method indexedReadMethod;

        PropertyReaderMethodPair(Method readerMethod, Method indexedReaderMethod) {
            this.readMethod = readerMethod;
            this.indexedReadMethod = indexedReaderMethod;
        }

        PropertyReaderMethodPair(PropertyDescriptor pd) {
            this(pd.getReadMethod(), pd instanceof IndexedPropertyDescriptor ? ((IndexedPropertyDescriptor)pd).getIndexedReadMethod() : null);
        }

        static PropertyReaderMethodPair from(Object obj) {
            if (obj instanceof PropertyReaderMethodPair) {
                return (PropertyReaderMethodPair)obj;
            }
            if (obj instanceof PropertyDescriptor) {
                return new PropertyReaderMethodPair((PropertyDescriptor)obj);
            }
            if (obj instanceof Method) {
                return new PropertyReaderMethodPair((Method)obj, null);
            }
            throw new IllegalArgumentException("Unexpected obj type: " + obj.getClass().getName());
        }

        static PropertyReaderMethodPair merge(PropertyReaderMethodPair oldMethods, PropertyReaderMethodPair newMethods) {
            return new PropertyReaderMethodPair(newMethods.readMethod != null ? newMethods.readMethod : oldMethods.readMethod, newMethods.indexedReadMethod != null ? newMethods.indexedReadMethod : oldMethods.indexedReadMethod);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.indexedReadMethod == null ? 0 : this.indexedReadMethod.hashCode());
            result = 31 * result + (this.readMethod == null ? 0 : this.readMethod.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PropertyReaderMethodPair other = (PropertyReaderMethodPair)obj;
            return other.readMethod == this.readMethod && other.indexedReadMethod == this.indexedReadMethod;
        }
    }
}

