/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zel;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.zkoss.zel.ELException;
import org.zkoss.zel.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImportHandler {
    private List<String> packages = new ArrayList<String>();
    private Map<String, Class<?>> clazzes = new HashMap();
    private Map<String, Class<?>> statics = new HashMap();

    private ImportHandler() {
        this.importPackage("java.lang");
    }

    public static ImportHandler getImportHandler() {
        return SingletonHolder.INSTANCE;
    }

    public void importStatic(String name) throws ELException {
        int modifiers;
        int lastPeriod = name.lastIndexOf(46);
        if (lastPeriod < 0) {
            throw new ELException(Util.message(null, "importHandler.invalidStaticName", name));
        }
        String className = name.substring(0, lastPeriod);
        String fieldOrMethodName = name.substring(lastPeriod + 1);
        Class<?> clazz = this.findClass(className);
        if (clazz == null) {
            throw new ELException(Util.message(null, "importHandler.invalidClassNameForStatic", className, name));
        }
        boolean found = false;
        for (Field field : clazz.getFields()) {
            if (!field.getName().equals(fieldOrMethodName) || !Modifier.isStatic(modifiers = field.getModifiers()) || !Modifier.isPublic(modifiers)) continue;
            found = true;
            break;
        }
        if (!found) {
            for (AccessibleObject accessibleObject : clazz.getMethods()) {
                if (!((Method)accessibleObject).getName().equals(fieldOrMethodName) || !Modifier.isStatic(modifiers = ((Method)accessibleObject).getModifiers()) || !Modifier.isPublic(modifiers)) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            throw new ELException(Util.message(null, "importHandler.staticNotFound", fieldOrMethodName, className, name));
        }
        Class<?> conflict = this.statics.get(fieldOrMethodName);
        if (conflict != null) {
            throw new ELException(Util.message(null, "importHandler.ambiguousStaticImport", name, conflict.getName() + '.' + fieldOrMethodName));
        }
        this.statics.put(fieldOrMethodName, clazz);
    }

    public void importClass(String name) throws ELException {
        if (!name.contains(".")) {
            throw new ELException(Util.message(null, "importHandler.invalidClassName", name));
        }
        Class<?> clazz = this.findClass(name);
        if (clazz == null) {
            throw new ELException(Util.message(null, "importHandler.classNotFound", name));
        }
        String simpleName = clazz.getSimpleName();
        Class<?> conflict = this.clazzes.get(simpleName);
        if (conflict == null) {
            this.clazzes.put(simpleName, clazz);
        } else if (!conflict.equals(clazz)) {
            throw new ELException(Util.message(null, "importHandler.ambiguousImport", name, conflict.getName()));
        }
    }

    public void importPackage(String name) {
        String path;
        ClassLoader cl;
        URL url;
        Package p = Package.getPackage(name);
        if (p == null && (url = (cl = Thread.currentThread().getContextClassLoader()).getResource(path = name.replace('.', '/'))) == null) {
            throw new ELException(Util.message(null, "importHandler.invalidPackage", name));
        }
        this.packages.add(name);
    }

    public Class<?> resolveClass(String name) {
        if (name == null || name.contains(".")) {
            return null;
        }
        Class<?> result = this.clazzes.get(name);
        if (result == null) {
            for (String p : this.packages) {
                String className = p + '.' + name;
                Class<?> clazz = this.findClass(className);
                if (clazz == null) continue;
                if (result != null) {
                    throw new ELException(Util.message(null, "importHandler.ambiguousImport", className, result.getName()));
                }
                result = clazz;
            }
            if (result != null) {
                this.clazzes.put(name, result);
            }
        }
        return result;
    }

    public Class<?> resolveStatic(String name) {
        return this.statics.get(name);
    }

    private Class<?> findClass(String name) {
        Class<?> clazz;
        try {
            clazz = Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        int modifiers = clazz.getModifiers();
        if (!Modifier.isPublic(modifiers) || Modifier.isAbstract(modifiers) || Modifier.isInterface(modifiers)) {
            throw new ELException(Util.message(null, "importHandler.invalidClass", name));
        }
        return clazz;
    }

    private static class SingletonHolder {
        private static final ImportHandler INSTANCE = new ImportHandler();

        private SingletonHolder() {
        }
    }
}

