/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.zel.impl.parser;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.zkoss.zel.ELException;
import org.zkoss.zel.ELResolver;
import org.zkoss.zel.MethodInfo;
import org.zkoss.zel.PropertyNotFoundException;
import org.zkoss.zel.ValueReference;
import org.zkoss.zel.impl.lang.ELSupport;
import org.zkoss.zel.impl.lang.EvaluationContext;
import org.zkoss.zel.impl.parser.AstMethodParameters;
import org.zkoss.zel.impl.parser.Node;
import org.zkoss.zel.impl.parser.SimpleNode;
import org.zkoss.zel.impl.util.MessageFactory;
import org.zkoss.zel.impl.util.ReflectionUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AstValue
extends SimpleNode {
    private static final boolean IS_SECURITY_ENABLED = System.getSecurityManager() != null;
    protected static final boolean COERCE_TO_ZERO = IS_SECURITY_ENABLED ? AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        @Override
        public Boolean run() {
            return Boolean.valueOf(System.getProperty("org.zkoss.zel.impl.parser.COERCE_TO_ZERO", "true"));
        }
    }).booleanValue() : Boolean.valueOf(System.getProperty("org.zkoss.zel.impl.parser.COERCE_TO_ZERO", "true")).booleanValue();

    public AstValue(int id) {
        super(id);
    }

    @Override
    public Class<?> getType(EvaluationContext ctx) throws ELException {
        Target t = this.getTarget(ctx);
        ctx.setPropertyResolved(false);
        Class<?> result = ctx.getELResolver().getType(ctx, t.base, t.property);
        if (!ctx.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled", t.base, t.property));
        }
        return result;
    }

    private final Target getTarget(EvaluationContext ctx) throws ELException {
        int i;
        ctx.putContext(Node.class, this.children[0]);
        Object base = this.children[0].getValue(ctx);
        ctx.putContext(Node.class, this.children[0]);
        if (base == null) {
            throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.base", this.children[0].getImage()));
        }
        Object property = null;
        int propCount = this.jjtGetNumChildren();
        propCount = propCount > 2 && this.jjtGetChild(propCount - 1) instanceof AstMethodParameters ? (propCount -= 2) : --propCount;
        ELResolver resolver = ctx.getELResolver();
        if (propCount > 1) {
            for (i = 1; base != null && i < propCount; ++i) {
                property = this.children[i].getValue(ctx);
                ctx.setPropertyResolved(false);
                ctx.putContext(Node.class, this.children[i]);
                base = resolver.getValue(ctx, base, property);
                ctx.putContext(Node.class, this.children[i]);
            }
            if (base == null || property == null) {
                throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.property", property));
            }
        }
        ctx.putContext(Node.class, this.children[i]);
        property = this.children[i].getValue(ctx);
        ctx.putContext(Node.class, this.children[i]);
        if (property == null) {
            throw new PropertyNotFoundException(MessageFactory.get("error.unreachable.property", this.children[i]));
        }
        Target t = new Target();
        t.base = base;
        t.property = property;
        return t;
    }

    @Override
    public Object getValue(EvaluationContext ctx) throws ELException {
        ctx.putContext(AstValue.class, new Integer(this.jjtGetNumChildren()));
        ctx.putContext(Node.class, this.children[0]);
        Object base = this.children[0].getValue(ctx);
        ctx.putContext(Node.class, this.children[0]);
        int propCount = this.jjtGetNumChildren();
        int i = 1;
        Object suffix = null;
        ELResolver resolver = ctx.getELResolver();
        while (base != null && i < propCount) {
            suffix = this.children[i].getValue(ctx);
            if (i + 1 < propCount && this.children[i + 1] instanceof AstMethodParameters) {
                AstMethodParameters mps = (AstMethodParameters)this.children[i + 1];
                base = resolver.invoke(ctx, base, suffix, null, mps.getParameters(ctx));
                i += 2;
                continue;
            }
            if (suffix == null) {
                return null;
            }
            ctx.setPropertyResolved(false);
            ctx.putContext(Node.class, this.children[i]);
            base = resolver.getValue(ctx, base, suffix);
            ctx.putContext(Node.class, this.children[i]);
            ++i;
        }
        if (!ctx.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled", base, suffix));
        }
        return base;
    }

    @Override
    public boolean isReadOnly(EvaluationContext ctx) throws ELException {
        Target t = this.getTarget(ctx);
        ctx.setPropertyResolved(false);
        boolean result = ctx.getELResolver().isReadOnly(ctx, t.base, t.property);
        if (!ctx.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled", t.base, t.property));
        }
        return result;
    }

    @Override
    public void setValue(EvaluationContext ctx, Object value) throws ELException {
        ctx.putContext(AstValue.class, new Integer(this.jjtGetNumChildren()));
        Target t = this.getTarget(ctx);
        ctx.setPropertyResolved(false);
        ELResolver resolver = ctx.getELResolver();
        Class<?> targetClass = resolver.getType(ctx, t.base, t.property);
        if (COERCE_TO_ZERO || !this.isAssignable(value, targetClass)) {
            resolver.setValue(ctx, t.base, t.property, ELSupport.coerceToType(value, targetClass));
        } else {
            resolver.setValue(ctx, t.base, t.property, value);
        }
        if (!ctx.isPropertyResolved()) {
            throw new PropertyNotFoundException(MessageFactory.get("error.resolver.unhandled", t.base, t.property));
        }
    }

    private boolean isAssignable(Object value, Class<?> targetClass) {
        if (targetClass == null) {
            return false;
        }
        if (value != null && targetClass.isPrimitive()) {
            return false;
        }
        return value == null || targetClass.isInstance(value);
    }

    public MethodInfo getMethodInfo(EvaluationContext ctx, Class[] paramTypes) throws ELException {
        Target t = this.getTarget(ctx);
        Method m = ReflectionUtil.getMethod(t.base, t.property, paramTypes);
        return new MethodInfo(m.getName(), m.getReturnType(), m.getParameterTypes());
    }

    public Object invoke(EvaluationContext ctx, Class[] paramTypes, Object[] paramValues) throws ELException {
        Target t = this.getTarget(ctx);
        Method m = null;
        Object[] values = null;
        if (this.isParametersProvided()) {
            values = ((AstMethodParameters)this.jjtGetChild(2)).getParameters(ctx);
            Class<?>[] types = this.getTypesFromValues(values);
            m = ReflectionUtil.getMethod(t.base, t.property, types);
        } else {
            m = ReflectionUtil.getMethod(t.base, t.property, paramTypes);
            values = paramValues;
        }
        if (m.isVarArgs()) {
            values = this.toVarArgs(values, m);
        }
        Object result = null;
        try {
            result = m.invoke(t.base, values);
        }
        catch (IllegalAccessException iae) {
            throw new ELException(iae);
        }
        catch (IllegalArgumentException iae) {
            throw new ELException(iae);
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
        return result;
    }

    private Object[] toVarArgs(Object[] src, Method m) {
        int paramCount = m.getParameterTypes().length;
        Object[] dest = new Object[paramCount];
        Object[] varArgs = (Object[])Array.newInstance(m.getParameterTypes()[paramCount - 1].getComponentType(), src.length - (paramCount - 1));
        System.arraycopy(src, 0, dest, 0, paramCount - 1);
        System.arraycopy(src, paramCount - 1, varArgs, 0, src.length - (paramCount - 1));
        dest[paramCount - 1] = varArgs;
        return dest;
    }

    private Class<?>[] getTypesFromValues(Object[] values) {
        if (values == null) {
            return null;
        }
        Class[] result = new Class[values.length];
        for (int i = 0; i < values.length; ++i) {
            result[i] = values[i] == null ? null : values[i].getClass();
        }
        return result;
    }

    @Override
    public ValueReference getValueReference(EvaluationContext ctx) {
        if (this.children.length > 2 && this.jjtGetChild(2) instanceof AstMethodParameters) {
            return null;
        }
        Target t = this.getTarget(ctx);
        return new ValueReference(t.base, t.property);
    }

    @Override
    public boolean isParametersProvided() {
        return this.children.length > 2 && this.jjtGetChild(2) instanceof AstMethodParameters;
    }

    protected static class Target {
        protected Object base;
        protected Object property;

        protected Target() {
        }
    }
}

