/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util.resource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Library;
import org.zkoss.lang.SystemException;
import org.zkoss.util.FilterMap;
import org.zkoss.util.Locales;
import org.zkoss.util.Maps;
import org.zkoss.util.WaitLock;
import org.zkoss.util.resource.ClassLocator;
import org.zkoss.util.resource.LabelLocator;
import org.zkoss.util.resource.LabelLocator2;
import org.zkoss.util.resource.impl.LabelLoader;
import org.zkoss.xel.Expression;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.Expressions;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.VariableResolverX;
import org.zkoss.xel.util.SimpleXelContext;

public class LabelLoaderImpl
implements LabelLoader {
    private static final Logger log = LoggerFactory.getLogger(LabelLoaderImpl.class);
    private Map<Locale, Map<String, ExValue>> _labels = Collections.emptyMap();
    private Map<Locale, Map<String, Object>> _segLabels = Collections.emptyMap();
    private final Map<Locale, Object> _syncLabels = new HashMap<Locale, Object>(8);
    private final Set<Object> _locators = new LinkedHashSet<Object>(4);
    private final SimpleXelContext _xelc;
    private String _jarcharset;
    private String _warcharset;
    private final ExpressionFactory _expf;
    private final FilterMap.Filter _fmfilter = new FilterMap.Filter(){

        public Object filter(Object key, Object value) {
            Object o;
            Object object = o = value instanceof ExValue ? ((ExValue)value).getValue() : value;
            if (o == null) {
                o = LabelLoaderImpl.this.handleMissingLabel(key);
            }
            return o;
        }
    };

    public LabelLoaderImpl() {
        this._expf = Expressions.newExpressionFactory();
        this._xelc = new SimpleXelContext(new Resolver(), null);
    }

    protected Object handleMissingLabel(Object key) {
        log.debug("The key of [{}] is not found in labels!", key);
        return null;
    }

    @Override
    public String getLabel(String key) {
        return this.getLabel(Locales.getCurrent(), key);
    }

    @Override
    public String getLabel(Locale locale, String key) {
        ExValue exVal;
        Map<String, ExValue> map = this._labels.get(locale);
        if (map == null) {
            map = this.loadLabels(locale);
        }
        return (exVal = map.get(key)) != null ? exVal.getValue() : null;
    }

    @Override
    public Map<String, Object> getSegmentedLabels() {
        return this.getSegmentedLabels(Locales.getCurrent());
    }

    @Override
    public Map<String, Object> getSegmentedLabels(Locale locale) {
        Map<String, Object> map = this._segLabels.get(locale);
        if (map != null) {
            return map;
        }
        this.loadLabels(locale);
        return this._segLabels.get(locale);
    }

    @Override
    public VariableResolver setVariableResolver(VariableResolver resolv) {
        Resolver resolver = (Resolver)this._xelc.getVariableResolver();
        VariableResolver old = resolver.custom;
        resolver.custom = resolv;
        return old;
    }

    @Override
    public void register(LabelLocator locator) {
        this.register0(locator);
    }

    @Override
    public void register(LabelLocator2 locator) {
        this.register0(locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register0(Object locator) {
        if (locator == null) {
            throw new NullPointerException("locator");
        }
        Set<Object> set = this._locators;
        synchronized (set) {
            if (!this._locators.add(locator)) {
                log.warn("Replace the old one, because it is replicated: " + locator);
            }
        }
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        Map<Locale, Object> map = this._syncLabels;
        synchronized (map) {
            this._syncLabels.clear();
            this._segLabels = Collections.emptyMap();
            this._labels = Collections.emptyMap();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, ExValue> loadLabels(Locale locale) {
        Map<Locale, Object> map;
        WaitLock lock = null;
        while (true) {
            Object o;
            map = this._syncLabels;
            synchronized (map) {
                o = this._syncLabels.get(locale);
                if (o == null) {
                    lock = new WaitLock();
                    this._syncLabels.put(locale, lock);
                }
            }
            if (o instanceof Map) {
                return (Map)o;
            }
            if (o == null) break;
            if (((WaitLock)o).waitUntilUnlock(300000)) continue;
            log.warn("Take too long to wait loading labels: " + locale + "\nTry to load again automatically...");
        }
        if (this._jarcharset == null) {
            this._jarcharset = Library.getProperty("org.zkoss.util.label.classpath.charset", "UTF-8");
        }
        if (this._warcharset == null) {
            this._warcharset = Library.getProperty("org.zkoss.util.label.web.charset", null);
            if (this._warcharset == null) {
                this._warcharset = Library.getProperty("org.zkoss.util.label.WEB-INF.charset", "UTF-8");
            }
        }
        try {
            LinkedList<Object> locators;
            Object url;
            if (locale != null) {
                log.info("Loading labels for " + locale);
            }
            Map<String, Object> labels = new HashMap<String, String>(512);
            ClassLocator locator = new ClassLocator();
            Enumeration<URL> en = locator.getResources(locale == null ? "metainfo/zk-label.properties" : "metainfo/zk-label_" + locale + ".properties");
            while (en.hasMoreElements()) {
                url = en.nextElement();
                LabelLoaderImpl.load(labels, (URL)url, this._jarcharset);
            }
            url = this._locators;
            synchronized (url) {
                locators = new LinkedList<Object>(this._locators);
            }
            for (Object e : locators) {
                if (e instanceof LabelLocator) {
                    URL url2 = ((LabelLocator)e).locate(locale);
                    if (url2 == null) continue;
                    LabelLoaderImpl.load(labels, url2, this._warcharset);
                    continue;
                }
                LabelLocator2 loc = (LabelLocator2)e;
                InputStream is = loc.locate(locale);
                if (is == null) continue;
                String cs = loc.getCharset();
                LabelLoaderImpl.load(labels, is, cs != null ? cs : this._warcharset);
            }
            this.toExValue(labels);
            if (locale != null) {
                String lang = locale.getLanguage();
                String string = locale.getCountry();
                String var = locale.getVariant();
                Map<String, ExValue> superlabels = this.loadLabels(var != null && var.length() > 0 ? new Locale(lang, string) : (string != null && string.length() > 0 ? new Locale(lang, "") : null));
                if (labels.isEmpty()) {
                    labels = superlabels.isEmpty() ? Collections.EMPTY_MAP : superlabels;
                } else if (!superlabels.isEmpty()) {
                    HashMap<String, ExValue> combined = new HashMap<String, ExValue>(superlabels);
                    combined.putAll(labels);
                    labels = combined;
                }
            }
            Map<Locale, Object> map2 = this._syncLabels;
            synchronized (map2) {
                this._syncLabels.put(locale, labels);
                this.cloneLables();
            }
            map2 = labels;
            return map2;
        }
        catch (Throwable ex) {
            map = this._syncLabels;
            synchronized (map) {
                this._syncLabels.remove(locale);
                this.cloneLables();
            }
            throw SystemException.Aide.wrap(ex);
        }
        finally {
            lock.unlock();
        }
    }

    private void toExValue(Map labels) {
        if (!labels.isEmpty()) {
            for (Map.Entry entry : labels.entrySet()) {
                String value = this.expendValue(labels, (String)entry.getValue());
                entry.setValue(new ExValue(value));
            }
        }
    }

    private String expendValue(Map labels, String value) {
        if (labels != null && value != null) {
            int end;
            int start;
            int offset = 0;
            while (offset < value.length() && (start = value.indexOf("${", offset)) != -1 && (end = value.indexOf("}", start)) != -1) {
                String exp = value.substring(start, end + 1);
                String expStr = exp.substring(2, exp.length() - 1);
                if (expStr.endsWith(".$")) {
                    expStr = expStr.substring(0, expStr.length() - 2);
                }
                Object expend = labels.get(expStr);
                String expended = "";
                if (expend instanceof String) {
                    expended = this.expendValue(labels, (String)expend);
                } else if (expend instanceof ExValue) {
                    expended = this.expendValue(labels, ((ExValue)expend).getValue());
                }
                value = value.substring(0, start) + expended + value.substring(start + exp.length());
                offset = start + expended.length();
            }
        }
        return value;
    }

    private void cloneLables() {
        HashMap<Locale, Map<String, ExValue>> labels = new HashMap<Locale, Map<String, ExValue>>();
        HashMap<Locale, Map<String, Object>> segLabels = new HashMap<Locale, Map<String, Object>>();
        for (Map.Entry<Locale, Object> me : this._syncLabels.entrySet()) {
            Object value = me.getValue();
            if (!(value instanceof Map)) continue;
            Locale key = me.getKey();
            labels.put(key, (Map<String, ExValue>)value);
            segLabels.put(key, this.segment((Map)value));
        }
        this._labels = labels;
        this._segLabels = segLabels;
    }

    private Map segment(Map map) {
        for (String key : map.keySet()) {
            if (key.indexOf(".") < 0) continue;
            return this.segmentInner(new HashMap(map));
        }
        return new FilterMap(map, this._fmfilter);
    }

    private FilterMap segmentInner(Map map) {
        HashMap segFound = new HashMap();
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            String key = (String)me.getKey();
            Object val = me.getValue();
            int index = key.indexOf(46);
            if (index < 0) continue;
            it.remove();
            String newkey = key.substring(0, index);
            HashMap vals = (HashMap)segFound.get(newkey);
            if (vals == null) {
                vals = new HashMap();
                segFound.put(newkey, vals);
            }
            vals.put(key.substring(index + 1), val);
        }
        for (Map.Entry me : segFound.entrySet()) {
            Map<String, FilterMap> m;
            FilterMap seged = this.segmentInner((Map)me.getValue());
            FilterMap o = map.put(me.getKey(), seged);
            if (o == null || o instanceof Map || (o = (m = seged.getOrigin()).put("$", o)) == null) continue;
            m.put("$", o);
        }
        return new FilterMap(map, this._fmfilter);
    }

    private static final void load(Map<String, String> labels, URL url, String charset) throws IOException {
        log.info("Opening " + url);
        LabelLoaderImpl.load(labels, url.openStream(), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void load(Map<String, String> labels, InputStream is, String charset) throws IOException {
        HashMap news = new HashMap();
        try {
            Maps.load(news, is, charset);
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable throwable) {}
        }
        for (Map.Entry me : news.entrySet()) {
            labels.put((String)me.getKey(), (String)me.getValue());
        }
    }

    private class Resolver
    implements VariableResolver {
        private VariableResolver custom;

        private Resolver() {
        }

        @Override
        public Object resolveVariable(String name) {
            if (this.custom != null) {
                Object o;
                Object object = o = this.custom instanceof VariableResolverX ? ((VariableResolverX)this.custom).resolveVariable(null, null, name) : this.custom.resolveVariable(name);
                if (o != null) {
                    return o;
                }
            }
            return LabelLoaderImpl.this.getSegmentedLabels().get(name);
        }
    }

    private class ExValue {
        private Expression _expr;
        private String _val;

        public ExValue(String val) {
            int j = val.indexOf("${");
            if (j >= 0 && val.indexOf(125, j + 2) >= 0) {
                try {
                    this._expr = LabelLoaderImpl.this._expf.parseExpression(LabelLoaderImpl.this._xelc, val, String.class);
                    return;
                }
                catch (Throwable ex) {
                    log.error("Illegal expression: " + val, ex);
                }
            }
            this._expr = null;
            this._val = val;
        }

        public String getValue() {
            return this._expr != null ? (String)this._expr.evaluate(LabelLoaderImpl.this._xelc) : this._val;
        }
    }
}

