/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.zkoss.lang.Strings;
import org.zkoss.util.ComodifiableIterator;
import org.zkoss.util.Converter;

public class CollectionsX {
    public static final Iterator EMPTY_ITERATOR = new Iterator(){

        @Override
        public final boolean hasNext() {
            return false;
        }

        public final Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public final void remove() {
            throw new IllegalStateException();
        }
    };
    public static final Enumeration EMPTY_ENUMERATION = new Enumeration(){

        @Override
        public final boolean hasMoreElements() {
            return false;
        }

        public final Object nextElement() {
            throw new NoSuchElementException();
        }
    };
    private static final Iterable EMPTY_ITERABLE = new Iterable(){

        public Iterator iterator() {
            return EMPTY_ITERATOR;
        }
    };

    public static final <T> Iterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    public static final <T> Enumeration<T> emptyEnumeration() {
        return EMPTY_ENUMERATION;
    }

    public static final <T> Iterable<T> emptyIterable() {
        return EMPTY_ITERABLE;
    }

    public static final Object[] toArray(Collection col, int from, int to) {
        return CollectionsX.toArray(col, new Object[0], from, to);
    }

    public static final <T> T[] toArray(Collection<? extends T> col, T[] dst, int from, int to) {
        int newLength;
        int sz = col.size();
        if (to > sz) {
            to = sz;
        }
        if (from < 0) {
            from = 0;
        }
        if ((newLength = to - from) < 0) {
            throw new IllegalArgumentException(from + " > " + to);
        }
        if (dst.length < newLength) {
            dst = (Object[])Array.newInstance(dst.getClass().getComponentType(), newLength);
        }
        int i = 0;
        int j = 0;
        Iterator<T> it = col.iterator();
        while (it.hasNext() && i < dst.length) {
            if (j++ < from) {
                it.next();
                continue;
            }
            dst[i++] = it.next();
        }
        return dst;
    }

    public static final <T> int addAll(Collection<T> col, Iterator<? extends T> iter) {
        int cnt = 0;
        if (iter != null) {
            while (iter.hasNext()) {
                col.add(iter.next());
                ++cnt;
            }
        }
        return cnt;
    }

    public static final <T> int addAll(Collection<T> col, Enumeration<? extends T> enm) {
        int cnt = 0;
        if (enm != null) {
            while (enm.hasMoreElements()) {
                col.add(enm.nextElement());
                ++cnt;
            }
        }
        return cnt;
    }

    public static final <T> int addAll(Collection<T> col, Object[] ary) {
        int cnt;
        if (ary != null) {
            for (cnt = 0; cnt < ary.length; ++cnt) {
                col.add(ary[cnt]);
            }
        }
        return cnt;
    }

    public static final boolean isIntersected(Set<?> a, Set<?> b) {
        Set<?> small;
        Set<?> large;
        int szb;
        int sza = a != null ? a.size() : 0;
        int n = szb = b != null ? b.size() : 0;
        if (sza == 0 || szb == 0) {
            return false;
        }
        if (sza > szb) {
            large = a;
            small = b;
        } else {
            large = b;
            small = a;
        }
        Iterator<?> it = small.iterator();
        while (it.hasNext()) {
            if (!large.contains(it.next())) continue;
            return true;
        }
        return false;
    }

    public static final Collection<String> parse(Collection<String> c, String src, char separator) {
        return CollectionsX.parse(c, src, separator, true);
    }

    public static final Collection<String> parse(Collection<String> c, String src, char separator, boolean escBackslash) {
        return CollectionsX.parse(c, src, separator, escBackslash, false);
    }

    public static final Collection<String> parse(Collection<String> c, String src, char separator, boolean escBackslash, boolean parenthesis) {
        Strings.Result res;
        if (c == null) {
            c = new LinkedList<String>();
        }
        char[] seps = new char[]{separator};
        int j = 0;
        while ((res = Strings.nextToken(src, j, seps, escBackslash, true, parenthesis)) != null) {
            assert (res.token != null);
            c.add(res.token);
            j = res.next;
        }
        return c;
    }

    public static final Iterator iterator(Object obj) {
        if (obj instanceof Object[]) {
            return new ArrayIterator((Object[])obj);
        }
        if (obj instanceof Collection) {
            return ((Collection)obj).iterator();
        }
        if (obj instanceof Map) {
            return ((Map)obj).entrySet().iterator();
        }
        throw new IllegalArgumentException("obj must be a Collection, a Map, or an Object array. obj: " + obj);
    }

    public static <E> Iterator<E> comodifiableIterator(Collection<E> col) {
        return new ComodifiableIterator(col, null);
    }

    public static <F, T> Iterator<T> comodifiableIterator(Collection<F> col, Converter<F, T> converter) {
        return new ComodifiableIterator<F, T>(col, converter);
    }

    public static final class EnumerationIterator<E>
    implements Iterator<E> {
        private final Enumeration<? extends E> _enm;

        public EnumerationIterator(Enumeration<? extends E> enm) {
            this._enm = enm;
        }

        @Override
        public final boolean hasNext() {
            return this._enm != null && this._enm.hasMoreElements();
        }

        @Override
        public final E next() {
            if (this._enm == null) {
                throw new NoSuchElementException();
            }
            return this._enm.nextElement();
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class OneIterator<E>
    implements Iterator<E> {
        private boolean _nomore;
        private final E _one;

        public OneIterator(E one) {
            this._one = one;
        }

        @Override
        public final boolean hasNext() {
            return !this._nomore;
        }

        @Override
        public final E next() {
            if (this._nomore) {
                throw new NoSuchElementException();
            }
            this._nomore = true;
            return this._one;
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class OneCollection<E>
    extends AbstractCollection<E> {
        private final E _one;

        public OneCollection(E one) {
            this._one = one;
        }

        @Override
        public final int size() {
            return 1;
        }

        @Override
        public Iterator<E> iterator() {
            return new OneIterator<E>(this._one);
        }
    }

    public static class ArrayListIterator<E>
    extends ArrayIterator<E>
    implements ListIterator<E> {
        public ArrayListIterator(Object[] ary) {
            super(ary);
        }

        public ArrayListIterator(E[] ary, int index) {
            super(ary);
            int len;
            this._cursor = index;
            int n = len = this._ary != null ? this._ary.length : 0;
            if (this._cursor < 0 || this._cursor > len) {
                throw new IndexOutOfBoundsException("index=" + index + " but len=" + len);
            }
        }

        @Override
        public final boolean hasPrevious() {
            return this._ary != null && this._cursor > 0;
        }

        @Override
        public final E previous() {
            if (this.hasPrevious()) {
                this._last = --this._cursor;
                return (E)this._ary[this._cursor];
            }
            throw new NoSuchElementException("cursor=" + this._cursor);
        }

        @Override
        public final int nextIndex() {
            return this._cursor;
        }

        @Override
        public final int previousIndex() {
            return this._cursor - 1;
        }

        @Override
        public final void set(E o) {
            if (this._last < 0) {
                throw new IllegalStateException("neither next nor previous have been called");
            }
            this._ary[this._last] = o;
        }

        @Override
        public final void add(E o) {
            throw new UnsupportedOperationException();
        }
    }

    public static class ArrayIterator<E>
    implements Iterator<E> {
        final Object[] _ary;
        int _cursor = 0;
        int _last = -1;

        public ArrayIterator(Object[] ary) {
            this._ary = ary;
        }

        @Override
        public final boolean hasNext() {
            return this._ary != null && this._cursor < this._ary.length;
        }

        @Override
        public final E next() {
            if (this.hasNext()) {
                this._last = this._cursor++;
                return (E)this._ary[this._last];
            }
            throw new NoSuchElementException("cursor=" + this._cursor);
        }

        @Override
        public final void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static final class ArrayList<E>
    extends AbstractList<E> {
        private final Object[] _ary;

        public ArrayList(Object[] ary) {
            this._ary = ary;
        }

        @Override
        public final int size() {
            return this._ary != null ? this._ary.length : 0;
        }

        @Override
        public final E get(int index) {
            return (E)this._ary[index];
        }
    }

    public static final class ArrayCollection<E>
    extends AbstractCollection<E> {
        private final Object[] _ary;

        public ArrayCollection(Object[] ary) {
            this._ary = ary;
        }

        @Override
        public final int size() {
            return this._ary != null ? this._ary.length : 0;
        }

        @Override
        public Iterator<E> iterator() {
            return new ArrayIterator(this._ary);
        }
    }

    public static final class OneEnumeration<E>
    implements Enumeration<E> {
        private boolean _nomore;
        private final E _one;

        public OneEnumeration(E one) {
            this._one = one;
        }

        @Override
        public final boolean hasMoreElements() {
            return !this._nomore;
        }

        @Override
        public final E nextElement() {
            if (this._nomore) {
                throw new NoSuchElementException();
            }
            this._nomore = true;
            return this._one;
        }
    }

    public static final class ArrayEnumeration<E>
    implements Enumeration<E> {
        private final Object[] _ary;
        private int _cursor = 0;

        public ArrayEnumeration(Object[] ary) {
            this._ary = ary;
        }

        @Override
        public final boolean hasMoreElements() {
            return this._ary != null && this._cursor < this._ary.length;
        }

        @Override
        public final E nextElement() {
            if (this.hasMoreElements()) {
                return (E)this._ary[this._cursor++];
            }
            throw new NoSuchElementException();
        }
    }

    public static final class CollectionEnumeration<E>
    implements Enumeration<E> {
        private final Iterator<? extends E> _iter;

        public CollectionEnumeration(Collection<? extends E> c) {
            this(c != null ? c.iterator() : null);
        }

        public CollectionEnumeration(Iterator<? extends E> iter) {
            this._iter = iter;
        }

        @Override
        public final boolean hasMoreElements() {
            return this._iter != null && this._iter.hasNext();
        }

        @Override
        public final E nextElement() {
            if (this._iter != null) {
                return this._iter.next();
            }
            throw new NoSuchElementException();
        }
    }
}

