/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.html;

import java.io.Serializable;
import org.zkoss.lang.Objects;

public class StyleSheet
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 20100514L;
    private final String _href;
    private final String _type;
    private final String _content;
    private final String _media;
    private final boolean _disabled;

    public StyleSheet(String href, String type) {
        this(href, type, null, false, false);
    }

    public StyleSheet(String content, String type, boolean byContent) {
        this(content, type, null, byContent, false);
    }

    public StyleSheet(String content, String type, String media, boolean byContent) {
        this(content, type, null, byContent, false);
    }

    public StyleSheet(String content, String type, String media, boolean byContent, boolean disabled) {
        if (content == null) {
            throw new IllegalArgumentException("null content");
        }
        if (byContent) {
            this._href = null;
            this._content = content;
        } else {
            this._href = content;
            this._content = null;
        }
        this._type = type != null && type.length() != 0 ? type : "text/css";
        this._media = media != null && media.length() != 0 ? media : null;
        this._disabled = disabled;
    }

    public String getHref() {
        return this._href;
    }

    public String getType() {
        return this._type;
    }

    public String getMedia() {
        return this._media;
    }

    public String getContent() {
        return this._content;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public String toString() {
        return "[href: " + this._href + " type=" + this._type + ']';
    }

    public int hashCode() {
        return this._href.hashCode() + this._type.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StyleSheet)) {
            return false;
        }
        StyleSheet ss = (StyleSheet)o;
        return Objects.equals(ss._href, this._href) && Objects.equals(ss._type, this._type) && Objects.equals(ss._content, this._content) && Objects.equals(ss._media, this._media);
    }
}

