/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArraysX {
    public static final String toString(Object[] array) {
        if (array == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer(128).append('[');
        for (int j = 0; j < array.length; ++j) {
            if (array[j] == array) {
                sb.append("(this array)");
            } else {
                sb.append(array[j]);
            }
            if (j == array.length - 1) continue;
            sb.append(", ");
        }
        return sb.append(']').toString();
    }

    public static final String toString(int[] array) {
        if (array == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer(128).append('[');
        for (int j = 0; j < array.length; ++j) {
            sb.append(array[j]);
            if (j == array.length - 1) continue;
            sb.append(", ");
        }
        return sb.append(']').toString();
    }

    public static final String toString(long[] array) {
        if (array == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer(128).append('[');
        for (int j = 0; j < array.length; ++j) {
            sb.append(array[j]);
            if (j == array.length - 1) continue;
            sb.append(", ");
        }
        return sb.append(']').toString();
    }

    public static final String toString(short[] array) {
        if (array == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer(128).append('[');
        for (int j = 0; j < array.length; ++j) {
            sb.append(array[j]);
            if (j == array.length - 1) continue;
            sb.append(", ");
        }
        return sb.append(']').toString();
    }

    public static final String toString(byte[] array) {
        if (array == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer(128).append('[');
        for (int j = 0; j < array.length; ++j) {
            sb.append(array[j]);
            if (j == array.length - 1) continue;
            sb.append(", ");
        }
        return sb.append(']').toString();
    }

    public static final String toString(char[] array) {
        if (array == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer(128).append('[');
        for (int j = 0; j < array.length; ++j) {
            sb.append(array[j]);
            if (j == array.length - 1) continue;
            sb.append(", ");
        }
        return sb.append(']').toString();
    }

    public static final String toString(boolean[] array) {
        if (array == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer(128).append('[');
        for (int j = 0; j < array.length; ++j) {
            sb.append(array[j]);
            if (j == array.length - 1) continue;
            sb.append(", ");
        }
        return sb.append(']').toString();
    }

    public static final String toString(float[] array) {
        if (array == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer(128).append('[');
        for (int j = 0; j < array.length; ++j) {
            sb.append(array[j]);
            if (j == array.length - 1) continue;
            sb.append(", ");
        }
        return sb.append(']').toString();
    }

    public static final String toString(double[] array) {
        if (array == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer(128).append('[');
        for (int j = 0; j < array.length; ++j) {
            sb.append(array[j]);
            if (j == array.length - 1) continue;
            sb.append(", ");
        }
        return sb.append(']').toString();
    }

    public static final String toHexString(byte[] array) {
        StringBuffer sb = new StringBuffer(array.length * 2 + 8);
        for (int i = 0; i < array.length; ++i) {
            char ch = Character.forDigit(array[i] >>> 4 & 0xF, 16);
            sb.append(ch);
            ch = Character.forDigit(array[i] & 0xF, 16);
            sb.append(ch);
        }
        return sb.toString();
    }

    public static final String toOctalString(byte[] array, String prefix) {
        StringBuffer sb = new StringBuffer(array.length * (3 + (prefix == null ? 0 : prefix.length())) + 8);
        if (prefix == null) {
            for (int i = 0; i < array.length; ++i) {
                ArraysX.appendOctalDigits(sb, array[i]);
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                sb.append(prefix);
                ArraysX.appendOctalDigits(sb, array[i]);
            }
        }
        return sb.toString();
    }

    private static final StringBuffer appendOctalDigits(StringBuffer sb, byte b) {
        return sb.append(Character.forDigit(b >>> 6 & 7, 8)).append(Character.forDigit(b >>> 3 & 7, 8)).append(Character.forDigit(b & 7, 8));
    }

    public static final Object duplicate(Object ary, int jb, int je) {
        int len = Array.getLength(ary);
        if (jb < 0 || je > len || jb > je) {
            throw new IndexOutOfBoundsException(jb + " or " + je + " exceeds " + len);
        }
        len = je - jb;
        Object dst = Array.newInstance(ary.getClass().getComponentType(), len);
        System.arraycopy(ary, jb, dst, 0, len);
        return dst;
    }

    public static final <T> T[] duplicate(T[] ary, int jb, int je) {
        return (Object[])ArraysX.duplicate(ary, jb, je);
    }

    public static final Object duplicate(Object ary) {
        return ArraysX.duplicate(ary, 0, Array.getLength(ary));
    }

    public static final <T> T[] duplicate(T[] ary) {
        return ArraysX.duplicate(ary, 0, ary.length);
    }

    public static final Object concat(Object ary, Object ary1) {
        int len = Array.getLength(ary) + Array.getLength(ary1);
        if (!ary.getClass().getComponentType().isAssignableFrom(ary1.getClass().getComponentType())) {
            throw new IllegalArgumentException("These concated array component types are not compatible.");
        }
        Object dst = Array.newInstance(ary.getClass().getComponentType(), len);
        System.arraycopy(ary, 0, dst, 0, Array.getLength(ary));
        System.arraycopy(ary1, 0, dst, Array.getLength(ary), Array.getLength(ary1));
        return dst;
    }

    public static final <T> T[] concat(T[] ary, T[] ary1) {
        return (Object[])ArraysX.concat(ary, ary1);
    }

    public static final Object shrink(Object ary, int jb, int je) {
        if (jb == 0 && je == Array.getLength(ary)) {
            return ary;
        }
        return ArraysX.duplicate(ary, jb, je);
    }

    public static final <T> T[] shrink(T[] ary, int jb, int je) {
        return (Object[])ArraysX.shrink(ary, jb, je);
    }

    public static final <T> List<T> asList(T[] ary) {
        if (ary == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<T> list = new ArrayList<T>(ary.length);
        for (T t : ary) {
            list.add(t);
        }
        return list;
    }

    public static final <T> List<List<T>> asList(T[][] ary) {
        if (ary == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<List<T>> list = new ArrayList<List<T>>(ary.length);
        for (T[] t : ary) {
            list.add(ArraysX.asList(t));
        }
        return list;
    }

    public static final Object resize(Object ary, int size) {
        int oldsz = Array.getLength(ary);
        if (oldsz == size) {
            return ary;
        }
        Object dst = Array.newInstance(ary.getClass().getComponentType(), size);
        System.arraycopy(ary, 0, dst, 0, oldsz > size ? size : oldsz);
        return dst;
    }

    public static final <T> T[] resize(T[] ary, int size) {
        return (Object[])ArraysX.resize(ary, size);
    }

    public static final Object clone(Object ary) {
        return ArraysX.duplicate(ary);
    }
}

