/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.xml;

import java.io.Serializable;
import javax.xml.transform.SourceLocator;
import org.zkoss.lang.Strings;
import org.zkoss.util.resource.Location;
import org.zkoss.xml.Locator;

public class Locators {
    public static String format(String message, Locator loc) {
        return loc != null ? Locators.format(message, loc.getPublicId(), loc.getSystemId(), loc.getLineNumber(), loc.getColumnNumber()) : message;
    }

    public static String format(String message, org.xml.sax.Locator loc) {
        return loc != null ? Locators.format(message, loc.getPublicId(), loc.getSystemId(), loc.getLineNumber(), loc.getColumnNumber()) : message;
    }

    public static String format(String message, SourceLocator loc) {
        return loc != null ? Locators.format(message, loc.getPublicId(), loc.getSystemId(), loc.getLineNumber(), loc.getColumnNumber()) : message;
    }

    public static String format(String message, String pubId, String sysId, int lineno, int colno) {
        StringBuffer sb = new StringBuffer();
        String inf = Locators.combine(pubId, sysId);
        if (inf != null) {
            int len = inf.length();
            if (len >= 45) {
                sb.append(inf.substring(0, 14)).append("...").append(inf.substring(len - 26));
            } else {
                sb.append(inf);
            }
        }
        if (lineno >= 0) {
            if (sb.length() > 0) {
                sb.append(':');
            }
            sb.append(lineno);
            if (colno >= 0) {
                sb.append(':').append(colno);
            }
        }
        return sb.length() > 0 ? sb.append(": ").append(message).toString() : message;
    }

    private static String combine(String pubId, String sysId) {
        return Strings.isEmpty(pubId) ? sysId : (Strings.isEmpty(sysId) ? pubId : pubId + ':' + sysId);
    }

    public static Location toLocation(Locator loc) {
        return loc != null ? new Loc(Locators.combine(loc.getPublicId(), loc.getSystemId()), loc.getLineNumber(), loc.getColumnNumber()) : null;
    }

    public static Location toLocation(org.xml.sax.Locator loc) {
        return loc != null ? new Loc(Locators.combine(loc.getPublicId(), loc.getSystemId()), loc.getLineNumber(), loc.getColumnNumber()) : null;
    }

    public static Location toLocation(SourceLocator loc) {
        return loc != null ? new Loc(Locators.combine(loc.getPublicId(), loc.getSystemId()), loc.getLineNumber(), loc.getColumnNumber()) : null;
    }

    private static class Loc
    implements Location,
    Serializable {
        private final String _path;
        private final int _lnno;
        private final int _colno;

        private Loc(String path, int lnno, int colno) {
            this._path = path;
            this._lnno = lnno;
            this._colno = colno;
        }

        public String getPath() {
            return this._path;
        }

        public int getLineNumber() {
            return this._lnno;
        }

        public int getColumnNumber() {
            return this._colno;
        }

        public String format(String message) {
            return Locators.format(message, this._path, null, this._lnno, -1);
        }

        public String toString() {
            return '[' + this._path + ':' + this._lnno + ']';
        }
    }
}

