/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.sound;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.URL;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import org.zkoss.io.NullInputStream;
import org.zkoss.lang.SystemException;
import org.zkoss.sound.Audio;
import org.zkoss.util.media.ContentTypes;

public class AAudio
implements Audio,
Serializable {
    protected static final InputStream DYNAMIC_STREAM = new NullInputStream();
    private final byte[] _data;
    protected final transient InputStream _isdata;
    private final URL _url;
    private final File _file;
    private String _format;
    private String _ctype;
    private final String _name;

    public AAudio(String name, byte[] data) throws IOException {
        if (data == null) {
            throw new IllegalArgumentException("null data");
        }
        this._name = name;
        this._data = data;
        this._isdata = null;
        this._url = null;
        this._file = null;
    }

    public AAudio(String name, InputStream isdata) throws IOException {
        if (isdata == null) {
            throw new IllegalArgumentException("null stream");
        }
        this._name = name;
        this._isdata = isdata;
        this._data = null;
        this._url = null;
        this._file = null;
    }

    public AAudio(URL url) {
        if (url == null) {
            throw new IllegalArgumentException("null url");
        }
        this._name = AAudio.getName(url);
        this._url = url;
        this._isdata = DYNAMIC_STREAM;
        this._data = null;
        this._file = null;
    }

    public AAudio(File file) {
        if (file == null) {
            throw new IllegalArgumentException("null url");
        }
        this._name = file.getName();
        this._file = file;
        this._isdata = DYNAMIC_STREAM;
        this._data = null;
        this._url = null;
    }

    public AAudio(String filename) throws IOException {
        this(new File(filename));
    }

    public AAudio(InputStream is) throws IOException {
        this(null, is);
    }

    private static String getName(URL url) {
        String name = url.getPath();
        if (name != null) {
            int j = name.lastIndexOf(File.pathSeparatorChar);
            if (j >= 0) {
                name = name.substring(j + 1);
            }
            if (File.pathSeparatorChar != '/' && (j = name.lastIndexOf(47)) >= 0) {
                name = name.substring(j + 1);
            }
        }
        return name;
    }

    private static String getContentType(String format) {
        String ctype = ContentTypes.getContentType(format);
        return ctype != null ? ctype : "audio/" + format;
    }

    private static String getFormatByName(String name) {
        int k;
        int j;
        if (name != null && (j = name.lastIndexOf(46) + 1) > (k = name.lastIndexOf(47) + 1) && j < name.length()) {
            return name.substring(j);
        }
        return null;
    }

    public final boolean isBinary() {
        return true;
    }

    public final boolean inMemory() {
        return this._data != null;
    }

    public byte[] getByteData() {
        if (this._data == null) {
            throw new IllegalStateException("Use getStreamData() instead");
        }
        return this._data;
    }

    public final String getStringData() {
        throw this.newIllegalStateException();
    }

    public InputStream getStreamData() {
        try {
            if (this._url != null) {
                InputStream is = this._url.openStream();
                return is != null ? new BufferedInputStream(is) : null;
            }
            if (this._file != null) {
                return new BufferedInputStream(new FileInputStream(this._file));
            }
        }
        catch (IOException ex) {
            throw new SystemException("Unable to read " + (this._url != null ? this._url.toString() : this._file.toString()), (Throwable)ex);
        }
        if (this._isdata != null) {
            return this._isdata;
        }
        return new ByteArrayInputStream(this._data);
    }

    public final Reader getReaderData() {
        throw this.newIllegalStateException();
    }

    private final IllegalStateException newIllegalStateException() {
        return new IllegalStateException(this._isdata != null ? "Use getStreamData() instead" : "Use getByteData() instead");
    }

    public final String getName() {
        return this._name;
    }

    public String getFormat() {
        if (this._format == null) {
            try {
                this._format = this.getFormat0();
            }
            catch (IOException ex) {
                throw new SystemException("Unable to read", (Throwable)ex);
            }
        }
        return this._format;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFormat0() throws IOException {
        String format = null;
        if (this._data != null) {
            try {
                return AudioSystem.getAudioFileFormat(new ByteArrayInputStream(this._data)).getType().getExtension();
            }
            catch (UnsupportedAudioFileException ex) {
                format = AAudio.getFormatByName(this._name);
                if (format != null) return format;
                throw (IOException)new IOException().initCause(ex);
            }
        }
        if (this._file != null) {
            try {
                return AudioSystem.getAudioFileFormat(this._file).getType().getExtension();
            }
            catch (UnsupportedAudioFileException ex) {
                format = AAudio.getFormatByName(this._name);
                if (format != null) return format;
                throw (IOException)new IOException().initCause(ex);
            }
        }
        if (this._url != null) {
            try {
                return AudioSystem.getAudioFileFormat(this._url).getType().getExtension();
            }
            catch (UnsupportedAudioFileException ex) {
                format = AAudio.getFormatByName(this._name);
                if (format != null) return format;
                throw (IOException)new IOException().initCause(ex);
            }
        }
        try {
            return AudioSystem.getAudioFileFormat(this._isdata == DYNAMIC_STREAM ? this.getStreamData() : this._isdata).getType().getExtension();
        }
        catch (UnsupportedAudioFileException ex) {
            format = AAudio.getFormatByName(this._name);
            if (format != null) return format;
            throw (IOException)new IOException().initCause(ex);
        }
    }

    public String getContentType() {
        if (this._ctype == null) {
            this._ctype = AAudio.getContentType(this.getFormat());
        }
        return this._ctype;
    }
}

