/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.lang;

import org.zkoss.lang.Objects;
import org.zkoss.lang.SystemException;
import org.zkoss.util.logging.Log;

public class Threads {
    private static final Log log = Log.lookup(Threads.class);

    public static final void sleep(int millisecs) {
        try {
            Thread.sleep(millisecs);
        }
        catch (InterruptedException ex) {
            throw SystemException.Aide.wrap(ex);
        }
    }

    public static final void setPriority(Thread thd, int priority) {
        try {
            thd.setPriority(priority);
        }
        catch (Exception ex) {
            log.warningBriefly("Unable to change priority to " + priority, ex);
        }
    }

    public static final void setDaemon(Thread thd, boolean daemon) {
        try {
            thd.setDaemon(daemon);
        }
        catch (Exception ex) {
            log.warningBriefly("Unable to set DAEMON", ex);
        }
    }

    public static final void joinAndInterrupt(Thread thd, int timeout) throws InterruptedException {
        if (timeout == 0) {
            timeout = Integer.MAX_VALUE;
        }
        int PERIOD = 5000;
        int j = 0;
        while (timeout > 0) {
            thd.join(timeout > 5000 ? 5000L : (long)timeout);
            if (!thd.isAlive()) {
                return;
            }
            try {
                thd.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if ((++j & 7) == 0) {
                log.info("Wait another thread to die over " + j * 5000 / 1000 + " seconds");
            }
            timeout -= 5000;
        }
    }

    public static final void dummy(Object o) {
        new Integer(Objects.hashCode(o));
    }
}

