/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.util.Map;
import org.zkoss.util.Cache;
import org.zkoss.util.CacheMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadLocalCache<K, V>
implements Cache<K, V> {
    private final ThreadLocal<CacheMap<K, V>> _cache = new ThreadLocal();
    private int _maxsize;
    private int _lifetime;

    public ThreadLocalCache(int maxSize, int lifetime) {
        this._maxsize = maxSize;
        this._lifetime = lifetime;
    }

    public ThreadLocalCache() {
        this(1800000, 128);
    }

    public boolean isEmpty() {
        return this.getCache().isEmpty();
    }

    public void copyTo(Map<K, V> map) {
        map.putAll(this.getCache());
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getCache().containsKey(key);
    }

    @Override
    public V get(Object key) {
        return this.getCache().get(key);
    }

    @Override
    public V put(K key, V value) {
        return this.getCache().put(key, value);
    }

    @Override
    public V remove(Object key) {
        return this.getCache().remove(key);
    }

    @Override
    public void clear() {
        this.getCache().clear();
    }

    private CacheMap<K, V> getCache() {
        CacheMap<K, V> cache = this._cache.get();
        if (cache == null) {
            cache = new CacheMap(this._maxsize, this._lifetime);
            this._cache.set(cache);
        }
        return cache;
    }

    @Override
    public int getLifetime() {
        return this._lifetime;
    }

    @Override
    public void setLifetime(int lifetime) {
        Cache cache = this._cache.get();
        if (cache != null) {
            cache.setLifetime(lifetime);
        }
        this._lifetime = lifetime;
    }

    @Override
    public int getMaxSize() {
        return this._maxsize;
    }

    @Override
    public void setMaxSize(int maxsize) {
        Cache cache = this._cache.get();
        if (cache != null) {
            cache.setMaxSize(maxsize);
        }
        this._maxsize = maxsize;
    }
}

