/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterMap<K, V>
extends AbstractMap<K, V> {
    private final Map<K, V> _map;
    private final Filter<V> _filter;

    public FilterMap(Map<K, V> map, Filter<V> filter) {
        if (map == null || filter == null) {
            throw new IllegalArgumentException("null");
        }
        this._map = map;
        this._filter = filter;
    }

    public Map<K, V> getOrigin() {
        return this._map;
    }

    @Override
    public V get(Object key) {
        return this._filter.filter(key, this._map.get(key));
    }

    @Override
    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return new EntrySet();
    }

    @Override
    public String toString() {
        return this._map.toString();
    }

    @Override
    public int hashCode() {
        return ((Object)this._map).hashCode();
    }

    @Override
    public boolean equals(Object o) {
        FilterMap fm;
        return o instanceof FilterMap && ((Object)this._map).equals(fm = (FilterMap)o) && this._filter.equals(fm._filter);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Filter<V> {
        public V filter(Object var1, V var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Entry
    implements Map.Entry<K, V> {
        private final Map.Entry<K, V> _me;

        private Entry(Map.Entry<K, V> me) {
            this._me = me;
        }

        @Override
        public K getKey() {
            return this._me.getKey();
        }

        @Override
        public V getValue() {
            return FilterMap.this._filter.filter(this._me.getKey(), this._me.getValue());
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("readonly");
        }

        public void clear() {
            FilterMap.this._map.clear();
        }

        public String toString() {
            return this._me.toString();
        }

        @Override
        public int hashCode() {
            return ((Object)this._me).hashCode();
        }

        @Override
        public boolean equals(Object o) {
            Object v2;
            Object v1;
            Object k2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k1 = this.getKey();
            return (k1 == (k2 = e.getKey()) || k1 != null && k1.equals(k2)) && ((v1 = this.getValue()) == (v2 = e.getValue()) || v1 != null && v1.equals(v2));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntryIter
    implements Iterator<Map.Entry<K, V>> {
        private final Iterator<Map.Entry<K, V>> _it;

        private EntryIter(Iterator<Map.Entry<K, V>> it) {
            this._it = it;
        }

        @Override
        public boolean hasNext() {
            return this._it.hasNext();
        }

        @Override
        public Map.Entry<K, V> next() {
            return new Entry(this._it.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("readonly");
        }

        public String toString() {
            return this._it.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        private final Set<Map.Entry<K, V>> _set;

        private EntrySet() {
            this._set = FilterMap.this._map.entrySet();
        }

        @Override
        public boolean contains(Object o) {
            return o instanceof Map.Entry && this._set.contains(((Entry)o)._me);
        }

        @Override
        public int size() {
            return FilterMap.this._map.size();
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIter(this._set.iterator());
        }

        @Override
        public void clear() {
            FilterMap.this._map.clear();
        }

        @Override
        public String toString() {
            return this._set.toString();
        }
    }
}

