/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.xel.util;

import java.io.Serializable;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.zkoss.idom.Element;
import org.zkoss.lang.Objects;
import org.zkoss.util.resource.Locator;
import org.zkoss.xel.Function;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.FunctionMapperExt;
import org.zkoss.xel.XelException;
import org.zkoss.xel.taglib.Taglib;
import org.zkoss.xel.taglib.TaglibDefinition;
import org.zkoss.xel.taglib.Taglibs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaglibMapper
implements FunctionMapper,
FunctionMapperExt,
Cloneable,
Serializable {
    protected Map<String, Function> _mtds;
    protected Map<String, Class> _clses;

    public void addClass(String name, Class cls) {
        if (name == null || name.length() == 0 || cls == null) {
            throw new IllegalArgumentException();
        }
        if (this._clses == null) {
            this._clses = new HashMap<String, Class>(4);
        }
        this._clses.put(name, cls);
    }

    public void addFunction(String prefix, String name, Function func) {
        if (name == null || name.length() == 0 || func == null) {
            throw new IllegalArgumentException();
        }
        if (this._mtds == null) {
            this._mtds = new HashMap<String, Function>(4);
        }
        this._mtds.put(prefix + ":" + name, func);
    }

    public void load(String prefix, URL url) throws XelException {
        try {
            this.load0(prefix, Taglibs.load(url));
        }
        catch (Exception ex) {
            throw XelException.Aide.wrap(ex);
        }
    }

    public void load(Taglib taglib, Locator locator) {
        this.load(taglib.getPrefix(), taglib.getURI(), locator);
    }

    public void load(String prefix, String uri, Locator locator) throws XelException {
        URL url;
        if (prefix == null || uri == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._mtds != null && this._mtds.containsKey(prefix)) {
            throw new XelException("The prefix, " + prefix + ", is already used");
        }
        URL uRL = url = uri.indexOf("://") > 0 ? null : locator.getResource(uri);
        if (url == null && (url = Taglibs.getDefaultURL(uri)) == null) {
            throw new XelException("Resource not found: " + uri);
        }
        this.load(prefix, url);
    }

    public void load(String prefix, Element root) throws XelException {
        if (prefix == null || root == null) {
            throw new IllegalArgumentException("null");
        }
        if (this._mtds != null && this._mtds.containsKey(prefix)) {
            throw new XelException("The prefix, " + prefix + ", is already used");
        }
        try {
            this.load0(prefix, Taglibs.load(root));
        }
        catch (Exception ex) {
            throw XelException.Aide.wrap(ex);
        }
    }

    private void load0(String prefix, TaglibDefinition loaded) {
        if (!loaded.functions.isEmpty()) {
            if (this._mtds == null) {
                this._mtds = new HashMap<String, Function>(8);
            }
            for (Map.Entry<String, Function> me : loaded.functions.entrySet()) {
                this.addFunction(prefix, me.getKey(), me.getValue());
            }
        }
        if (!loaded.classes.isEmpty()) {
            if (this._clses == null) {
                this._clses = new HashMap<String, Class>(4);
            }
            this._clses.putAll(loaded.classes);
        }
    }

    @Override
    public Function resolveFunction(String prefix, String name) {
        return this._mtds != null ? this._mtds.get(prefix + ":" + name) : null;
    }

    @Override
    public Collection<String> getClassNames() {
        if (this._clses != null) {
            return this._clses.keySet();
        }
        return Collections.emptyList();
    }

    public Class resolveClass(String name) {
        return this._clses != null ? this._clses.get(name) : null;
    }

    public Object clone() {
        TaglibMapper clone;
        try {
            clone = (TaglibMapper)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
        if (this._mtds != null) {
            clone._mtds = new HashMap<String, Function>(clone._mtds);
        }
        if (this._clses != null) {
            clone._clses = new HashMap<String, Class>(clone._clses);
        }
        return clone;
    }

    public int hashCode() {
        return Objects.hashCode(this._mtds) ^ Objects.hashCode(this._clses);
    }

    public boolean equals(Object o) {
        return o instanceof TaglibMapper && Objects.equals(this._mtds, ((TaglibMapper)o)._mtds) && Objects.equals(this._clses, ((TaglibMapper)o)._clses);
    }
}

