/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util.resource.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.zkoss.lang.Library;
import org.zkoss.lang.SystemException;
import org.zkoss.util.FilterMap;
import org.zkoss.util.Locales;
import org.zkoss.util.Maps;
import org.zkoss.util.WaitLock;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.ClassLocator;
import org.zkoss.util.resource.LabelLocator;
import org.zkoss.util.resource.LabelLocator2;
import org.zkoss.xel.Expression;
import org.zkoss.xel.ExpressionFactory;
import org.zkoss.xel.Expressions;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.util.SimpleXelContext;

public class LabelLoader {
    private static final Log log = Log.lookup(LabelLoader.class);
    private Map _labels = Collections.EMPTY_MAP;
    private Map _segLabels = Collections.EMPTY_MAP;
    private final Map _syncLabels = new HashMap(8);
    private final Set _locators = new LinkedHashSet(4);
    private final SimpleXelContext _xelc;
    private String _jarcharset;
    private String _warcharset;
    private final ExpressionFactory _expf;
    private final FilterMap.Filter _fmfilter = new FilterMap.Filter(){

        public Object filter(Object key, Object value) {
            return value instanceof ExValue ? ((ExValue)value).getValue() : value;
        }
    };
    static /* synthetic */ Class class$java$lang$String;

    public LabelLoader() {
        this._expf = Expressions.newExpressionFactory();
        this._xelc = new SimpleXelContext(new Resolver(), null);
    }

    public String getLabel(String key) {
        return this.getLabel(Locales.getCurrent(), key);
    }

    public String getLabel(Locale locale, String key) {
        ExValue exVal;
        Map map = (Map)this._labels.get(locale);
        if (map == null) {
            map = this.loadLabels(locale);
        }
        return (exVal = (ExValue)map.get(key)) != null ? exVal.getValue() : null;
    }

    public Map getSegmentedLabels() {
        return this.getSegmentedLabels(Locales.getCurrent());
    }

    public Map getSegmentedLabels(Locale locale) {
        Map map = (Map)this._segLabels.get(locale);
        if (map != null) {
            return map;
        }
        this.loadLabels(locale);
        return (Map)this._segLabels.get(locale);
    }

    public VariableResolver setVariableResolver(VariableResolver resolv) {
        Resolver resolver = (Resolver)this._xelc.getVariableResolver();
        VariableResolver old = resolver.custom;
        resolver.custom = resolv;
        return old;
    }

    public void register(LabelLocator locator) {
        this.register0(locator);
    }

    public void register(LabelLocator2 locator) {
        this.register0(locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register0(Object locator) {
        if (locator == null) {
            throw new NullPointerException("locator");
        }
        Set set = this._locators;
        synchronized (set) {
            if (!this._locators.add(locator)) {
                log.warning("Replace the old one, because it is replicated: " + locator);
            }
        }
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map map = this._syncLabels;
        synchronized (map) {
            this._syncLabels.clear();
            this._labels = Collections.EMPTY_MAP;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map loadLabels(Locale locale) {
        Map map;
        WaitLock lock = null;
        while (true) {
            Object o;
            map = this._syncLabels;
            synchronized (map) {
                o = this._syncLabels.get(locale);
                if (o == null) {
                    lock = new WaitLock();
                    this._syncLabels.put(locale, lock);
                }
            }
            if (o instanceof Map) {
                return (Map)o;
            }
            if (o == null) break;
            if (((WaitLock)o).waitUntilUnlock(300000)) continue;
            log.warning("Take too long to wait loading labels: " + locale + "\nTry to load again automatically...");
        }
        if (this._jarcharset == null) {
            this._jarcharset = Library.getProperty("org.zkoss.util.label.classpath.charset", "UTF-8");
        }
        if (this._warcharset == null) {
            this._warcharset = Library.getProperty("org.zkoss.util.label.web.charset", null);
            if (this._warcharset == null) {
                this._warcharset = Library.getProperty("org.zkoss.util.label.WEB-INF.charset", "UTF-8");
            }
        }
        try {
            LinkedList locators;
            Object url;
            if (locale != null) {
                log.info("Loading labels for " + locale);
            }
            Map labels = new HashMap(512);
            ClassLocator locator = new ClassLocator();
            Enumeration en = locator.getResources(locale == null ? "metainfo/i3-label.properties" : "metainfo/i3-label_" + locale + ".properties");
            while (en.hasMoreElements()) {
                url = (URL)en.nextElement();
                LabelLoader.load(labels, (URL)url, this._jarcharset);
            }
            url = this._locators;
            synchronized (url) {
                locators = new LinkedList(this._locators);
            }
            Iterator it = locators.iterator();
            while (it.hasNext()) {
                Object o = it.next();
                if (o instanceof LabelLocator) {
                    URL url2 = ((LabelLocator)o).locate(locale);
                    if (url2 == null) continue;
                    LabelLoader.load(labels, url2, this._warcharset);
                    continue;
                }
                LabelLocator2 loc = (LabelLocator2)o;
                InputStream is = loc.locate(locale);
                if (is == null) continue;
                String cs = loc.getCharset();
                LabelLoader.load(labels, is, cs != null ? cs : this._warcharset);
            }
            this.toExValue(labels);
            if (locale != null) {
                String lang = locale.getLanguage();
                String cnty = locale.getCountry();
                String var = locale.getVariant();
                Map superlabels = this.loadLabels(var != null && var.length() > 0 ? new Locale(lang, cnty) : (cnty != null && cnty.length() > 0 ? new Locale(lang, "") : null));
                if (labels.isEmpty()) {
                    labels = superlabels.isEmpty() ? Collections.EMPTY_MAP : superlabels;
                } else if (!superlabels.isEmpty()) {
                    HashMap combined = new HashMap(superlabels);
                    combined.putAll(labels);
                    labels = combined;
                }
            }
            HashMap hashMap = this._syncLabels;
            synchronized (hashMap) {
                this._syncLabels.put(locale, labels);
                this.cloneLables();
            }
            hashMap = labels;
            return hashMap;
        }
        catch (Throwable ex) {
            map = this._syncLabels;
            synchronized (map) {
                this._syncLabels.remove(locale);
                this.cloneLables();
            }
            throw SystemException.Aide.wrap(ex);
        }
        finally {
            lock.unlock();
        }
    }

    private void toExValue(Map labels) {
        if (!labels.isEmpty()) {
            Iterator it = labels.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                me.setValue(new ExValue((String)me.getValue()));
            }
        }
    }

    private void cloneLables() {
        HashMap labels = new HashMap();
        HashMap segLabels = new HashMap();
        Iterator it = this._syncLabels.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            Object value = me.getValue();
            if (!(value instanceof Map)) continue;
            Object key = me.getKey();
            labels.put(key, value);
            segLabels.put(key, this.segment((Map)value));
        }
        this._labels = labels;
        this._segLabels = segLabels;
    }

    private Map segment(Map map) {
        Iterator it = map.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key.indexOf(".") < 0) continue;
            return this.segmentInner(new HashMap(map));
        }
        return new FilterMap(map, this._fmfilter);
    }

    private FilterMap segmentInner(Map map) {
        Map.Entry me;
        HashMap segFound = new HashMap();
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            me = it.next();
            String key = (String)me.getKey();
            Object val = me.getValue();
            int index = key.indexOf(46);
            if (index < 0) continue;
            it.remove();
            String newkey = key.substring(0, index);
            HashMap vals = (HashMap)segFound.get(newkey);
            if (vals == null) {
                vals = new HashMap();
                segFound.put(newkey, vals);
            }
            vals.put(key.substring(index + 1), val);
        }
        it = segFound.entrySet().iterator();
        while (it.hasNext()) {
            Map m;
            me = it.next();
            FilterMap seged = this.segmentInner((Map)me.getValue());
            FilterMap o = map.put(me.getKey(), seged);
            if (o == null || o instanceof Map || (o = (m = seged.getOrigin()).put("$", o)) == null) continue;
            m.put("$", o);
        }
        return new FilterMap(map, this._fmfilter);
    }

    private static final void load(Map labels, URL url, String charset) throws IOException {
        log.info("Opening " + url);
        LabelLoader.load(labels, url.openStream(), charset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void load(Map labels, InputStream is, String charset) throws IOException {
        HashMap news = new HashMap();
        try {
            Maps.load(news, is, charset);
        }
        finally {
            try {
                is.close();
            }
            catch (Throwable ex) {}
        }
        Iterator it = news.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            labels.put(me.getKey(), me.getValue());
        }
    }

    private class Resolver
    implements VariableResolver,
    Serializable {
        private VariableResolver custom;

        private Resolver() {
        }

        public Object resolveVariable(String name) {
            Object o;
            if (this.custom != null && (o = this.custom.resolveVariable(name)) != null) {
                return o;
            }
            return LabelLoader.this.getSegmentedLabels().get(name);
        }
    }

    private class ExValue {
        private Expression _expr;
        private String _val;

        public ExValue(String val) {
            int j = val.indexOf("${");
            if (j >= 0 && val.indexOf(125, j + 2) >= 0) {
                try {
                    this._expr = LabelLoader.this._expf.parseExpression(LabelLoader.this._xelc, val, class$java$lang$String == null ? (class$java$lang$String = LabelLoader.class$("java.lang.String")) : class$java$lang$String);
                    return;
                }
                catch (Throwable ex) {
                    log.error("Illegal expression: " + val, ex);
                }
            }
            this._expr = null;
            this._val = val;
        }

        public String getValue() {
            return this._expr != null ? (String)this._expr.evaluate(LabelLoader.this._xelc) : this._val;
        }
    }
}

