/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.io;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import org.zkoss.util.logging.Log;

public class Serializables {
    public static final Log logio = Log.lookup("org.zkoss.io.serializable");

    private Serializables() {
    }

    public static void smartWrite(ObjectOutputStream s, Map map) throws IOException {
        if (map != null) {
            boolean debug = logio.debugable();
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = it.next();
                Object nm = me.getKey();
                Object val = me.getValue();
                if ((nm instanceof Serializable || nm instanceof Externalizable) && (val == null || val instanceof Serializable || val instanceof Externalizable)) {
                    try {
                        s.writeObject(nm);
                        s.writeObject(val);
                        continue;
                    }
                    catch (NotSerializableException ex) {
                        logio.error("Unable to serialize entry: " + nm + '=' + val);
                        throw ex;
                    }
                }
                if (nm == null || !debug) continue;
                logio.debug("Skip not-serializable entry: " + nm + '=' + val);
            }
        }
        s.writeObject(null);
    }

    public static Map smartRead(ObjectInputStream s, Map map) throws IOException, ClassNotFoundException {
        Object nm;
        while ((nm = s.readObject()) != null) {
            if (map == null) {
                map = new HashMap<Object, Object>();
            }
            map.put(nm, s.readObject());
        }
        return map;
    }

    public static void smartWrite(ObjectOutputStream s, Collection col) throws IOException {
        if (col != null) {
            boolean debug = logio.debugable();
            Iterator it = col.iterator();
            while (it.hasNext()) {
                Object val = it.next();
                if (val instanceof Serializable || val instanceof Externalizable) {
                    try {
                        s.writeObject(val);
                        continue;
                    }
                    catch (NotSerializableException ex) {
                        logio.error("Unable to serialize item: " + val);
                        throw ex;
                    }
                }
                if (val == null || !debug) continue;
                logio.debug("Skip not-serializable item: " + val);
            }
        }
        s.writeObject(null);
    }

    public static Collection smartRead(ObjectInputStream s, Collection col) throws IOException, ClassNotFoundException {
        Object val;
        while ((val = s.readObject()) != null) {
            if (col == null) {
                col = new LinkedList<Object>();
            }
            col.add(val);
        }
        return col;
    }

    public static void smartWrite(ObjectOutputStream s, Object[] ary) throws IOException {
        if (ary != null) {
            boolean debug = logio.debugable();
            for (int j = 0; j < ary.length; ++j) {
                Object val = ary[j];
                if (val instanceof Serializable || val instanceof Externalizable) {
                    try {
                        s.writeObject(val);
                        continue;
                    }
                    catch (NotSerializableException ex) {
                        logio.error("Unable to serialize item: " + val);
                        throw ex;
                    }
                }
                if (val == null || !debug) continue;
                logio.debug("Skip not-serializable item: " + val);
            }
        }
        s.writeObject(null);
    }

    public static void smartWrite(ObjectOutputStream s, Object val) throws IOException {
        boolean bser = val instanceof Serializable || val instanceof Externalizable;
        s.writeObject(bser ? val : null);
        if (!bser && val != null && logio.debugable()) {
            logio.debug("Skip not-serializable object: " + val);
        }
    }
}

