/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.text;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;

public class DateFormats {
    private static final ThreadLocal _df = new ThreadLocal();

    public static final String format(Date d, boolean dateOnly) {
        return DateFormats.getDateFormat(dateOnly).format(d);
    }

    public static final Date parse(String s, boolean dateOnly) throws ParseException {
        return DateFormats.getDateFormat(dateOnly).parse(s);
    }

    private static final DateFormat getDateFormat(boolean dateOnly) {
        Locale locale = Locales.getCurrent();
        return dateOnly ? DateFormat.getDateInstance(2, locale) : DateFormat.getDateTimeInstance(2, 2, locale);
    }

    public static final Date parse(String s) throws ParseException {
        Locale locale = Locales.getCurrent();
        if (s.indexOf(58) < 0) {
            return DateFormats.getDateFormat(true).parse(s);
        }
        try {
            return DateFormats.getHttpDateFormat().parse(s);
        }
        catch (ParseException parseException) {
            return DateFormats.getDateFormat(false).parse(s);
        }
    }

    private static final SimpleDateFormat getHttpDateFormat() {
        SimpleDateFormat df = (SimpleDateFormat)_df.get();
        if (df == null) {
            df = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
            _df.set(df);
        }
        df.setTimeZone(TimeZones.getCurrent());
        return df;
    }
}

