/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.io;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import org.zkoss.io.FileReader;
import org.zkoss.io.Repeatable;

class RepeatableFileReader
extends Reader
implements Repeatable {
    private final File _file;
    private Reader _in;
    private final String _charset;

    RepeatableFileReader(File file, String charset) {
        this._file = file;
        this._charset = charset != null ? charset : "UTF-8";
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this._in == null) {
            this._in = new FileReader(this._file, this._charset);
        }
        return this._in.read(cbuf, off, len);
    }

    public void close() throws IOException {
        if (this._in != null) {
            this._in.close();
            this._in = null;
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }
}

