/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.text;

import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.zkoss.util.Locales;

public class DateFormats {
    private static final ThreadLocal _df = new ThreadLocal();

    public static final Date parse(String s) throws ParseException {
        Locale locale = Locales.getCurrent();
        if (s.indexOf(58) < 0) {
            DateFormat df = DateFormat.getDateInstance(2, locale);
            return df.parse(s);
        }
        try {
            return DateFormats.getDateFormat().parse(s);
        }
        catch (ParseException ex) {
            DateFormat df = DateFormat.getDateTimeInstance(2, 2, locale);
            return df.parse(s);
        }
    }

    private static final SimpleDateFormat getDateFormat() {
        SimpleDateFormat df = (SimpleDateFormat)_df.get();
        if (df == null) {
            df = new SimpleDateFormat("EEE MMM dd HH:mm:ss zzz yyyy", Locale.US);
            _df.set(df);
        }
        return df;
    }

    public static final String format(Date d, boolean dateOnly) {
        Locale locale = Locales.getCurrent();
        if (dateOnly) {
            DateFormat df = DateFormat.getDateInstance(2, locale);
            return df.format(d);
        }
        DateFormat df = DateFormat.getDateTimeInstance(2, 2, locale);
        return df.format(d);
    }
}

