/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class FilterMap
extends AbstractMap {
    private final Map _map;
    private final Filter _filter;

    public FilterMap(Map map, Filter filter) {
        if (map == null || filter == null) {
            throw new IllegalArgumentException("null");
        }
        this._map = map;
        this._filter = filter;
    }

    public Map getOrigin() {
        return this._map;
    }

    public Object get(Object key) {
        return this._filter.filter(key, this._map.get(key));
    }

    public boolean containsKey(Object key) {
        return this._map.containsKey(key);
    }

    public Set entrySet() {
        return new EntrySet();
    }

    public String toString() {
        return this._map.toString();
    }

    public int hashCode() {
        return this._map.hashCode();
    }

    public boolean equals(Object o) {
        FilterMap fm;
        return o instanceof FilterMap && this._map.equals(fm = (FilterMap)o) && this._filter.equals(fm._filter);
    }

    public static interface Filter {
        public Object filter(Object var1, Object var2);
    }

    private class Entry
    implements Map.Entry {
        private final Map.Entry _me;

        private Entry(Map.Entry me) {
            this._me = me;
        }

        public Object getKey() {
            return this._me.getKey();
        }

        public Object getValue() {
            return FilterMap.this._filter.filter(this._me.getKey(), this._me.getValue());
        }

        public Object setValue(Object value) {
            throw new UnsupportedOperationException("readonly");
        }

        public String toString() {
            return this._me.toString();
        }

        public int hashCode() {
            return this._me.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof Entry && this._me.equals(((Entry)o)._me);
        }
    }

    private class EntryIter
    implements Iterator {
        private final Iterator _it;

        private EntryIter(Iterator it) {
            this._it = it;
        }

        public boolean hasNext() {
            return this._it.hasNext();
        }

        public Object next() {
            return new Entry((Map.Entry)this._it.next());
        }

        public void remove() {
            throw new UnsupportedOperationException("readonly");
        }

        public String toString() {
            return this._it.toString();
        }

        public int hashCode() {
            return this._it.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof EntryIter && this._it.equals(((EntryIter)o)._it);
        }
    }

    private class EntrySet
    extends AbstractSet {
        private final Set _set;

        private EntrySet() {
            this._set = FilterMap.this._map.entrySet();
        }

        public boolean contains(Object o) {
            return o instanceof Entry && this._set.contains(((Entry)o)._me);
        }

        public int size() {
            return FilterMap.this._map.size();
        }

        public Iterator iterator() {
            return new EntryIter(this._set.iterator());
        }

        public String toString() {
            return this._set.toString();
        }

        public int hashCode() {
            return this._set.hashCode();
        }

        public boolean equals(Object o) {
            return o instanceof EntrySet && this._set.equals(((EntrySet)o)._set);
        }
    }
}

