/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.lang;

import org.zkoss.mesg.MCommon;
import org.zkoss.util.IllegalSyntaxException;

public class Strings {
    public static final String ESCAPE_JAVASCRIPT = "'\n\r\t\f\\/!";

    public static final boolean isEmpty(String s) {
        return s == null || s.length() == 0;
    }

    public static final boolean isBlank(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static final StringBuffer trim(StringBuffer buf, int index) {
        int j = index;
        int len = buf.length();
        block0: while (true) {
            if (j >= len) {
                buf.delete(index, len);
                break;
            }
            char cc = buf.charAt(j);
            if (cc > ' ') {
                buf.delete(index, j);
                len = j = buf.length();
                while (--j >= index) {
                    cc = buf.charAt(j);
                    if (cc <= ' ') continue;
                    buf.delete(j + 1, len);
                    break block0;
                }
                break;
            }
            ++j;
        }
        return buf;
    }

    public static final StringBuffer encode(StringBuffer sb, int val) {
        if (val < 0) {
            sb.append('z');
            val = -val;
        }
        do {
            int v;
            if ((v = val & 0x1F) < 10) {
                sb.append((char)(48 + v));
                continue;
            }
            sb.append((char)(v + 87));
        } while ((val >>>= 5) != 0);
        return sb;
    }

    public static final StringBuffer encode(StringBuffer sb, long val) {
        if (val < 0L) {
            sb.append('z');
            val = -val;
        }
        do {
            int v;
            if ((v = (int)val & 0x1F) < 10) {
                sb.append((char)(48 + v));
                continue;
            }
            sb.append((char)(v + 87));
        } while ((val >>>= 5) != 0L);
        return sb;
    }

    public static final String encode(int val) {
        return Strings.encode(new StringBuffer(12), val).toString();
    }

    public static final String encode(long val) {
        return Strings.encode(new StringBuffer(20), val).toString();
    }

    public static final int indexOf(StringBuffer sb, char cc, int j) {
        int len = sb.length();
        while (j < len) {
            if (sb.charAt(j) == cc) {
                return j;
            }
            ++j;
        }
        return -1;
    }

    public static final int lastIndexOf(StringBuffer sb, char cc, int j) {
        if (j >= sb.length()) {
            j = sb.length() - 1;
        }
        while (j >= 0) {
            if (sb.charAt(j) == cc) {
                return j;
            }
            --j;
        }
        return -1;
    }

    public static final int anyOf(String src, String delimiters, int from) {
        switch (delimiters.length()) {
            case 0: {
                return src.length();
            }
            case 1: {
                int j = src.indexOf(delimiters.charAt(0), from);
                return j >= 0 ? j : src.length();
            }
        }
        int len = src.length();
        while (from < len && delimiters.indexOf(src.charAt(from)) < 0) {
            ++from;
        }
        return from;
    }

    public static final int lastAnyOf(String src, String delimiters, int from) {
        switch (delimiters.length()) {
            case 0: {
                return -1;
            }
            case 1: {
                return src.lastIndexOf(delimiters.charAt(0), from);
            }
        }
        int len = src.length();
        if (from >= len) {
            from = len - 1;
        }
        while (from >= 0 && delimiters.indexOf(src.charAt(from)) < 0) {
            --from;
        }
        return from;
    }

    public static final int skipWhitespaces(CharSequence src, int from) {
        int len = src.length();
        while (from < len && Character.isWhitespace(src.charAt(from))) {
            ++from;
        }
        return from;
    }

    public static final int skipWhitespacesBackward(CharSequence src, int from) {
        int len = src.length();
        if (from >= len) {
            from = len - 1;
        }
        while (from >= 0 && Character.isWhitespace(src.charAt(from))) {
            --from;
        }
        return from;
    }

    public static final int nextWhitespace(CharSequence src, int from) {
        int len = src.length();
        while (from < len && !Character.isWhitespace(src.charAt(from))) {
            ++from;
        }
        return from;
    }

    public static final String escape(String src, String specials) {
        if (src == null) {
            return null;
        }
        StringBuffer sb = null;
        int j = 0;
        int j2 = 0;
        int len = src.length();
        block0: while (true) {
            String enc = null;
            for (int k = j2; k < len; ++k) {
                char cc = src.charAt(k);
                if (Strings.shallEncodeUnicode(cc, specials)) {
                    enc = Strings.encodeUnicode(cc);
                } else if (specials.indexOf(cc) < 0) {
                    continue;
                }
                if (enc == null && (cc = Strings.escapeSpecial(src, cc, k, specials)) == '\u0000') {
                    j2 = k + 1;
                    continue block0;
                }
                if (sb == null) {
                    sb = new StringBuffer(len + 4);
                }
                sb.append(src.substring(j, k)).append('\\');
                if (enc != null) {
                    sb.append(enc);
                } else {
                    sb.append(cc);
                }
                j2 = j = k + 1;
                continue block0;
            }
            break;
        }
        if (sb == null) {
            return src;
        }
        return sb.append(src.substring(j)).toString();
    }

    private static char escapeSpecial(CharSequence src, char cc, int k, String specials) {
        switch (cc) {
            case '\n': {
                return 'n';
            }
            case '\t': {
                return 't';
            }
            case '\r': {
                return 'r';
            }
            case '\f': {
                return 'f';
            }
            case '/': {
                if (specials != ESCAPE_JAVASCRIPT || k > 0 && src.charAt(k - 1) == '<' && k + 8 <= src.length() && "script>".equalsIgnoreCase(src.subSequence(k + 1, k + 8).toString())) break;
                return '\u0000';
            }
            case '!': {
                if (specials != ESCAPE_JAVASCRIPT || k > 0 && src.charAt(k - 1) == '<' && k + 3 <= src.length() && "--".equals(src.subSequence(k + 1, k + 3))) break;
                return '\u0000';
            }
        }
        return cc;
    }

    public static final StringBuffer appendEscape(StringBuffer sb, String src, String specials) {
        return Strings.escape(sb, src, specials);
    }

    public static final StringBuffer escape(StringBuffer dst, CharSequence src, String specials) {
        if (src == null) {
            return dst;
        }
        int j = 0;
        int j2 = 0;
        int len = src.length();
        while (true) {
            char cc;
            String enc = null;
            int k = j2;
            while (true) {
                if (k >= len) {
                    return dst.append((Object)src.subSequence(j, src.length()));
                }
                cc = src.charAt(k);
                if (Strings.shallEncodeUnicode(cc, specials)) {
                    enc = Strings.encodeUnicode(cc);
                    break;
                }
                if (specials.indexOf(cc) >= 0) break;
                ++k;
            }
            if (enc == null && (cc = Strings.escapeSpecial(src, cc, k, specials)) == '\u0000') {
                j2 = k + 1;
                continue;
            }
            dst.append((Object)src.subSequence(j, k)).append('\\');
            if (enc != null) {
                dst.append(enc);
            } else {
                dst.append(cc);
            }
            j2 = j = k + 1;
        }
    }

    private static final boolean shallEncodeUnicode(char cc, String specials) {
        return specials == ESCAPE_JAVASCRIPT && cc > '\u00ff' && !Character.isLetterOrDigit(cc);
    }

    private static final String encodeUnicode(int cc) {
        StringBuffer sb = new StringBuffer(6).append('u').append(Integer.toHexString(cc));
        while (sb.length() < 5) {
            sb.insert(1, '0');
        }
        return sb.toString();
    }

    public static final String unescape(String s) {
        int k;
        if (s == null) {
            return null;
        }
        StringBuffer sb = null;
        int j = 0;
        while ((k = s.indexOf(92, j)) >= 0) {
            if (sb == null) {
                sb = new StringBuffer(s.length());
            }
            char cc = s.charAt(k + 1);
            switch (cc) {
                case 'n': {
                    cc = '\n';
                    break;
                }
                case 't': {
                    cc = '\t';
                    break;
                }
                case 'r': {
                    cc = '\r';
                    break;
                }
                case 'f': {
                    cc = '\f';
                }
            }
            sb.append(s.substring(j, k)).append(cc);
            j = k + 2;
        }
        if (sb == null) {
            return s;
        }
        return sb.append(s.substring(j)).toString();
    }

    public static final Result substring(String src, int from, char until) {
        return Strings.substring(src, from, until, true);
    }

    /*
     * Unable to fully structure code
     */
    public static final Result substring(String src, int from, char until, boolean escBackslash) {
        len = src.length();
        sb = new StringBuffer(len);
        quoted = false;
        while (from < len) {
            block9: {
                cc = src.charAt(from);
                if (!quoted) break block9;
                quoted = false;
                switch (cc) {
                    case 'f': {
                        cc = '\f';
                        break;
                    }
                    case 'n': {
                        cc = '\n';
                        break;
                    }
                    case 'r': {
                        cc = '\r';
                        break;
                    }
                    case 't': {
                        cc = '\t';
                    }
                }
                ** GOTO lbl-1000
            }
            if (cc == until) break;
            if (escBackslash && cc == '\\') {
                quoted = true;
            } else lbl-1000:
            // 2 sources

            {
                sb.append(cc);
            }
            ++from;
        }
        return new Result(from, sb.toString(), from < len ? until : '\u0000');
    }

    public static final Result nextToken(String src, int from, char[] separators) throws IllegalSyntaxException {
        return Strings.nextToken(src, from, separators, true, true, false);
    }

    public static final Result nextToken(String src, int from, char[] separators, boolean escBackslash, boolean quotAsToken) throws IllegalSyntaxException {
        return Strings.nextToken(src, from, separators, escBackslash, quotAsToken, false);
    }

    public static final Result nextToken(String src, int from, char[] separators, boolean escBackslash, boolean quotAsToken, boolean parenthesis) throws IllegalSyntaxException {
        int j;
        int len = src.length();
        if ((from = Strings.skipWhitespaces(src, from)) >= len) {
            return null;
        }
        char cc = src.charAt(from);
        if (quotAsToken && (cc == '\'' || cc == '\"')) {
            Result res = Strings.substring(src, from + 1, cc, escBackslash);
            if (res.separator != cc) {
                throw new IllegalSyntaxException(MCommon.QUOTE_UNMATCHED, src);
            }
            res.next = Strings.skipWhitespaces(src, res.next + 1);
            if (res.next < len && Strings.isSeparator(src.charAt(res.next), separators)) {
                ++res.next;
            }
            return res;
        }
        int next = j = Strings.nextSeparator(src, from, separators, escBackslash, false, quotAsToken, parenthesis);
        if (j < len) {
            if (quotAsToken) {
                char c = src.charAt(j);
                if (c != '\'' && c != '\"') {
                    ++next;
                }
            } else {
                ++next;
            }
        }
        if (j == from) {
            return new Result(next, "", src.charAt(j));
        }
        int k = 1 + Strings.skipWhitespacesBackward(src, j - 1);
        return new Result(next, k > from ? (escBackslash ? Strings.unescape(src.substring(from, k)) : src.substring(from, k)) : "", j < len ? src.charAt(j) : (char)'\u0000');
    }

    public static int nextSeparator(String src, int from, char[] separators, boolean escBackslash, boolean escQuot, boolean quotAsSeparator) {
        return Strings.nextSeparator(src, from, separators, escBackslash, escQuot, quotAsSeparator, false);
    }

    public static int nextSeparator(String src, int from, char[] separators, boolean escBackslash, boolean escQuot, boolean quotAsSeparator, boolean parenthesis) {
        boolean esc = false;
        char quot = '\u0000';
        int len = src.length();
        while (from < len) {
            if (esc) {
                esc = false;
            } else {
                char endparen;
                char cc = src.charAt(from);
                if (escBackslash && cc == '\\') {
                    esc = true;
                } else if (quot != '\u0000') {
                    if (cc == quot) {
                        quot = '\u0000';
                    }
                } else if (escQuot && (cc == '\'' || cc == '\"')) {
                    quot = cc;
                } else if (quotAsSeparator && (cc == '\'' || cc == '\"') || Strings.isSeparator(cc, separators) || parenthesis && (endparen = Strings.getEndingParenthesis(cc)) != '\u0000' && (from = Strings.skipParenthesis(src, from, cc, endparen)) >= len) break;
            }
            ++from;
        }
        return from;
    }

    private static final char getEndingParenthesis(char cc) {
        return (char)(cc == '{' ? 125 : (cc == '(' ? 41 : (cc == '[' ? 93 : 0)));
    }

    private static int skipParenthesis(String src, int j, char beg, char end) {
        int len = src.length();
        int depth = 0;
        while (++j < len) {
            char cc = src.charAt(j);
            if (cc == '\\') {
                ++j;
                continue;
            }
            if (cc == beg) {
                ++depth;
                continue;
            }
            if (cc != end || --depth >= 0) continue;
            break;
        }
        return j;
    }

    private static final boolean isSeparator(char cc, char[] separators) {
        for (int j = 0; j < separators.length; ++j) {
            if (cc != separators[j] && (separators[j] != ' ' || !Character.isWhitespace(cc))) continue;
            return true;
        }
        return false;
    }

    public static class Result {
        public int next;
        public String token;
        public char separator;

        protected Result(int next, String token, char separator) {
            this.next = next;
            this.token = token;
            this.separator = separator;
        }

        protected Result(int next, char separator) {
            this.next = next;
            this.separator = separator;
        }

        public String toString() {
            return "[next=" + this.next + ", token=" + this.token + " separator=" + this.separator + ']';
        }
    }
}

