/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.idom.impl;

import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;
import org.zkoss.idom.DOMException;
import org.zkoss.idom.Document;
import org.zkoss.idom.Group;
import org.zkoss.idom.Item;
import org.zkoss.idom.Namespaceable;
import org.zkoss.idom.impl.DOMImplementation;
import org.zkoss.idom.impl.EmptyNamedNodeMap;
import org.zkoss.xml.Locator;
import org.zkoss.xml.Nodes;

public abstract class AbstractItem
implements Item,
Node,
Serializable,
Cloneable {
    private static final long serialVersionUID = 20060622L;
    private Group _parent;
    private Locator _loc;
    private Map _usrdta;
    static final /* synthetic */ boolean $assertionsDisabled;

    protected AbstractItem() {
    }

    protected static boolean match(Namespaceable vtx, String namespace, String name, Pattern ptn, int mode) {
        String val;
        if (name != null) {
            String string = val = (mode & 4) != 0 ? vtx.getTagName() : vtx.getLocalName();
            if ((mode & 1) != 0 ? !ptn.matcher(val).matches() : ((mode & 2) != 0 ? !name.equalsIgnoreCase(val) : !name.equals(val))) {
                return false;
            }
        }
        if (namespace != null) {
            String string = val = (mode & 8) != 0 ? vtx.getNamespace().getPrefix() : vtx.getNamespace().getURI();
            if (!namespace.equals(val)) {
                return false;
            }
        }
        return true;
    }

    public boolean isReadonly() {
        return false;
    }

    public void setReadonly(boolean readonly) {
    }

    public boolean isModified() {
        return false;
    }

    public void clearModified(boolean includingDescendant) {
    }

    public void setModified() {
    }

    public void setName(String name) {
        throw new DOMException(15, this._loc);
    }

    public String getText() {
        return null;
    }

    public void setText(String text) {
        throw new DOMException(15, this._loc);
    }

    public Document getDocument() {
        for (Group v = this._parent; v != null; v = v.getParent()) {
            if (!(v instanceof Document)) continue;
            return (Document)v;
        }
        return null;
    }

    public Item detach() {
        if (this._parent != null) {
            this._parent.getChildren().remove(this);
            if (!$assertionsDisabled && this._parent != null) {
                throw new AssertionError();
            }
        }
        return this;
    }

    public Item clone(boolean reserved) {
        return (Item)this.clone();
    }

    public final Group getParent() {
        return this._parent;
    }

    public void setParent(Group parent) {
        this._parent = parent;
    }

    public final Locator getLocator() {
        return this._loc;
    }

    public final void setLocator(Locator loc) {
        this._loc = loc;
    }

    public String getNodeName() {
        return this.getName();
    }

    public String getNodeValue() {
        return this.getText();
    }

    public void setNodeValue(String nodeValue) {
        this.setText(nodeValue);
    }

    public org.w3c.dom.Document getOwnerDocument() {
        return this.getDocument();
    }

    public final Node cloneNode(boolean deep) {
        if (!deep) {
            throw new DOMException(9, "always deep", this._loc);
        }
        return (Node)this.clone();
    }

    public final Node getParentNode() {
        return (Node)((Object)this.getParent());
    }

    public final Node getPreviousSibling() {
        if (this._parent == null) {
            return null;
        }
        List list = this._parent.getChildren();
        int j = list.indexOf(this);
        if (j < 0) {
            throw new DOMException(3, "internal error", this._loc);
        }
        return j == 0 ? null : (Node)list.get(j - 1);
    }

    public final Node getNextSibling() {
        if (this._parent == null) {
            return null;
        }
        List list = this._parent.getChildren();
        int j = list.indexOf(this);
        if (j < 0) {
            throw new DOMException(3, "internal error", this._loc);
        }
        return j == list.size() - 1 ? null : (Node)list.get(j + 1);
    }

    public NodeList getChildNodes() {
        return Nodes.EMPTY_NODELIST;
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public boolean hasChildNodes() {
        return false;
    }

    public Node insertBefore(Node newChild, Node refChild) {
        throw new DOMException(3, this._loc);
    }

    public Node replaceChild(Node newChild, Node oldChild) {
        throw new DOMException(3, this._loc);
    }

    public Node removeChild(Node oldChild) {
        throw new DOMException(3, this._loc);
    }

    public Node appendChild(Node newChild) {
        throw new DOMException(3, this._loc);
    }

    public final void normalize() {
        throw new DOMException(9, this._loc);
    }

    public final boolean isSupported(String feature, String version) {
        return DOMImplementation.THE.hasFeature(feature, version);
    }

    public String getNamespaceURI() {
        return null;
    }

    public String getPrefix() {
        return null;
    }

    public String getLocalName() {
        return this.getName();
    }

    public void setPrefix(String prefix) {
        throw new DOMException(15, this._loc);
    }

    public NamedNodeMap getAttributes() {
        return EmptyNamedNodeMap.THE;
    }

    public boolean hasAttributes() {
        return false;
    }

    public String getBaseURI() {
        return null;
    }

    public short compareDocumentPosition(Node other) throws DOMException {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    public String getTextContent() throws DOMException {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    public void setTextContent(String textContent) throws DOMException {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    public boolean isSameNode(Node other) {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    public String lookupPrefix(String namespaceURI) {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    public boolean isDefaultNamespace(String namespaceURI) {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    public String lookupNamespaceURI(String prefix) {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    public boolean isEqualNode(Node arg) {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    public Object getFeature(String feature, String version) {
        return null;
    }

    public Object setUserData(String key, Object data, UserDataHandler handler) {
        if (handler != null) {
            throw new UnsupportedOperationException("DOM Level 3");
        }
        if (this._usrdta == null) {
            this._usrdta = new LinkedHashMap();
        }
        return this._usrdta.put(key, data);
    }

    public Object getUserData(String key) {
        return this._usrdta != null ? this._usrdta.get(key) : null;
    }

    public final boolean equals(Object o) {
        return this == o;
    }

    public final int hashCode() {
        return super.hashCode();
    }

    public Object clone() {
        try {
            AbstractItem v = (AbstractItem)super.clone();
            v._parent = null;
            return v;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError();
        }
    }

    static {
        $assertionsDisabled = !AbstractItem.class.desiredAssertionStatus();
    }
}

