/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.idom;

import org.w3c.dom.Attr;
import org.w3c.dom.TypeInfo;
import org.zkoss.idom.Attributable;
import org.zkoss.idom.DOMException;
import org.zkoss.idom.Document;
import org.zkoss.idom.Element;
import org.zkoss.idom.Item;
import org.zkoss.idom.Namespace;
import org.zkoss.idom.Namespaceable;
import org.zkoss.idom.Verifier;
import org.zkoss.idom.impl.AbstractItem;
import org.zkoss.lang.Objects;

public class Attribute
extends AbstractItem
implements Namespaceable,
Attr {
    protected Namespace _ns;
    protected Item _owner;
    protected String _lname;
    protected String _value;
    static final /* synthetic */ boolean $assertionsDisabled;

    public Attribute(String nsURI, String tname, String value) {
        int kp = tname.indexOf(58);
        String prefix = kp >= 0 ? tname.substring(0, kp) : "";
        String lname = kp >= 0 ? tname.substring(kp + 1) : tname;
        this.setNamespace(prefix, nsURI);
        this.setLocalName(lname);
        this.setValue(value);
    }

    public Attribute(Namespace ns, String lname, String value) {
        this.setNamespace(ns);
        this.setLocalName(lname);
        this.setValue(value);
    }

    public Attribute(String lname, String value) {
        this(Namespace.NO_NAMESPACE, lname, value);
    }

    protected Attribute() {
        this._ns = Namespace.NO_NAMESPACE;
    }

    public final String getValue() {
        return this._value;
    }

    public final void setValue(String value) {
        if (value == null) {
            value = "";
        }
        if (!Objects.equals(this._value, value)) {
            Verifier.checkCharacterData(value, this.getLocator());
            this._value = value;
        }
    }

    public final Item getOwner() {
        return this._owner;
    }

    public final void setOwner(Item owner) {
        if (this._owner != owner) {
            this._ns = Attribute.reuseNamespace(owner, this._ns);
            this._owner = owner;
        }
    }

    private static Namespace reuseNamespace(Item owner, Namespace ns) {
        if (ns.getPrefix().length() > 0 && owner instanceof Element) {
            Namespace found = ((Element)owner).getNamespace(ns.getPrefix());
            if (found == null) {
                throw new DOMException(14, "Attribute's namespace, " + ns + ", not found in element");
            }
            if (!ns.equals(found)) {
                throw new DOMException(14, "Attribute's namespace, " + ns + ", conflicts with element's, " + found);
            }
            return found;
        }
        return ns;
    }

    public final void setNamespace(String prefix, String nsURI) {
        this.setNamespace(!(prefix != null && prefix.length() != 0 || nsURI != null && nsURI.length() != 0) ? null : new Namespace(prefix, nsURI));
    }

    public final void setNamespace(Namespace ns) {
        if (ns != null && ns.getPrefix().length() == 0 && ns.getURI().length() != 0) {
            throw new DOMException(14, "Attribute's namespace without a prefix cannot have URI", this.getLocator());
        }
        ns = ns == null || ns.getPrefix().length() == 0 ? Namespace.NO_NAMESPACE : Attribute.reuseNamespace(this._owner, ns);
        this._ns = ns;
    }

    public final Namespace getNamespace() {
        return this._ns;
    }

    public final String getTagName() {
        return this._ns.tagNameOf(this._lname);
    }

    public final void setTagName(String tname) {
        if (!Objects.equals(tname, this.getName())) {
            int kp = tname.indexOf(58);
            String prefix = kp >= 0 ? tname.substring(0, kp) : "";
            String lname = kp >= 0 ? tname.substring(kp + 1) : tname;
            this.setPrefix(prefix);
            this.setLocalName(lname);
        }
    }

    public final String getLocalName() {
        return this._lname;
    }

    public final void setLocalName(String lname) {
        if (!Objects.equals(lname, this.getLocalName())) {
            Verifier.checkAttributeName(lname, this.getLocator());
            this._lname = lname;
        }
    }

    public final String getName() {
        return this.getTagName();
    }

    public final void setName(String tname) {
        this.setTagName(tname);
    }

    public final String getText() {
        return this.getValue();
    }

    public final void setText(String text) {
        this.setValue(text);
    }

    public final Document getDocument() {
        return this._owner != null ? this._owner.getDocument() : null;
    }

    public Item detach() {
        if (this._owner != null) {
            ((Attributable)((Object)this._owner)).getAttributeItems().remove(this);
            if (!$assertionsDisabled && this._owner != null) {
                throw new AssertionError();
            }
        }
        return this;
    }

    public void setParent(Item parent) {
        throw new DOMException(15, "Attributes do not have parent", this.getLocator());
    }

    public final short getNodeType() {
        return 2;
    }

    public final org.w3c.dom.Document getOwnerDocument() {
        return this.getDocument();
    }

    public final String getNamespaceURI() {
        return this._ns.getURI();
    }

    public final String getPrefix() {
        return this._ns.getPrefix();
    }

    public final void setPrefix(String prefix) {
        this.setNamespace(prefix, this._ns.getURI());
    }

    public TypeInfo getSchemaTypeInfo() {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    public boolean isId() {
        throw new UnsupportedOperationException("DOM Level 3");
    }

    public final boolean getSpecified() {
        return false;
    }

    public final org.w3c.dom.Element getOwnerElement() {
        return (org.w3c.dom.Element)((Object)this.getOwner());
    }

    public final String toString() {
        return "[Attribute: " + this.getTagName() + "=\"" + this._value + "\"]";
    }

    public Object clone() {
        Attribute v = (Attribute)super.clone();
        v._owner = null;
        return v;
    }

    static {
        $assertionsDisabled = !Attribute.class.desiredAssertionStatus();
    }
}

