/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.idom.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.transform.Result;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.stream.StreamResult;
import org.zkoss.idom.Attribute;
import org.zkoss.idom.Document;
import org.zkoss.idom.Element;
import org.zkoss.idom.Group;
import org.zkoss.idom.Item;
import org.zkoss.idom.Text;
import org.zkoss.idom.transform.Transformer;
import org.zkoss.lang.Classes;
import org.zkoss.lang.Objects;
import org.zkoss.mesg.MCommon;
import org.zkoss.util.IllegalSyntaxException;
import org.zkoss.util.logging.Log;

public class IDOMs {
    private static final Log log = Log.lookup(IDOMs.class);

    public static final Element getRequiredElement(Element e, String elemnm) throws IllegalSyntaxException {
        Element sub = e.getElement(elemnm);
        if (sub == null) {
            throw new IllegalSyntaxException(MCommon.XML_ELEMENT_REQUIRED, new Object[]{elemnm, e.getLocator()});
        }
        return sub;
    }

    public static final String getRequiredElementValue(Element e, String elemnm) throws IllegalSyntaxException {
        Element sub = e.getElement(elemnm);
        if (sub == null) {
            throw new IllegalSyntaxException(MCommon.XML_ELEMENT_REQUIRED, new Object[]{elemnm, e.getLocator()});
        }
        return sub.getText(true);
    }

    public static final String getRequiredAttributeValue(Element e, String attrnm) throws IllegalSyntaxException {
        Attribute attr = e.getAttributeItem(attrnm);
        if (attr == null) {
            throw new IllegalSyntaxException(MCommon.XML_ATTRIBUTE_REQUIRED, new Object[]{attrnm, e.getLocator()});
        }
        return attr.getValue();
    }

    public static final Element getFirstElement(Group group) {
        Iterator it = group.getElements().iterator();
        return it.hasNext() ? (Element)it.next() : null;
    }

    public static final Element findElement(List elems, String name) {
        Iterator it = elems.iterator();
        while (it.hasNext()) {
            Element e = (Element)it.next();
            if (!Objects.equals(name, e.getElementValue("name", true))) continue;
            return e;
        }
        return null;
    }

    public static final Map parseParams(Element elm, String type, String name, String value) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Iterator it = elm.getElements(type).iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            String nm = IDOMs.getRequiredElementValue(el, name);
            String val = IDOMs.getRequiredElementValue(el, value);
            map.put(nm, val);
        }
        return map;
    }

    public static void format(Element e) {
        boolean elemFound = true;
        ListIterator<Text> it = e.getChildren().listIterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (o instanceof Element) {
                if (elemFound) {
                    it.previous();
                    it.add(new Text("\n\t"));
                    it.next();
                } else {
                    elemFound = true;
                }
                IDOMs.format((Element)o);
                continue;
            }
            elemFound = false;
        }
    }

    public static final Object toContents(Object obj) {
        if (obj instanceof Collection) {
            Collection c = (Collection)obj;
            boolean cvted = false;
            LinkedList<Object> rets = new LinkedList<Object>();
            Iterator it = c.iterator();
            while (it.hasNext()) {
                Object o2;
                Object o = it.next();
                if (o != (o2 = IDOMs.toContents(o))) {
                    cvted = true;
                }
                rets.add(o2);
            }
            if (cvted) {
                return rets;
            }
        } else if (obj instanceof Object[]) {
            Object[] ary = (Object[])obj;
            boolean cvted = false;
            Object[] rets = new Object[ary.length];
            for (int j = 0; j < ary.length; ++j) {
                Object o2 = IDOMs.toContents(ary[j]);
                if (ary[j] != o2) {
                    cvted = true;
                }
                rets[j] = o2;
            }
            if (cvted) {
                return rets;
            }
        } else if (obj instanceof Element) {
            return ((Element)obj).getContent();
        }
        return obj;
    }

    public static final void setContents(Collection elems, Object val) {
        Object[] ary = null;
        ary = val instanceof Object[] ? (Object[])val : (val instanceof Collection ? ((Collection)val).toArray() : new Object[]{val});
        Iterator it = elems.iterator();
        int j = 0;
        while (it.hasNext()) {
            ((Element)it.next()).setContent(j < ary.length ? ary[j] : null);
            ++j;
        }
    }

    public static final String toString(Document doc) throws TransformerConfigurationException, TransformerException {
        StringWriter writer = new StringWriter();
        new Transformer().transform(doc, (Result)new StreamResult(writer));
        return writer.toString();
    }

    public static final void dumpTree(Group group) {
        IDOMs.dumpTree(System.out, group);
    }

    public static final void dumpTree(PrintStream s, Group group) {
        IDOMs.dumpTree(new PrintWriter(s, true), group);
    }

    public static final void dumpTree(PrintWriter s, Group group) {
        IDOMs.dumpTree(s, group, "");
    }

    private static final void dumpTree(PrintWriter s, Item vtx, String prefix) {
        s.print(prefix);
        s.print(vtx);
        if (vtx instanceof Group) {
            prefix = prefix + "  ";
            Iterator it = ((Group)vtx).getChildren().iterator();
            while (it.hasNext()) {
                IDOMs.dumpTree(s, (Item)it.next(), prefix);
            }
        }
    }

    public static boolean checkVersion(Document doc, URL url) throws Exception {
        Element el = doc.getRootElement().getElement("version");
        if (el != null) {
            Class cls;
            Field fld;
            String uidInClass;
            String clsnm = IDOMs.getRequiredElementValue(el, "version-class");
            String uid = IDOMs.getRequiredElementValue(el, "version-uid");
            if (uid.equals(uidInClass = (String)(fld = (cls = Classes.forNameByThread(clsnm)).getField("UID")).get(null))) {
                return true;
            }
            log.info("Ignore " + url + "\nCause: version not matched; expected=" + uidInClass + ", xml=" + uid);
            return false;
        }
        return true;
    }
}

