/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.xel.taglib;

import java.lang.reflect.Method;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.zkoss.idom.Document;
import org.zkoss.idom.Element;
import org.zkoss.idom.input.SAXBuilder;
import org.zkoss.idom.util.IDOMs;
import org.zkoss.lang.Classes;
import org.zkoss.util.IllegalSyntaxException;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.AbstractLoader;
import org.zkoss.util.resource.ClassLocator;
import org.zkoss.util.resource.Locator;
import org.zkoss.util.resource.ResourceCache;
import org.zkoss.xel.Function;
import org.zkoss.xel.FunctionMapper;
import org.zkoss.xel.XelException;
import org.zkoss.xel.taglib.Taglib;
import org.zkoss.xel.util.MethodFunction;
import org.zkoss.xel.util.TaglibMapper;

public class Taglibs {
    private static final Log log = Log.lookup(Taglibs.class);
    private static final ResourceCache _reces;
    private static Map _defURLs;

    public static final FunctionMapper getFunctionMapper(List taglibs, Map imports, Locator loc) {
        return Taglibs.getFunctionMapper((Collection)taglibs, imports, null, loc);
    }

    public static final FunctionMapper getFunctionMapper(Collection taglibs, Map imports, Locator loc) {
        return Taglibs.getFunctionMapper(taglibs, imports, null, loc);
    }

    public static final FunctionMapper getFunctionMapper(List taglibs, Map imports, List funcs, Locator loc) {
        return Taglibs.getFunctionMapper((Collection)taglibs, imports, (Collection)funcs, loc);
    }

    public static final FunctionMapper getFunctionMapper(Collection taglibs, Map imports, Collection funcs, Locator loc) {
        Iterator<Object> it;
        TaglibMapper mapper = null;
        if (taglibs != null && !taglibs.isEmpty()) {
            mapper = new TaglibMapper();
            it = taglibs.iterator();
            while (it.hasNext()) {
                mapper.load((Taglib)it.next(), loc);
            }
        }
        if (imports != null && !imports.isEmpty()) {
            if (mapper == null) {
                mapper = new TaglibMapper();
            }
            it = imports.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry me = (Map.Entry)it.next();
                mapper.addClass((String)me.getKey(), (Class)me.getValue());
            }
        }
        if (funcs != null && !funcs.isEmpty()) {
            if (mapper == null) {
                mapper = new TaglibMapper();
            }
            it = funcs.iterator();
            while (it.hasNext()) {
                Object[] o = (Object[])it.next();
                mapper.addFunction((String)o[0], (String)o[1], (Function)o[2]);
            }
        }
        return mapper;
    }

    public static final FunctionMapper getFunctionMapper(List taglibs, Locator loc) {
        return Taglibs.getFunctionMapper((Collection)taglibs, null, loc);
    }

    public static final FunctionMapper getFunctionMapper(Collection taglibs, Locator loc) {
        return Taglibs.getFunctionMapper(taglibs, null, loc);
    }

    public static final Map loadFunctions(URL xmlURL) throws Exception {
        return Taglibs.load(xmlURL)[0];
    }

    public static final Map loadFunctions(Element root) throws Exception {
        return Taglibs.load(root)[0];
    }

    public static final Map[] load(URL xmlURL) throws Exception {
        return (Map[])_reces.get(xmlURL);
    }

    public static final Map[] load(Element root) throws Exception {
        String clsnm;
        String name;
        Element e;
        HashMap<String, MethodFunction> mtds = new HashMap<String, MethodFunction>();
        HashMap<String, Class> clses = new HashMap<String, Class>();
        Exception excp = null;
        Iterator it = root.getElements("function").iterator();
        while (it.hasNext()) {
            Class cls;
            e = (Element)it.next();
            name = IDOMs.getRequiredElementValue(e, "name");
            clsnm = IDOMs.getRequiredElementValue(e, "function-class");
            String sig = IDOMs.getRequiredElementValue(e, "function-signature");
            try {
                cls = Classes.forNameByThread(clsnm);
            }
            catch (ClassNotFoundException ex) {
                log.error("Class not found: " + clsnm + ", " + e.getLocator(), (Throwable)ex);
                excp = ex;
                continue;
            }
            try {
                Method mtd = Classes.getMethodBySignature(cls, sig, null);
                if ((mtd.getModifiers() & 8) != 0) {
                    mtds.put(name, new MethodFunction(mtd));
                    continue;
                }
                log.error("Not a static method: " + mtd);
            }
            catch (ClassNotFoundException ex) {
                log.error("Relavant class not found when loading " + clsnm + ", " + e.getLocator(), (Throwable)ex);
                excp = ex;
            }
            catch (NoSuchMethodException ex) {
                log.error("Method not found in " + clsnm + ": " + sig + " " + e.getLocator(), (Throwable)ex);
                excp = ex;
            }
            catch (IllegalSyntaxException ex) {
                log.error("Illegal Signature: " + sig + " " + e.getLocator(), (Throwable)ex);
                excp = ex;
            }
        }
        it = root.getElements("import").iterator();
        while (it.hasNext()) {
            e = (Element)it.next();
            name = IDOMs.getRequiredElementValue(e, "import-name");
            clsnm = IDOMs.getRequiredElementValue(e, "import-class");
            try {
                clses.put(name, Classes.forNameByThread(clsnm));
            }
            catch (ClassNotFoundException ex) {
                log.error("Class not found: " + clsnm + ", " + e.getLocator(), (Throwable)ex);
                excp = ex;
            }
        }
        if (excp != null) {
            throw excp;
        }
        return new Map[]{mtds, clses};
    }

    public static final URL getDefaultURL(String uri) {
        return (URL)Taglibs.getDefaultTLDs().get(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map getDefaultTLDs() {
        if (_defURLs != null) {
            return _defURLs;
        }
        Class clazz = Taglibs.class;
        synchronized (clazz) {
            if (_defURLs != null) {
                return _defURLs;
            }
            HashMap urls = new HashMap();
            try {
                ClassLocator loc = new ClassLocator();
                Enumeration en = loc.getResources("metainfo/tld/config.xml");
                while (en.hasMoreElements()) {
                    URL url = (URL)en.nextElement();
                    if (log.debugable()) {
                        log.debug("Loading " + url);
                    }
                    try {
                        Document doc = new SAXBuilder(false, false, true).build(url);
                        if (!IDOMs.checkVersion(doc, url)) continue;
                        Taglibs.parseConfig(urls, doc.getRootElement(), loc);
                    }
                    catch (Exception ex) {
                        log.error("Failed to parse " + url, (Throwable)ex);
                    }
                }
            }
            catch (Exception ex) {
                log.error(ex);
            }
            _defURLs = urls.isEmpty() ? Collections.EMPTY_MAP : urls;
            return _defURLs;
        }
    }

    private static void parseConfig(Map urls, Element root, Locator loc) {
        Iterator it = root.getElements("taglib").iterator();
        while (it.hasNext()) {
            Element el = (Element)it.next();
            String s = IDOMs.getRequiredElementValue(el, "taglib-location");
            URL url = loc.getResource(s.startsWith("/") ? s.substring(1) : s);
            if (url != null) {
                urls.put(IDOMs.getRequiredElementValue(el, "taglib-uri"), url);
                continue;
            }
            log.error(s + " not found, " + el.getLocator());
        }
    }

    static {
        try {
            _reces = new ResourceCache(new TaglibLoader());
            _reces.setCheckPeriod(1800000);
        }
        catch (Exception ex) {
            throw XelException.Aide.wrap(ex);
        }
    }

    private static class TaglibLoader
    extends AbstractLoader {
        private TaglibLoader() {
        }

        public Object load(Object src) throws Exception {
            Element root = new SAXBuilder(true, false, true).build((URL)src).getRootElement();
            return Taglibs.load(root);
        }
    }
}

