/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.util.Map;
import org.zkoss.util.Cache;
import org.zkoss.util.CacheMap;

public class ThreadLocalCache
implements Cache {
    private final ThreadLocal _cache = new ThreadLocal();
    private int _maxsize;
    private int _lifetime;

    public ThreadLocalCache(int maxSize, int lifetime) {
        this._maxsize = maxSize;
        this._lifetime = lifetime;
    }

    public ThreadLocalCache() {
        this(1800000, 128);
    }

    public boolean isEmpty() {
        return this.getCache().isEmpty();
    }

    public void copyTo(Map map) {
        map.putAll(this.getCache());
    }

    public boolean containsKey(Object key) {
        return this.getCache().containsKey(key);
    }

    public Object get(Object key) {
        return this.getCache().get(key);
    }

    public Object put(Object key, Object value) {
        return this.getCache().put(key, value);
    }

    public Object remove(Object key) {
        return this.getCache().remove(key);
    }

    public void clear() {
        this.getCache().clear();
    }

    private CacheMap getCache() {
        CacheMap cache = (CacheMap)this._cache.get();
        if (cache == null) {
            cache = new CacheMap(this._maxsize, this._lifetime);
            this._cache.set(cache);
        }
        return cache;
    }

    public int getLifetime() {
        return this._lifetime;
    }

    public void setLifetime(int lifetime) {
        Cache cache = (Cache)this._cache.get();
        if (cache != null) {
            cache.setLifetime(lifetime);
        }
        this._lifetime = lifetime;
    }

    public int getMaxSize() {
        return this._maxsize;
    }

    public void setMaxSize(int maxsize) {
        Cache cache = (Cache)this._cache.get();
        if (cache != null) {
            cache.setMaxSize(maxsize);
        }
        this._maxsize = maxsize;
    }
}

