/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util;

import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.zkoss.util.Locales;
import org.zkoss.util.TimeZones;

public class Dates {
    public static final Date round(Date date, int precision) {
        date.setTime(Dates.round(date.getTime(), precision));
        return date;
    }

    public static final long round(long time, int precision) {
        return time - time % (long)precision;
    }

    public static final boolean isRounded(Date date, int precision) {
        return date.getTime() % (long)precision == 0L;
    }

    public static final Date now(int precision) {
        return new Date(Dates.round(System.currentTimeMillis(), precision));
    }

    public static final Date now() {
        return new Date();
    }

    public static final Date today() {
        return Dates.beginOfDate(new Date(), null);
    }

    public static final Date previousDate(Date when) {
        long time = when.getTime() - 86400000L;
        return new Date(time);
    }

    public static final Date beginOfMonth() {
        return Dates.beginOfMonth(new Date(), null);
    }

    public static final Date beginOfMonth(Date when, TimeZone tz) {
        if (tz == null) {
            tz = TimeZones.getCurrent();
        }
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(when.getTime());
        int year = cal.get(1);
        int month = cal.get(2);
        cal.clear();
        cal.set(year, month, 1);
        return cal.getTime();
    }

    public static final Date endOfMonth() {
        return Dates.endOfMonth(new Date(), null);
    }

    public static final Date endOfMonth(Date when, TimeZone tz) {
        if (tz == null) {
            tz = TimeZones.getCurrent();
        }
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(when.getTime());
        int year = cal.get(1);
        int month = cal.get(2);
        int monthDays = cal.getActualMaximum(5);
        cal.clear();
        cal.set(year, month, monthDays + 1);
        cal.setTimeInMillis(cal.getTimeInMillis() - 1L);
        return cal.getTime();
    }

    public static final boolean isEndOfMonth(Date when, TimeZone tz) {
        if (tz == null) {
            tz = TimeZones.getCurrent();
        }
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(when.getTime());
        int day = cal.get(5);
        int maxDay = cal.getActualMaximum(5);
        return day == maxDay;
    }

    public static final boolean isBeginOfMonth(Date when, TimeZone tz) {
        if (tz == null) {
            tz = TimeZones.getCurrent();
        }
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(when.getTime());
        int day = cal.get(5);
        return day == 1;
    }

    public static final Date beginOfDate(Date when, TimeZone tz) {
        if (tz == null) {
            tz = TimeZones.getCurrent();
        }
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(when.getTime());
        int day = cal.get(5);
        int year = cal.get(1);
        int month = cal.get(2);
        cal.clear();
        cal.set(year, month, day);
        return cal.getTime();
    }

    public static final Date endOfDate(Date when, TimeZone tz) {
        if (tz == null) {
            tz = TimeZones.getCurrent();
        }
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(when.getTime());
        int day = cal.get(5);
        int year = cal.get(1);
        int month = cal.get(2);
        cal.clear();
        cal.set(year, month, day + 1);
        cal.setTimeInMillis(cal.getTimeInMillis() - 1L);
        return cal.getTime();
    }

    public static final Date beginOfYear() {
        return Dates.beginOfYear(new Date(), null);
    }

    public static final Date beginOfYear(Date when, TimeZone tz) {
        if (tz == null) {
            tz = TimeZones.getCurrent();
        }
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(when.getTime());
        int year = cal.get(1);
        cal.clear();
        cal.set(year, 0, 1);
        return cal.getTime();
    }

    public static final Date endOfYear() {
        return Dates.endOfYear(new Date(), null);
    }

    public static final Date endOfYear(Date when, TimeZone tz) {
        if (tz == null) {
            tz = TimeZones.getCurrent();
        }
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(when.getTime());
        int year = cal.get(1);
        cal.clear();
        cal.set(year + 1, 0, 1);
        cal.setTimeInMillis(cal.getTimeInMillis() - 1L);
        return cal.getTime();
    }

    public static final short twoMonthShort() {
        return Dates.twoMonthShort(new Date(), null);
    }

    public static final short twoMonthShort(Date when, TimeZone tz) {
        if (tz == null) {
            tz = TimeZones.getCurrent();
        }
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(when.getTime());
        int month = cal.get(2) / 2 * 2 + 1;
        return (short)month;
    }

    public static final int yearOfDate(Date when, TimeZone tz) {
        if (tz == null) {
            tz = TimeZones.getCurrent();
        }
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(when.getTime());
        return cal.get(1);
    }

    public static final int localizedYearOfDate(Date when, Locale locale, TimeZone tz) {
        if (locale == null) {
            locale = Locales.getCurrent();
        }
        int year = Dates.yearOfDate(when, tz);
        if (locale.equals(Locale.TAIWAN)) {
            return year - 1911;
        }
        return year;
    }

    public static final int monthOfDate(Date when, TimeZone tz) {
        if (tz == null) {
            tz = TimeZones.getCurrent();
        }
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(when.getTime());
        return cal.get(2);
    }

    public static final int monthOfDatePlus1(Date when, TimeZone tz) {
        if (tz == null) {
            tz = TimeZones.getCurrent();
        }
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(when.getTime());
        return cal.get(2) + 1;
    }

    public static final int dayMonthOfDate(Date when, TimeZone tz) {
        if (tz == null) {
            tz = TimeZones.getCurrent();
        }
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(when.getTime());
        return cal.get(5);
    }

    public static final Date add(Date when, TimeZone tz, int field, int amount) {
        if (tz == null) {
            tz = TimeZones.getCurrent();
        }
        Calendar cal = Calendar.getInstance(tz);
        cal.setTimeInMillis(when.getTime());
        cal.add(field, amount);
        return cal.getTime();
    }

    public static final long subtract(Date date2, TimeZone tz, int field, Date date1) {
        if (tz == null) {
            tz = TimeZones.getCurrent();
        }
        boolean negative = false;
        if (date1.after(date2)) {
            negative = true;
            Date d = date1;
            date1 = date2;
            date2 = d;
        }
        Calendar cal1 = Calendar.getInstance(tz);
        cal1.setTimeInMillis(date1.getTime());
        Calendar cal2 = Calendar.getInstance(tz);
        cal2.setTimeInMillis(date2.getTime());
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        switch (field) {
            case 1: {
                return negative ? (long)(year1 - year2) : (long)(year2 - year1);
            }
            case 2: {
                int month1 = cal1.get(2);
                int month2 = cal2.get(2);
                int months = 12 * (year2 - year1) + month2 - month1;
                return negative ? (long)(-months) : (long)months;
            }
            case 10: {
                long time1 = date1.getTime();
                long time2 = date2.getTime();
                long min1 = (time1 < 0L ? time1 - 3599999L : time1) / 3600000L;
                long min2 = (time2 < 0L ? time2 - 3599999L : time2) / 3600000L;
                return negative ? min1 - min2 : min2 - min1;
            }
            case 12: {
                long time1 = date1.getTime();
                long time2 = date2.getTime();
                long min1 = (time1 < 0L ? time1 - 59999L : time1) / 60000L;
                long min2 = (time2 < 0L ? time2 - 59999L : time2) / 60000L;
                return negative ? min1 - min2 : min2 - min1;
            }
            case 13: {
                long time1 = date1.getTime();
                long time2 = date2.getTime();
                long sec1 = (time1 < 0L ? time1 - 999L : time1) / 1000L;
                long sec2 = (time2 < 0L ? time2 - 999L : time2) / 1000L;
                return negative ? sec1 - sec2 : sec2 - sec1;
            }
            case 14: {
                return negative ? date1.getTime() - date2.getTime() : date2.getTime() - date1.getTime();
            }
        }
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int maxDay1 = year1 == year2 ? 0 : cal1.getActualMaximum(6);
        int days = maxDay1 - day1 + day2;
        Calendar cal = Calendar.getInstance(tz);
        for (int year = year1 + 1; year < year2; ++year) {
            cal.set(1, year);
            days += cal.getActualMaximum(6);
        }
        return negative ? (long)(-days) : (long)days;
    }

    public static final Date merge(Date datePart, Date timePart, TimeZone tz) {
        if (tz == null) {
            tz = TimeZones.getCurrent();
        }
        Calendar dateCal = Calendar.getInstance(tz);
        dateCal.setTimeInMillis(datePart.getTime());
        Calendar timeCal = Calendar.getInstance(tz);
        timeCal.setTimeInMillis(timePart.getTime());
        int hour = timeCal.get(10);
        int minute = timeCal.get(12);
        int second = timeCal.get(13);
        int msillisecond = timeCal.get(14);
        dateCal.set(10, hour);
        dateCal.set(12, minute);
        dateCal.set(13, second);
        dateCal.set(14, msillisecond);
        return dateCal.getTime();
    }
}

