/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util.resource;

import org.zkoss.lang.SystemException;
import org.zkoss.text.MessageFormats;
import org.zkoss.util.resource.LabelLocator;
import org.zkoss.util.resource.impl.LabelLoader;
import org.zkoss.xel.VariableResolver;

public class Labels {
    private static final LabelLoader _loader = new LabelLoader();

    private Labels() {
    }

    public static final String getLabel(String key) {
        return _loader.getLabel(key);
    }

    public static final String getLabel(String key, Object[] args) {
        String s = Labels.getLabel(key);
        return s != null ? MessageFormats.format(s, args, null) : null;
    }

    public static final String getRequiredLabel(String key) throws SystemException {
        String s = Labels.getLabel(key);
        if (s == null) {
            throw new SystemException("label not found: " + key);
        }
        return s;
    }

    public static final String getRequiredLabel(String key, Object[] args) {
        String s = Labels.getLabel(key);
        if (s == null) {
            throw new SystemException("label not found: " + key);
        }
        return MessageFormats.format(s, args, null);
    }

    public static final void reset() {
        _loader.reset();
    }

    public static final VariableResolver setVariableResolver(VariableResolver resolv) {
        return _loader.setVariableResolver(resolv);
    }

    public static final void register(LabelLocator locator) {
        _loader.register(locator);
    }
}

