/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util.logging;

import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.zkoss.lang.Exceptions;
import org.zkoss.lang.Objects;
import org.zkoss.mesg.Messages;
import org.zkoss.util.Locales;

public class Log {
    public static final Level ALL = Level.ALL;
    public static final Level ERROR = Level.SEVERE;
    public static final Level WARNING = Level.WARNING;
    public static final Level INFO = Level.INFO;
    public static final Level DEBUG = Level.FINE;
    public static final Level FINER = Level.FINER;
    public static final Level OFF = Level.OFF;
    private static final String DEFAULT_NAME = "org.zkoss";
    private static boolean _hierarchy;
    private String _name;

    public static final boolean isHierarchy() {
        return _hierarchy;
    }

    public static final void setHierarchy(boolean hierarchy) {
        _hierarchy = hierarchy;
    }

    public static final Log lookup(Class cls) {
        return new Log(cls.getName());
    }

    public static final Log lookup(String name) {
        return new Log(name);
    }

    public static final Log lookup(Package pkg) {
        return new Log(pkg.getName());
    }

    protected Log(String name) {
        if (name == null) {
            throw new IllegalArgumentException(name);
        }
        this._name = name;
    }

    public final String getName() {
        return this._name;
    }

    private final Logger getLogger() {
        return Logger.getLogger(_hierarchy ? this._name : DEFAULT_NAME);
    }

    private final Logger getClosestLogger() {
        if (!_hierarchy) {
            return Logger.getLogger(DEFAULT_NAME);
        }
        LogManager logman = LogManager.getLogManager();
        int j = this._name.length();
        do {
            Logger logger;
            if ((logger = logman.getLogger(this._name.substring(0, j))) == null) continue;
            return logger;
        } while ((j = this._name.lastIndexOf(46, j - 1)) >= 0);
        return Logger.getLogger(DEFAULT_NAME);
    }

    private final Logger getLoggerIfAny() {
        return LogManager.getLogManager().getLogger(_hierarchy ? this._name : DEFAULT_NAME);
    }

    public final Level getLevel() {
        Logger logger = this.getLoggerIfAny();
        return logger != null ? logger.getLevel() : null;
    }

    public final void setLevel(Level level) {
        this.getLogger().setLevel(level);
    }

    public static final Level getLevel(String level) {
        if (level != null) {
            if ((level = level.toUpperCase()).equals("DEBUG")) {
                return DEBUG;
            }
            if (level.equals("ERROR")) {
                return ERROR;
            }
            if (level.equals("FINER")) {
                return FINER;
            }
            if (level.equals("INFO")) {
                return INFO;
            }
            if (level.equals("WARNING")) {
                return WARNING;
            }
            if (level.equals("OFF")) {
                return OFF;
            }
        }
        return null;
    }

    public final boolean warningable() {
        return this.getClosestLogger().isLoggable(WARNING);
    }

    public final boolean infoable() {
        return this.getClosestLogger().isLoggable(INFO);
    }

    public final boolean debugable() {
        return this.getClosestLogger().isLoggable(DEBUG);
    }

    public final boolean finerable() {
        return this.getClosestLogger().isLoggable(FINER);
    }

    public final void log(Level level, String msg, Throwable t) {
        Logger logger = this.getClosestLogger();
        if (logger.isLoggable(level)) {
            StackTraceElement[] stack = new Throwable().getStackTrace();
            String cname = "";
            String mname = "";
            for (int j = 0; j < stack.length; ++j) {
                if (stack[j].getClassName().equals("org.zkoss.util.logging.Log")) continue;
                cname = stack[j].getClassName();
                mname = stack[j].getMethodName() + ':' + stack[j].getLineNumber();
                break;
            }
            if (t != null) {
                logger.logp(level, cname, mname, msg, t);
            } else {
                logger.logp(level, cname, mname, msg);
            }
        }
    }

    public final void log(Level level, Object obj, Throwable t) {
        this.log(level, Objects.toString(obj), t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void log(Level level, int code, Object[] fmtArgs, Throwable t) {
        Locale l = Locales.setThreadLocal(null);
        try {
            this.log(level, Messages.get(code, fmtArgs), t);
        }
        finally {
            Locales.setThreadLocal(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void log(Level level, int code, Object fmtArg, Throwable t) {
        Locale l = Locales.setThreadLocal(null);
        try {
            this.log(level, Messages.get(code, fmtArg), t);
        }
        finally {
            Locales.setThreadLocal(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void log(Level level, int code, Throwable t) {
        Locale l = Locales.setThreadLocal(null);
        try {
            this.log(level, Messages.get(code), t);
        }
        finally {
            Locales.setThreadLocal(l);
        }
    }

    public final void error(String msg, Throwable t) {
        this.log(ERROR, msg, t);
    }

    public final void error(String msg) {
        this.log(ERROR, msg, null);
    }

    public final void error(Object obj, Throwable t) {
        this.log(ERROR, obj, t);
    }

    public final void error(Object obj) {
        this.log(ERROR, obj, null);
    }

    public final void error(Throwable t) {
        this.log(ERROR, "", t);
    }

    public final void error(int code, Object[] fmtArgs, Throwable t) {
        this.log(ERROR, code, fmtArgs, t);
    }

    public final void error(int code, Object fmtArg, Throwable t) {
        this.log(ERROR, code, fmtArg, t);
    }

    public final void error(int code, Throwable t) {
        this.log(ERROR, code, t);
    }

    public final void error(int code, Object[] fmtArgs) {
        this.log(ERROR, code, fmtArgs, (Throwable)null);
    }

    public final void error(int code, Object fmtArg) {
        this.log(ERROR, code, fmtArg, null);
    }

    public final void error(int code) {
        this.log(ERROR, code, (Throwable)null);
    }

    public final void warning(String msg, Throwable t) {
        this.log(WARNING, msg, t);
    }

    public final void warning(String msg) {
        this.log(WARNING, msg, null);
    }

    public final void warning(Object obj, Throwable t) {
        this.log(WARNING, obj, t);
    }

    public final void warning(Object obj) {
        this.log(WARNING, obj, null);
    }

    public final void warning(Throwable t) {
        this.log(WARNING, "", t);
    }

    public final void warning(int code, Object[] fmtArgs, Throwable t) {
        this.log(WARNING, code, fmtArgs, t);
    }

    public final void warning(int code, Object fmtArg, Throwable t) {
        this.log(WARNING, code, fmtArg, t);
    }

    public final void warning(int code, Throwable t) {
        this.log(WARNING, code, t);
    }

    public final void warning(int code, Object[] fmtArgs) {
        this.log(WARNING, code, fmtArgs, (Throwable)null);
    }

    public final void warning(int code, Object fmtArg) {
        this.log(WARNING, code, fmtArg, null);
    }

    public final void warning(int code) {
        this.log(WARNING, code, (Throwable)null);
    }

    public final void info(String msg, Throwable t) {
        this.log(INFO, msg, t);
    }

    public final void info(String msg) {
        this.log(INFO, msg, null);
    }

    public final void info(Object obj, Throwable t) {
        this.log(INFO, obj, t);
    }

    public final void info(Object obj) {
        this.log(INFO, obj, null);
    }

    public final void info(Throwable t) {
        this.log(INFO, "", t);
    }

    public final void info(int code, Object[] fmtArgs, Throwable t) {
        this.log(INFO, code, fmtArgs, t);
    }

    public final void info(int code, Object fmtArg, Throwable t) {
        this.log(INFO, code, fmtArg, t);
    }

    public final void info(int code, Throwable t) {
        this.log(INFO, code, t);
    }

    public final void info(int code, Object[] fmtArgs) {
        this.log(INFO, code, fmtArgs, (Throwable)null);
    }

    public final void info(int code, Object fmtArg) {
        this.log(INFO, code, fmtArg, null);
    }

    public final void info(int code) {
        this.log(INFO, code, (Throwable)null);
    }

    public final void debug(String msg, Throwable t) {
        this.log(DEBUG, msg, t);
    }

    public final void debug(String msg) {
        this.log(DEBUG, msg, null);
    }

    public final void debug(Object obj, Throwable t) {
        this.log(DEBUG, obj, t);
    }

    public final void debug(Object obj) {
        this.log(DEBUG, obj, null);
    }

    public final void debug(Throwable t) {
        this.log(DEBUG, "", t);
    }

    public final void debug(int code, Object[] fmtArgs, Throwable t) {
        this.log(DEBUG, code, fmtArgs, t);
    }

    public final void debug(int code, Object fmtArg, Throwable t) {
        this.log(DEBUG, code, fmtArg, t);
    }

    public final void debug(int code, Throwable t) {
        this.log(DEBUG, code, t);
    }

    public final void debug(int code, Object[] fmtArgs) {
        this.log(DEBUG, code, fmtArgs, (Throwable)null);
    }

    public final void debug(int code, Object fmtArg) {
        this.log(DEBUG, code, fmtArg, null);
    }

    public final void debug(int code) {
        this.log(DEBUG, code, (Throwable)null);
    }

    public final void finer(String msg, Throwable t) {
        this.log(FINER, msg, t);
    }

    public final void finer(String msg) {
        this.log(FINER, msg, null);
    }

    public final void finer(Object obj, Throwable t) {
        this.log(FINER, obj, t);
    }

    public final void finer(Object obj) {
        this.log(FINER, obj, null);
    }

    public final void finer(Throwable t) {
        this.log(FINER, "", t);
    }

    public final void finer(int code, Object[] fmtArgs, Throwable t) {
        this.log(FINER, code, fmtArgs, t);
    }

    public final void finer(int code, Object fmtArg, Throwable t) {
        this.log(FINER, code, fmtArg, t);
    }

    public final void finer(int code, Throwable t) {
        this.log(FINER, code, t);
    }

    public final void finer(int code, Object[] fmtArgs) {
        this.log(FINER, code, fmtArgs, (Throwable)null);
    }

    public final void finer(int code, Object fmtArg) {
        this.log(FINER, code, fmtArg, null);
    }

    public final void finer(int code) {
        this.log(FINER, code, (Throwable)null);
    }

    public final void realCause(Throwable ex) {
        this.realCause(null, ex);
    }

    public final void realCause(String message, Throwable ex) {
        this.realCause0(message, ex, true, 0);
    }

    public final void realCauseBriefly(String message, Throwable ex) {
        this.realCause0(message, ex, true, 5);
    }

    public final void realCauseBriefly(Throwable ex) {
        this.realCauseBriefly(null, ex);
    }

    private final void realCause0(String message, Throwable ex, boolean err, int maxcnt) {
        Throwable cause;
        StringBuffer sb = new StringBuffer(1024);
        if (message != null) {
            sb.append(message).append('\n');
        }
        while ((cause = Exceptions.getCause(ex)) != null) {
            sb.append(">>").append(ex.getClass().getName()).append(": ").append(ex.getMessage()).append('\n');
            ex = cause;
        }
        String s = Exceptions.getExtraMessage(ex);
        if (s != null) {
            sb.append(s).append('\n');
        }
        message = Exceptions.formatStackTrace(sb, ex, ">>", maxcnt).toString();
        if (err) {
            this.error(message);
        } else {
            this.warning(message);
        }
    }

    public final void warningBriefly(String message, Throwable ex) {
        this.realCause0(message, ex, false, 3);
    }

    public final void warningBriefly(Throwable ex) {
        this.warningBriefly(null, ex);
    }

    public final void eat(String message, Throwable ex) {
        if (this.debugable()) {
            this.warningBriefly(message, ex);
        } else {
            this.warning("--\t\t------------------------------" + (message != null ? "\n" + message : "") + "\n" + "The exception:\n" + Exceptions.getMessage(ex) + "\n" + "If you want to see the stack trace, turn the DEBUG level on for " + this._name + "\n" + "--\t\t------------------------------");
        }
    }

    public final void eat(Throwable ex) {
        this.eat(null, ex);
    }

    public int hashCode() {
        return this._name.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof Log && ((Log)o)._name.equals(this._name);
    }

    public String toString() {
        return this._name;
    }
}

