/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.io;

import java.io.CharArrayReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.zkoss.io.Repeatable;
import org.zkoss.io.RepeatableFileReader;
import org.zkoss.io.RepeatableInputStream;
import org.zkoss.io.ResetableReader;
import org.zkoss.util.logging.Log;

public class RepeatableReader
extends Reader
implements Repeatable {
    private static final Log log = Log.lookup(RepeatableReader.class);
    private Reader _org;
    private Writer _out;
    private Reader _in;
    private File _f;
    private int _cntsz;
    private final int _bufmaxsz;
    private final int _memmaxsz;
    private boolean _nobuf;

    private RepeatableReader(Reader is) {
        this._org = is;
        this._bufmaxsz = RepeatableInputStream.getIntProp("org.zkoss.io.bufferLimitSize", 0x1400000);
        this._memmaxsz = RepeatableInputStream.getIntProp("org.zkoss.io.memoryLimitSize", 524288);
    }

    public static Reader getInstance(Reader rd) {
        if (rd instanceof CharArrayReader || rd instanceof StringReader) {
            return new ResetableReader(rd);
        }
        if (rd != null && !(rd instanceof Repeatable)) {
            return new RepeatableReader(rd);
        }
        return rd;
    }

    public static Reader getInstance(File file) throws FileNotFoundException {
        if (file == null) {
            throw new IllegalArgumentException("null");
        }
        if (!file.exists()) {
            throw new FileNotFoundException(file.toString());
        }
        return new RepeatableFileReader(file);
    }

    public static Reader getInstance(String filename) throws FileNotFoundException {
        return RepeatableReader.getInstance(new File(filename));
    }

    private Writer getWriter() throws IOException {
        if (this._out == null) {
            Writer writer;
            if (this._nobuf) {
                writer = null;
            } else {
                this._out = new StringWriter();
                writer = this._out;
            }
            return writer;
        }
        if (this._cntsz >= this._bufmaxsz) {
            this.disableBuffering();
            return null;
        }
        if (this._f == null && this._cntsz >= this._memmaxsz) {
            try {
                File f = new File(System.getProperty("java.io.tmpdir"), "zk");
                if (!f.isDirectory()) {
                    f.mkdir();
                }
                this._f = File.createTempFile("zk.io", ".zk.io", f);
                String cnt = ((StringWriter)this._out).toString();
                this._out = new FileWriter(this._f);
                this._out.write(cnt);
            }
            catch (Throwable ex) {
                log.warning("Ingored: failed to buffer to a file, " + this._f + "\nCause: " + ex.getMessage());
                this.disableBuffering();
            }
        }
        return this._out;
    }

    private void disableBuffering() {
        this._nobuf = true;
        if (this._out != null) {
            try {
                this._out.close();
            }
            catch (Throwable ex) {
                // empty catch block
            }
            this._out = null;
        }
        if (this._f != null) {
            try {
                this._f.delete();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this._f = null;
        }
    }

    public int read(char[] cbuf, int off, int len) throws IOException {
        if (this._org != null) {
            int cnt = this._org.read(cbuf, off, len);
            if (!this._nobuf && cnt >= 0) {
                Writer out = this.getWriter();
                if (out != null) {
                    out.write(cbuf, off, cnt);
                }
                this._cntsz += cnt;
            }
            return cnt;
        }
        if (this._in == null) {
            this._in = new FileReader(this._f);
        }
        return this._in.read(cbuf, off, len);
    }

    public void close() throws IOException {
        this._cntsz = 0;
        if (this._org != null) {
            this._org.close();
            if (this._out != null) {
                try {
                    this._out.close();
                }
                catch (Throwable ex) {
                    log.warning("Ignored: failed to close the buffer.\nCause: " + ex.getMessage());
                    this.disableBuffering();
                    return;
                }
                if (this._f == null) {
                    this._in = new StringReader(((StringWriter)this._out).toString());
                }
                this._out = null;
                this._org = null;
            }
        } else if (this._in != null) {
            if (this._f != null) {
                this._in.close();
                this._in = null;
            } else {
                this._in.reset();
            }
        }
    }

    protected void finalize() throws Throwable {
        this.disableBuffering();
        if (this._org != null) {
            this._org.close();
        }
        if (this._in != null) {
            this._in.close();
            this._in = null;
        }
        super.finalize();
    }
}

