/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.util.resource.impl;

import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.zkoss.lang.SystemException;
import org.zkoss.mesg.MCommon;
import org.zkoss.util.Locales;
import org.zkoss.util.Maps;
import org.zkoss.util.WaitLock;
import org.zkoss.util.logging.Log;
import org.zkoss.util.resource.ClassLocator;
import org.zkoss.util.resource.LabelLocator;
import org.zkoss.xel.Expressions;
import org.zkoss.xel.VariableResolver;
import org.zkoss.xel.XelContext;
import org.zkoss.xel.util.SimpleXelContext;

public class LabelLoader {
    private static final Log log = Log.lookup(LabelLoader.class);
    private final Map _labels = new HashMap(6);
    private final List _locators = new LinkedList();
    private XelContext _xelc;

    public String getLabel(String key) {
        String label = this.getProperty(Locales.getCurrent(), key);
        if (label == null || label.length() == 0 || label.indexOf("${") < 0) {
            return label;
        }
        try {
            return (String)Expressions.evaluate(this._xelc, label, String.class);
        }
        catch (Throwable ex) {
            log.error("Illegal label: key=" + key + " value=" + label, ex);
            return label;
        }
    }

    public VariableResolver setVariableResolver(VariableResolver resolv) {
        VariableResolver old = this._xelc != null ? this._xelc.getVariableResolver() : null;
        this._xelc = resolv != null ? new SimpleXelContext(resolv, null) : null;
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(LabelLocator locator) {
        if (locator == null) {
            throw new NullPointerException("locator");
        }
        List list = this._locators;
        synchronized (list) {
            Iterator it = this._locators.iterator();
            while (it.hasNext()) {
                if (!it.next().equals(locator)) continue;
                log.warning("Ignored because of replication: " + locator);
                return;
            }
            this._locators.add(locator);
        }
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        Map map = this._labels;
        synchronized (map) {
            this._labels.clear();
        }
    }

    protected String getProperty(Locale locale, String key) {
        String label = (String)this.getLabels(locale).get(key);
        if (label != null) {
            return label;
        }
        String lang = locale.getLanguage();
        String cnty = locale.getCountry();
        String var = locale.getVariant();
        if (var != null && var.length() > 0 && (label = (String)this.getLabels(new Locale(lang, cnty)).get(key)) != null) {
            return label;
        }
        if (cnty != null && cnty.length() > 0 && (label = (String)this.getLabels(new Locale(lang, "")).get(key)) != null) {
            return label;
        }
        return "en".equals(lang) ? null : (String)this.getLabels(Locale.ENGLISH).get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map getLabels(Locale locale) {
        Map map;
        WaitLock lock = null;
        while (true) {
            Object o;
            map = this._labels;
            synchronized (map) {
                o = this._labels.get(locale);
                if (o == null) {
                    lock = new WaitLock();
                    this._labels.put(locale, lock);
                }
            }
            if (o instanceof Map) {
                return (Map)o;
            }
            if (o == null) break;
            if (((WaitLock)o).waitUntilUnlock(300000)) continue;
            log.warning("Take too long to wait loading labels: " + locale + "\nTry to load again automatically...");
        }
        try {
            URL url;
            log.info("Loading labels for " + locale);
            HashMap labels = new HashMap(617);
            ClassLocator locator = new ClassLocator();
            Enumeration en = locator.getResources(LabelLoader.getI3LabelPath(locale));
            while (en.hasMoreElements()) {
                url = (URL)en.nextElement();
                LabelLoader.load(labels, url);
            }
            Iterator it = this._locators.iterator();
            while (it.hasNext()) {
                url = ((LabelLocator)it.next()).locate(locale);
                if (url == null) continue;
                LabelLoader.load(labels, url);
            }
            HashMap hashMap = this._labels;
            synchronized (hashMap) {
                this._labels.put(locale, labels);
            }
            hashMap = labels;
            return hashMap;
        }
        catch (Throwable ex) {
            map = this._labels;
            synchronized (map) {
                this._labels.remove(locale);
            }
            throw SystemException.Aide.wrap(ex);
        }
        finally {
            lock.unlock();
        }
    }

    private static final String getI3LabelPath(Locale locale) {
        return locale.equals(Locale.ENGLISH) ? "metainfo/i3-label.properties" : "metainfo/i3-label_" + locale + ".properties";
    }

    private static final void load(Map labels, URL url) throws IOException {
        log.info(MCommon.FILE_OPENING, url);
        HashMap news = new HashMap();
        Maps.load(news, url.openStream());
        Iterator it = news.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry me = it.next();
            Object key = me.getKey();
            if (labels.put(key, me.getValue()) == null) continue;
            log.warning("Label of " + key + " is replaced by " + url);
        }
    }
}

